"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checksumFile = exports.makeHash = void 0;
const fslib_1 = require("@yarnpkg/fslib");
const crypto_1 = require("crypto");
function makeHash(...args) {
    const hash = crypto_1.createHash(`sha512`);
    for (const arg of args)
        hash.update(arg ? arg : ``);
    return hash.digest(`hex`);
}
exports.makeHash = makeHash;
function checksumFile(path) {
    return new Promise((resolve, reject) => {
        const fs = new fslib_1.NodeFS();
        const hash = crypto_1.createHash(`sha512`);
        const stream = fs.createReadStream(path, {});
        stream.on(`data`, chunk => {
            hash.update(chunk);
        });
        stream.on(`error`, error => {
            reject(error);
        });
        stream.on(`end`, () => {
            resolve(hash.digest(`hex`));
        });
    });
}
exports.checksumFile = checksumFile;
