/// <reference types="node" />
import { Response } from 'got';
import { Configuration } from './Configuration';
export declare type Body = ({
    [key: string]: any;
} | string | Buffer | null);
export declare enum Method {
    GET = "GET",
    PUT = "PUT"
}
export declare type Options = {
    configuration: Configuration;
    headers?: {
        [headerName: string]: string;
    };
    json?: boolean;
    method?: Method;
};
export declare function request(target: string, body: Body, { configuration, headers, json, method }: Options): Promise<Response<any>>;
export declare function get(target: string, { configuration, json, ...rest }: Options): Promise<any>;
export declare function put(target: string, body: Body, options: Options): Promise<Buffer>;
