/// <reference types="node" />
import { PortablePath } from '@yarnpkg/fslib';
import querystring from 'querystring';
import { Configuration } from './Configuration';
import { Workspace } from './Workspace';
import { Ident, Descriptor, Locator, Package } from './types';
export declare function makeIdent(scope: string | null, name: string): Ident;
export declare function makeDescriptor(ident: Ident, range: string): Descriptor;
export declare function makeLocator(ident: Ident, reference: string): Locator;
export declare function convertToIdent(source: Descriptor | Locator | Package): Ident;
export declare function convertDescriptorToLocator(descriptor: Descriptor): Locator;
export declare function convertLocatorToDescriptor(locator: Locator): Descriptor;
export declare function convertPackageToLocator(pkg: Package): Locator;
export declare function renamePackage(pkg: Package, locator: Locator): Package;
export declare function copyPackage(pkg: Package): Package;
export declare function virtualizeDescriptor(descriptor: Descriptor, entropy: string): Descriptor;
export declare function virtualizePackage(pkg: Package, entropy: string): Package;
export declare function isVirtualDescriptor(descriptor: Descriptor): boolean;
export declare function isVirtualLocator(locator: Locator): boolean;
export declare function devirtualizeDescriptor(descriptor: Descriptor): Descriptor;
export declare function devirtualizeLocator(locator: Locator): Locator;
export declare function bindDescriptor(descriptor: Descriptor, params: {
    [key: string]: string;
}): Descriptor;
export declare function bindLocator(locator: Locator, params: {
    [key: string]: string;
}): Locator;
export declare function areIdentsEqual(a: Ident, b: Ident): boolean;
export declare function areDescriptorsEqual(a: Descriptor, b: Descriptor): boolean;
export declare function areLocatorsEqual(a: Locator, b: Locator): boolean;
/**
 * Virtual packages are considered equivalent when they belong to the same
 * package identity and have the same dependencies. Note that equivalence
 * is not the same as equality, as the references may be different.
 */
export declare function areVirtualPackagesEquivalent(a: Package, b: Package): boolean;
export declare function parseIdent(string: string): Ident;
export declare function tryParseIdent(string: string): Ident | null;
export declare function parseDescriptor(string: string, strict?: boolean): Descriptor;
export declare function tryParseDescriptor(string: string, strict?: boolean): Descriptor | null;
export declare function parseLocator(string: string, strict?: boolean): Locator;
export declare function tryParseLocator(string: string, strict?: boolean): Locator | null;
declare type ParseRangeOptions = {
    requireBindings?: boolean;
    requireProtocol?: boolean | string;
    requireSource?: boolean;
    parseSelector?: boolean;
};
declare type ParseRangeReturnType<Opts extends ParseRangeOptions> = ({
    params: Opts extends {
        requireBindings: true;
    } ? querystring.ParsedUrlQuery : querystring.ParsedUrlQuery | null;
}) & ({
    protocol: Opts extends {
        requireProtocol: true | string;
    } ? string : string | null;
}) & ({
    source: Opts extends {
        requireSource: true;
    } ? string : string | null;
}) & ({
    selector: Opts extends {
        parseSelector: true;
    } ? querystring.ParsedUrlQuery : string;
});
export declare function parseRange<Opts extends ParseRangeOptions>(range: string, opts?: Opts): ParseRangeReturnType<Opts>;
export declare function parseFileStyleRange(range: string, { protocol }: {
    protocol: string;
}): {
    parentLocator: Locator;
    path: PortablePath;
};
export declare function makeRange({ protocol, source, selector, params }: {
    protocol: string | null;
    source: string | null;
    selector: string;
    params: querystring.ParsedUrlQuery | null;
}): string;
/**
 * The range used internally may differ from the range stored in the
 * Manifest (package.json). This removes any params indicated for internal use.
 * An internal param starts with "__".
 * @param range range to convert
 */
export declare function convertToManifestRange(range: string): string;
export declare function requirableIdent(ident: Ident): string;
export declare function stringifyIdent(ident: Ident): string;
export declare function stringifyDescriptor(descriptor: Descriptor): string;
export declare function stringifyLocator(locator: Locator): string;
export declare function slugifyIdent(ident: Ident): string;
export declare function slugifyLocator(locator: Locator): import("@yarnpkg/fslib").Filename;
export declare function prettyIdent(configuration: Configuration, ident: Ident): string;
export declare function prettyRange(configuration: Configuration, range: string): string;
export declare function prettyDescriptor(configuration: Configuration, descriptor: Descriptor): string;
export declare function prettyReference(configuration: Configuration, reference: string): string;
export declare function prettyLocator(configuration: Configuration, locator: Locator): string;
export declare function prettyLocatorNoColors(locator: Locator): string;
export declare function sortDescriptors(descriptors: Iterable<Descriptor>): Descriptor[];
export declare function prettyWorkspace(configuration: Configuration, workspace: Workspace): string;
/**
 * The presence of a `node_modules` directory in the path is extremely common
 * in the JavaScript ecosystem to denote whether a path belongs to a vendor
 * or not. I considered using a more generic path for packages that aren't
 * always JS-only (such as when using the Git fetcher), but that unfortunately
 * caused various JS apps to start showing errors when working with git repos.
 *
 * As a result, all packages from all languages will follow this convention. At
 * least it'll be consistent, and linkers will always have the ability to remap
 * them to a different location if that's a critical requirement.
 */
export declare function getIdentVendorPath(ident: Ident): PortablePath;
export {};
