import { PortablePath } from '@yarnpkg/fslib';
import { DependencyMeta, PeerDependencyMeta } from './Manifest';
export declare type IdentHash = string & {
    __ident_hash: string;
};
export interface Ident {
    identHash: IdentHash;
    scope: string | null;
    name: string;
}
export declare type DescriptorHash = string & {
    __descriptor_hash: string;
};
export interface Descriptor extends Ident {
    descriptorHash: DescriptorHash;
    range: string;
}
export declare type LocatorHash = string & {
    __locator_hash: string;
};
export interface Locator extends Ident {
    locatorHash: LocatorHash;
    reference: string;
}
export declare enum LinkType {
    HARD = "HARD",
    SOFT = "SOFT"
}
export interface Package extends Locator {
    version: string | null;
    languageName: string;
    linkType: LinkType;
    dependencies: Map<IdentHash, Descriptor>;
    peerDependencies: Map<IdentHash, Descriptor>;
    dependenciesMeta: Map<string, Map<string | null, DependencyMeta>>;
    peerDependenciesMeta: Map<string, PeerDependencyMeta>;
    bin: Map<string, PortablePath>;
}
