/// <reference types="node" />
import { CreateReadStreamOptions, CreateWriteStreamOptions, FakeFS, ExtractHintOptions } from './FakeFS';
import { Dirent, SymlinkType } from './FakeFS';
import { MkdirOptions, WriteFileOptions, WatchCallback, WatchOptions, Watcher } from './FakeFS';
import { FSPath, Filename, Path } from './path';
export declare abstract class ProxiedFS<P extends Path, IP extends Path> extends FakeFS<P> {
    protected abstract readonly baseFs: FakeFS<IP>;
    /**
     * Convert a path from the user format into what should be fed into the internal FS.
     */
    protected abstract mapToBase(path: P): IP;
    /**
     * Convert a path from the format supported by the base FS into the user one.
     */
    protected abstract mapFromBase(path: IP): P;
    getExtractHint(hints: ExtractHintOptions): boolean;
    resolve(path: P): P;
    getRealPath(): P;
    openPromise(p: P, flags: string, mode?: number): Promise<number>;
    openSync(p: P, flags: string, mode?: number): number;
    readPromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number | null): Promise<number>;
    readSync(fd: number, buffer: Buffer, offset: number, length: number, position: number): number;
    writePromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): Promise<number>;
    writePromise(fd: number, buffer: string, position?: number): Promise<number>;
    writeSync(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): number;
    writeSync(fd: number, buffer: string, position?: number): number;
    closePromise(fd: number): void;
    closeSync(fd: number): void;
    createReadStream(p: P | null, opts?: CreateReadStreamOptions): import("fs").ReadStream;
    createWriteStream(p: P | null, opts?: CreateWriteStreamOptions): import("fs").WriteStream;
    realpathPromise(p: P): Promise<P>;
    realpathSync(p: P): P;
    existsPromise(p: P): Promise<boolean>;
    existsSync(p: P): boolean;
    accessSync(p: P, mode?: number): void;
    accessPromise(p: P, mode?: number): Promise<void>;
    statPromise(p: P): Promise<import("fs").Stats>;
    statSync(p: P): import("fs").Stats;
    lstatPromise(p: P): Promise<import("fs").Stats>;
    lstatSync(p: P): import("fs").Stats;
    chmodPromise(p: P, mask: number): Promise<void>;
    chmodSync(p: P, mask: number): void;
    renamePromise(oldP: P, newP: P): Promise<void>;
    renameSync(oldP: P, newP: P): void;
    copyFilePromise(sourceP: P, destP: P, flags?: number): Promise<void>;
    copyFileSync(sourceP: P, destP: P, flags?: number): void;
    appendFilePromise(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    appendFileSync(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    writeFilePromise(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    writeFileSync(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    unlinkPromise(p: P): Promise<void>;
    unlinkSync(p: P): void;
    utimesPromise(p: P, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    utimesSync(p: P, atime: Date | string | number, mtime: Date | string | number): void;
    mkdirPromise(p: P, opts?: MkdirOptions): Promise<void>;
    mkdirSync(p: P, opts?: MkdirOptions): void;
    rmdirPromise(p: P): Promise<void>;
    rmdirSync(p: P): void;
    symlinkPromise(target: P, p: P, type?: SymlinkType): Promise<void>;
    symlinkSync(target: P, p: P, type?: SymlinkType): void;
    readFilePromise(p: FSPath<P>, encoding: 'utf8'): Promise<string>;
    readFilePromise(p: FSPath<P>, encoding?: string): Promise<Buffer>;
    readFileSync(p: FSPath<P>, encoding: 'utf8'): string;
    readFileSync(p: FSPath<P>, encoding?: string): Buffer;
    readdirPromise(p: P): Promise<Array<Filename>>;
    readdirPromise(p: P, opts: {
        withFileTypes: false;
    }): Promise<Array<Filename>>;
    readdirPromise(p: P, opts: {
        withFileTypes: true;
    }): Promise<Array<Dirent>>;
    readdirPromise(p: P, opts: {
        withFileTypes: boolean;
    }): Promise<Array<Filename> | Array<Dirent>>;
    readdirSync(p: P): Array<Filename>;
    readdirSync(p: P, opts: {
        withFileTypes: false;
    }): Array<Filename>;
    readdirSync(p: P, opts: {
        withFileTypes: true;
    }): Array<Dirent>;
    readdirSync(p: P, opts: {
        withFileTypes: boolean;
    }): Array<Filename> | Array<Dirent>;
    readlinkPromise(p: P): Promise<P>;
    readlinkSync(p: P): P;
    watch(p: P, cb?: WatchCallback): Watcher;
    watch(p: P, opts: WatchOptions, cb?: WatchCallback): Watcher;
    private fsMapToBase;
}
