"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxiedFS = void 0;
const FakeFS_1 = require("./FakeFS");
class ProxiedFS extends FakeFS_1.FakeFS {
    getExtractHint(hints) {
        return this.baseFs.getExtractHint(hints);
    }
    resolve(path) {
        return this.mapFromBase(this.baseFs.resolve(this.mapToBase(path)));
    }
    getRealPath() {
        return this.mapFromBase(this.baseFs.getRealPath());
    }
    openPromise(p, flags, mode) {
        return this.baseFs.openPromise(this.mapToBase(p), flags, mode);
    }
    openSync(p, flags, mode) {
        return this.baseFs.openSync(this.mapToBase(p), flags, mode);
    }
    async readPromise(fd, buffer, offset, length, position) {
        return await this.baseFs.readPromise(fd, buffer, offset, length, position);
    }
    readSync(fd, buffer, offset, length, position) {
        return this.baseFs.readSync(fd, buffer, offset, length, position);
    }
    async writePromise(fd, buffer, offset, length, position) {
        if (typeof buffer === `string`) {
            return await this.baseFs.writePromise(fd, buffer, offset);
        }
        else {
            return await this.baseFs.writePromise(fd, buffer, offset, length, position);
        }
    }
    writeSync(fd, buffer, offset, length, position) {
        if (typeof buffer === `string`) {
            return this.baseFs.writeSync(fd, buffer, offset);
        }
        else {
            return this.baseFs.writeSync(fd, buffer, offset, length, position);
        }
    }
    closePromise(fd) {
        return this.baseFs.closePromise(fd);
    }
    closeSync(fd) {
        this.baseFs.closeSync(fd);
    }
    createReadStream(p, opts) {
        return this.baseFs.createReadStream(p !== null ? this.mapToBase(p) : p, opts);
    }
    createWriteStream(p, opts) {
        return this.baseFs.createWriteStream(p !== null ? this.mapToBase(p) : p, opts);
    }
    async realpathPromise(p) {
        return this.mapFromBase(await this.baseFs.realpathPromise(this.mapToBase(p)));
    }
    realpathSync(p) {
        return this.mapFromBase(this.baseFs.realpathSync(this.mapToBase(p)));
    }
    existsPromise(p) {
        return this.baseFs.existsPromise(this.mapToBase(p));
    }
    existsSync(p) {
        return this.baseFs.existsSync(this.mapToBase(p));
    }
    accessSync(p, mode) {
        return this.baseFs.accessSync(this.mapToBase(p), mode);
    }
    accessPromise(p, mode) {
        return this.baseFs.accessPromise(this.mapToBase(p), mode);
    }
    statPromise(p) {
        return this.baseFs.statPromise(this.mapToBase(p));
    }
    statSync(p) {
        return this.baseFs.statSync(this.mapToBase(p));
    }
    lstatPromise(p) {
        return this.baseFs.lstatPromise(this.mapToBase(p));
    }
    lstatSync(p) {
        return this.baseFs.lstatSync(this.mapToBase(p));
    }
    chmodPromise(p, mask) {
        return this.baseFs.chmodPromise(this.mapToBase(p), mask);
    }
    chmodSync(p, mask) {
        return this.baseFs.chmodSync(this.mapToBase(p), mask);
    }
    renamePromise(oldP, newP) {
        return this.baseFs.renamePromise(this.mapToBase(oldP), this.mapToBase(newP));
    }
    renameSync(oldP, newP) {
        return this.baseFs.renameSync(this.mapToBase(oldP), this.mapToBase(newP));
    }
    copyFilePromise(sourceP, destP, flags = 0) {
        return this.baseFs.copyFilePromise(this.mapToBase(sourceP), this.mapToBase(destP), flags);
    }
    copyFileSync(sourceP, destP, flags = 0) {
        return this.baseFs.copyFileSync(this.mapToBase(sourceP), this.mapToBase(destP), flags);
    }
    appendFilePromise(p, content, opts) {
        return this.baseFs.appendFilePromise(this.fsMapToBase(p), content, opts);
    }
    appendFileSync(p, content, opts) {
        return this.baseFs.appendFileSync(this.fsMapToBase(p), content, opts);
    }
    writeFilePromise(p, content, opts) {
        return this.baseFs.writeFilePromise(this.fsMapToBase(p), content, opts);
    }
    writeFileSync(p, content, opts) {
        return this.baseFs.writeFileSync(this.fsMapToBase(p), content, opts);
    }
    unlinkPromise(p) {
        return this.baseFs.unlinkPromise(this.mapToBase(p));
    }
    unlinkSync(p) {
        return this.baseFs.unlinkSync(this.mapToBase(p));
    }
    utimesPromise(p, atime, mtime) {
        return this.baseFs.utimesPromise(this.mapToBase(p), atime, mtime);
    }
    utimesSync(p, atime, mtime) {
        return this.baseFs.utimesSync(this.mapToBase(p), atime, mtime);
    }
    mkdirPromise(p, opts) {
        return this.baseFs.mkdirPromise(this.mapToBase(p), opts);
    }
    mkdirSync(p, opts) {
        return this.baseFs.mkdirSync(this.mapToBase(p), opts);
    }
    rmdirPromise(p) {
        return this.baseFs.rmdirPromise(this.mapToBase(p));
    }
    rmdirSync(p) {
        return this.baseFs.rmdirSync(this.mapToBase(p));
    }
    symlinkPromise(target, p, type) {
        return this.baseFs.symlinkPromise(this.mapToBase(target), this.mapToBase(p), type);
    }
    symlinkSync(target, p, type) {
        return this.baseFs.symlinkSync(this.mapToBase(target), this.mapToBase(p), type);
    }
    readFilePromise(p, encoding) {
        // This weird condition is required to tell TypeScript that the signatures are proper (otherwise it thinks that only the generic one is covered)
        if (encoding === `utf8`) {
            return this.baseFs.readFilePromise(this.fsMapToBase(p), encoding);
        }
        else {
            return this.baseFs.readFilePromise(this.fsMapToBase(p), encoding);
        }
    }
    readFileSync(p, encoding) {
        // This weird condition is required to tell TypeScript that the signatures are proper (otherwise it thinks that only the generic one is covered)
        if (encoding === `utf8`) {
            return this.baseFs.readFileSync(this.fsMapToBase(p), encoding);
        }
        else {
            return this.baseFs.readFileSync(this.fsMapToBase(p), encoding);
        }
    }
    async readdirPromise(p, { withFileTypes } = {}) {
        return this.baseFs.readdirPromise(this.mapToBase(p), { withFileTypes: withFileTypes });
    }
    readdirSync(p, { withFileTypes } = {}) {
        return this.baseFs.readdirSync(this.mapToBase(p), { withFileTypes: withFileTypes });
    }
    async readlinkPromise(p) {
        return this.mapFromBase(await this.baseFs.readlinkPromise(this.mapToBase(p)));
    }
    readlinkSync(p) {
        return this.mapFromBase(this.baseFs.readlinkSync(this.mapToBase(p)));
    }
    watch(p, a, b) {
        return this.baseFs.watch(this.mapToBase(p), 
        // @ts-ignore
        a, b);
    }
    fsMapToBase(p) {
        if (typeof p === `number`) {
            return p;
        }
        else {
            return this.mapToBase(p);
        }
    }
}
exports.ProxiedFS = ProxiedFS;
