/// <reference types="node" />
import { Libzip } from '@yarnpkg/libzip';
import { CreateReadStreamOptions, CreateWriteStreamOptions, BasePortableFakeFS, ExtractHintOptions } from './FakeFS';
import { Dirent, SymlinkType } from './FakeFS';
import { FakeFS, MkdirOptions, WriteFileOptions } from './FakeFS';
import { WatchOptions, WatchCallback, Watcher } from './FakeFS';
import { Filename, FSPath, PortablePath } from './path';
export declare type ZipOpenFSOptions = {
    baseFs?: FakeFS<PortablePath>;
    filter?: RegExp | null;
    libzip: Libzip;
    maxOpenFiles?: number;
    readOnlyArchives?: boolean;
    useCache?: boolean;
};
export declare class ZipOpenFS extends BasePortableFakeFS {
    static openPromise<T>(fn: (zipOpenFs: ZipOpenFS) => Promise<T>, opts: ZipOpenFSOptions): Promise<T>;
    private readonly libzip;
    private readonly baseFs;
    private readonly zipInstances;
    private readonly fdMap;
    private nextFd;
    private readonly filter;
    private readonly maxOpenFiles;
    private readonly readOnlyArchives;
    private isZip;
    private notZip;
    constructor({ libzip, baseFs, filter, maxOpenFiles, readOnlyArchives, useCache }: ZipOpenFSOptions);
    getExtractHint(hints: ExtractHintOptions): boolean;
    getRealPath(): PortablePath;
    saveAndClose(): void;
    discardAndClose(): void;
    resolve(p: PortablePath): PortablePath;
    private remapFd;
    openPromise(p: PortablePath, flags: string, mode?: number): Promise<number>;
    openSync(p: PortablePath, flags: string, mode?: number): number;
    readPromise(fd: number, buffer: Buffer, offset: number, length: number, position: number): Promise<number>;
    readSync(fd: number, buffer: Buffer, offset: number, length: number, position: number): number;
    writePromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): Promise<number>;
    writePromise(fd: number, buffer: string, position?: number): Promise<number>;
    writeSync(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): number;
    writeSync(fd: number, buffer: string, position?: number): number;
    closePromise(fd: number): Promise<void>;
    closeSync(fd: number): void;
    createReadStream(p: PortablePath | null, opts?: CreateReadStreamOptions): import("fs").ReadStream;
    createWriteStream(p: PortablePath | null, opts?: CreateWriteStreamOptions): import("fs").WriteStream;
    realpathPromise(p: PortablePath): Promise<PortablePath>;
    realpathSync(p: PortablePath): PortablePath;
    existsPromise(p: PortablePath): Promise<boolean>;
    existsSync(p: PortablePath): boolean;
    accessPromise(p: PortablePath, mode?: number): Promise<void>;
    accessSync(p: PortablePath, mode?: number): void;
    statPromise(p: PortablePath): Promise<import("fs").Stats>;
    statSync(p: PortablePath): import("fs").Stats;
    lstatPromise(p: PortablePath): Promise<import("fs").Stats>;
    lstatSync(p: PortablePath): import("fs").Stats;
    chmodPromise(p: PortablePath, mask: number): Promise<void>;
    chmodSync(p: PortablePath, mask: number): void;
    renamePromise(oldP: PortablePath, newP: PortablePath): Promise<void>;
    renameSync(oldP: PortablePath, newP: PortablePath): void;
    copyFilePromise(sourceP: PortablePath, destP: PortablePath, flags?: number): Promise<void>;
    copyFileSync(sourceP: PortablePath, destP: PortablePath, flags?: number): void;
    appendFilePromise(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): Promise<void>;
    appendFileSync(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    writeFilePromise(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): Promise<void>;
    writeFileSync(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    unlinkPromise(p: PortablePath): Promise<void>;
    unlinkSync(p: PortablePath): void;
    utimesPromise(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    utimesSync(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): void;
    mkdirPromise(p: PortablePath, opts?: MkdirOptions): Promise<void>;
    mkdirSync(p: PortablePath, opts?: MkdirOptions): void;
    rmdirPromise(p: PortablePath): Promise<void>;
    rmdirSync(p: PortablePath): void;
    symlinkPromise(target: PortablePath, p: PortablePath, type?: SymlinkType): Promise<void>;
    symlinkSync(target: PortablePath, p: PortablePath, type?: SymlinkType): void;
    readFilePromise(p: FSPath<PortablePath>, encoding: 'utf8'): Promise<string>;
    readFilePromise(p: FSPath<PortablePath>, encoding?: string): Promise<Buffer>;
    readFileSync(p: FSPath<PortablePath>, encoding: 'utf8'): string;
    readFileSync(p: FSPath<PortablePath>, encoding?: string): Buffer;
    readdirPromise(p: PortablePath): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: false;
    }): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: true;
    }): Promise<Array<Dirent>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: boolean;
    }): Promise<Array<Filename> | Array<Dirent>>;
    readdirSync(p: PortablePath): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: false;
    }): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: true;
    }): Array<Dirent>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: boolean;
    }): Array<Filename> | Array<Dirent>;
    readlinkPromise(p: PortablePath): Promise<PortablePath>;
    readlinkSync(p: PortablePath): PortablePath;
    watch(p: PortablePath, cb?: WatchCallback): Watcher;
    watch(p: PortablePath, opts: WatchOptions, cb?: WatchCallback): Watcher;
    private makeCallPromise;
    private makeCallSync;
    private findZip;
    private limitOpenFiles;
    private getZipPromise;
    private getZipSync;
}
