/// <reference types="node" />
import { Dirent as NodeDirent, ReadStream, Stats, WriteStream } from 'fs';
import { FSPath, Path, PortablePath, PathUtils, Filename } from './path';
export declare type Dirent = Exclude<NodeDirent, 'name'> & {
    name: Filename;
};
export declare type CreateReadStreamOptions = Partial<{
    encoding: string;
    fd: number;
}>;
export declare type CreateWriteStreamOptions = Partial<{
    encoding: string;
    fd: number;
    flags: 'a';
}>;
export declare type MkdirOptions = Partial<{
    recursive: boolean;
    mode: number;
}>;
export declare type WriteFileOptions = Partial<{
    encoding: string;
    mode: number;
    flag: string;
}> | string;
export declare type WatchOptions = Partial<{
    persistent: boolean;
    recursive: boolean;
    encoding: string;
}> | string;
export declare type ChangeFileOptions = Partial<{
    automaticNewlines: boolean;
}>;
export declare type WatchCallback = (eventType: string, filename: string) => void;
export declare type Watcher = {
    on: any;
    close: () => void;
};
export declare type ExtractHintOptions = {
    relevantExtensions: Set<string>;
};
export declare type SymlinkType = 'file' | 'dir' | 'junction';
export declare abstract class FakeFS<P extends Path> {
    static DEFAULT_TIME: number;
    readonly pathUtils: PathUtils<P>;
    protected constructor(pathUtils: PathUtils<P>);
    abstract getExtractHint(hints: ExtractHintOptions): boolean;
    abstract getRealPath(): P;
    abstract resolve(p: P): P;
    abstract openPromise(p: P, flags: string, mode?: number): Promise<number>;
    abstract openSync(p: P, flags: string, mode?: number): number;
    abstract readPromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number | null): Promise<number>;
    abstract readSync(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number | null): number;
    abstract writePromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): Promise<number>;
    abstract writePromise(fd: number, buffer: string, position?: number): Promise<number>;
    abstract writeSync(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): number;
    abstract writeSync(fd: number, buffer: string, position?: number): number;
    abstract closePromise(fd: number): void;
    abstract closeSync(fd: number): void;
    abstract createWriteStream(p: P | null, opts?: CreateWriteStreamOptions): WriteStream;
    abstract createReadStream(p: P | null, opts?: CreateReadStreamOptions): ReadStream;
    abstract realpathPromise(p: P): Promise<P>;
    abstract realpathSync(p: P): P;
    abstract readdirPromise(p: P): Promise<Array<Filename>>;
    abstract readdirPromise(p: P, opts: {
        withFileTypes: false;
    }): Promise<Array<Filename>>;
    abstract readdirPromise(p: P, opts: {
        withFileTypes: true;
    }): Promise<Array<Dirent>>;
    abstract readdirPromise(p: P, opts: {
        withFileTypes: boolean;
    }): Promise<Array<Filename> | Array<Dirent>>;
    abstract readdirSync(p: P): Array<Filename>;
    abstract readdirSync(p: P, opts: {
        withFileTypes: false;
    }): Array<Filename>;
    abstract readdirSync(p: P, opts: {
        withFileTypes: true;
    }): Array<Dirent>;
    abstract readdirSync(p: P, opts: {
        withFileTypes: boolean;
    }): Array<Filename> | Array<Dirent>;
    abstract existsPromise(p: P): Promise<boolean>;
    abstract existsSync(p: P): boolean;
    abstract accessPromise(p: P, mode?: number): Promise<void>;
    abstract accessSync(p: P, mode?: number): void;
    abstract statPromise(p: P): Promise<Stats>;
    abstract statSync(p: P): Stats;
    abstract lstatPromise(p: P): Promise<Stats>;
    abstract lstatSync(p: P): Stats;
    abstract chmodPromise(p: P, mask: number): Promise<void>;
    abstract chmodSync(p: P, mask: number): void;
    abstract mkdirPromise(p: P, opts?: MkdirOptions): Promise<void>;
    abstract mkdirSync(p: P, opts?: MkdirOptions): void;
    abstract rmdirPromise(p: P): Promise<void>;
    abstract rmdirSync(p: P): void;
    abstract symlinkPromise(target: P, p: P, type?: SymlinkType): Promise<void>;
    abstract symlinkSync(target: P, p: P, type?: SymlinkType): void;
    abstract renamePromise(oldP: P, newP: P): Promise<void>;
    abstract renameSync(oldP: P, newP: P): void;
    abstract copyFilePromise(sourceP: P, destP: P, flags?: number): Promise<void>;
    abstract copyFileSync(sourceP: P, destP: P, flags?: number): void;
    abstract appendFilePromise(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    abstract appendFileSync(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    abstract writeFilePromise(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    abstract writeFileSync(p: FSPath<P>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    abstract unlinkPromise(p: P): Promise<void>;
    abstract unlinkSync(p: P): void;
    abstract utimesPromise(p: P, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    abstract utimesSync(p: P, atime: Date | string | number, mtime: Date | string | number): void;
    lutimesPromise?(p: P, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    lutimesSync?(p: P, atime: Date | string | number, mtime: Date | string | number): void;
    abstract readFilePromise(p: FSPath<P>, encoding: 'utf8'): Promise<string>;
    abstract readFilePromise(p: FSPath<P>, encoding?: string): Promise<Buffer>;
    abstract readFileSync(p: FSPath<P>, encoding: 'utf8'): string;
    abstract readFileSync(p: FSPath<P>, encoding?: string): Buffer;
    abstract readlinkPromise(p: P): Promise<P>;
    abstract readlinkSync(p: P): P;
    abstract watch(p: P, cb?: WatchCallback): Watcher;
    abstract watch(p: P, opts: WatchOptions, cb?: WatchCallback): Watcher;
    removePromise(p: P): Promise<void>;
    removeSync(p: P): void;
    mkdirpPromise(p: P, { chmod, utimes }?: {
        chmod?: number;
        utimes?: [Date | string | number, Date | string | number];
    }): Promise<void>;
    mkdirpSync(p: P, { chmod, utimes }?: {
        chmod?: number;
        utimes?: [Date | string | number, Date | string | number];
    }): void;
    copyPromise(destination: P, source: P, options?: {
        baseFs?: undefined;
        overwrite?: boolean;
        stableSort?: boolean;
        stableTime?: boolean;
    }): Promise<void>;
    copyPromise<P2 extends Path>(destination: P, source: P2, options: {
        baseFs: FakeFS<P2>;
        overwrite?: boolean;
        stableSort?: boolean;
        stableTime?: boolean;
    }): Promise<void>;
    /** @deprecated Prefer using `copyPromise` instead */
    copySync(destination: P, source: P, options?: {
        baseFs?: undefined;
        overwrite?: boolean;
    }): void;
    copySync<P2 extends Path>(destination: P, source: P2, options: {
        baseFs: FakeFS<P2>;
        overwrite?: boolean;
    }): void;
    changeFilePromise(p: P, content: string, { automaticNewlines }?: ChangeFileOptions): Promise<void>;
    changeFileSync(p: P, content: string, { automaticNewlines }?: ChangeFileOptions): void;
    movePromise(fromP: P, toP: P): Promise<void>;
    moveSync(fromP: P, toP: P): void;
    lockPromise<T>(affectedPath: P, callback: () => Promise<T>): Promise<T>;
    readJsonPromise(p: P): Promise<any>;
    readJsonSync(p: P): Promise<any>;
    writeJsonPromise(p: P, data: any): Promise<void>;
    writeJsonSync(p: P, data: any): void;
    preserveTimePromise(p: P, cb: () => Promise<P | void>): Promise<void>;
    preserveTimeSync(p: P, cb: () => P | void): Promise<void>;
}
export declare abstract class BasePortableFakeFS extends FakeFS<PortablePath> {
    protected constructor();
}
export declare function normalizeLineEndings(originalContent: string, newContent: string): string;
