/// <reference types="node" />
import { Libzip } from '@yarnpkg/libzip';
import { ReadStream, Stats, WriteStream } from 'fs';
import { CreateReadStreamOptions, CreateWriteStreamOptions, BasePortableFakeFS, ExtractHintOptions } from './FakeFS';
import { FakeFS, MkdirOptions, WriteFileOptions } from './FakeFS';
import { WatchOptions, WatchCallback, Watcher } from './FakeFS';
import { FSPath, PortablePath, Filename } from './path';
export declare type ZipCompression = `mixed` | 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9;
export declare const DEFAULT_COMPRESSION_LEVEL: ZipCompression;
declare class DirEntry {
    name: Filename;
    mode: number;
    isBlockDevice(): boolean;
    isCharacterDevice(): boolean;
    isDirectory(): boolean;
    isFIFO(): boolean;
    isFile(): boolean;
    isSocket(): boolean;
    isSymbolicLink(): boolean;
}
export declare type ZipBufferOptions = {
    libzip: Libzip;
    readOnly?: boolean;
    stats?: Stats;
    level?: ZipCompression;
};
export declare type ZipPathOptions = ZipBufferOptions & {
    baseFs?: FakeFS<PortablePath>;
    create?: boolean;
};
export declare class ZipFS extends BasePortableFakeFS {
    private readonly libzip;
    private readonly baseFs;
    private readonly path;
    private readonly stats;
    private readonly zip;
    private readonly lzSource;
    private readonly level;
    private readonly listings;
    private readonly entries;
    private symlinkCount;
    private readonly fds;
    private nextFd;
    private ready;
    private readOnly;
    constructor(p: PortablePath, opts: ZipPathOptions);
    /**
     * Create a ZipFS in memory
     * @param data If null; an empty zip file will be created
     */
    constructor(data: Buffer | null, opts: ZipBufferOptions);
    getExtractHint(hints: ExtractHintOptions): boolean;
    getAllFiles(): PortablePath[];
    getRealPath(): PortablePath;
    getBufferAndClose(): Buffer;
    saveAndClose(): void;
    discardAndClose(): void;
    resolve(p: PortablePath): PortablePath;
    openPromise(p: PortablePath, flags: string, mode?: number): Promise<number>;
    openSync(p: PortablePath, flags: string, mode?: number): number;
    readPromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number | null): Promise<number>;
    readSync(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number | null): number;
    writePromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): Promise<number>;
    writePromise(fd: number, buffer: string, position?: number): Promise<number>;
    writeSync(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): number;
    writeSync(fd: number, buffer: string, position?: number): number;
    closePromise(fd: number): Promise<void>;
    closeSync(fd: number): void;
    createReadStream(p: PortablePath | null, { encoding }?: CreateReadStreamOptions): ReadStream;
    createWriteStream(p: PortablePath | null, { encoding }?: CreateWriteStreamOptions): WriteStream;
    realpathPromise(p: PortablePath): Promise<PortablePath>;
    realpathSync(p: PortablePath): PortablePath;
    existsPromise(p: PortablePath): Promise<boolean>;
    existsSync(p: PortablePath): boolean;
    accessPromise(p: PortablePath, mode?: number): Promise<void>;
    accessSync(p: PortablePath, mode?: number): void;
    statPromise(p: PortablePath): Promise<Stats>;
    statSync(p: PortablePath): Stats;
    lstatPromise(p: PortablePath): Promise<Stats>;
    lstatSync(p: PortablePath): Stats;
    private statImpl;
    private getUnixMode;
    private registerListing;
    private registerEntry;
    private resolveFilename;
    private allocateBuffer;
    private allocateUnattachedSource;
    private allocateSource;
    private setFileSource;
    private isSymbolicLink;
    private getFileSource;
    chmodPromise(p: PortablePath, mask: number): Promise<void>;
    chmodSync(p: PortablePath, mask: number): void;
    renamePromise(oldP: PortablePath, newP: PortablePath): Promise<never>;
    renameSync(oldP: PortablePath, newP: PortablePath): never;
    copyFilePromise(sourceP: PortablePath, destP: PortablePath, flags?: number): Promise<void>;
    copyFileSync(sourceP: PortablePath, destP: PortablePath, flags?: number): void;
    appendFilePromise(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): Promise<void>;
    appendFileSync(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    writeFilePromise(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): Promise<void>;
    writeFileSync(p: FSPath<PortablePath>, content: string | Buffer | ArrayBuffer | DataView, opts?: WriteFileOptions): void;
    unlinkPromise(p: PortablePath): Promise<void>;
    unlinkSync(p: PortablePath): void;
    utimesPromise(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    utimesSync(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): void;
    lutimesPromise(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    lutimesSync(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): void;
    private utimesImpl;
    mkdirPromise(p: PortablePath, opts?: MkdirOptions): Promise<void>;
    mkdirSync(p: PortablePath, { mode, recursive }?: MkdirOptions): void;
    rmdirPromise(p: PortablePath): Promise<void>;
    rmdirSync(p: PortablePath): void;
    private hydrateDirectory;
    symlinkPromise(target: PortablePath, p: PortablePath): Promise<void>;
    symlinkSync(target: PortablePath, p: PortablePath): void;
    readFilePromise(p: FSPath<PortablePath>, encoding: 'utf8'): Promise<string>;
    readFilePromise(p: FSPath<PortablePath>, encoding?: string): Promise<Buffer>;
    readFileSync(p: FSPath<PortablePath>, encoding: 'utf8'): string;
    readFileSync(p: FSPath<PortablePath>, encoding?: string): Buffer;
    readdirPromise(p: PortablePath): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: false;
    }): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: true;
    }): Promise<Array<DirEntry>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: boolean;
    }): Promise<Array<Filename> | Array<DirEntry>>;
    readdirSync(p: PortablePath): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: false;
    }): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: true;
    }): Array<DirEntry>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: boolean;
    }): Array<Filename> | Array<DirEntry>;
    readlinkPromise(p: PortablePath): Promise<PortablePath>;
    readlinkSync(p: PortablePath): PortablePath;
    watch(p: PortablePath, cb?: WatchCallback): Watcher;
    watch(p: PortablePath, opts: WatchOptions, cb?: WatchCallback): Watcher;
}
export {};
