/// <reference types="node" />
import fs from 'fs';
import { FakeFS } from './FakeFS';
import { NodeFS } from './NodeFS';
import { PortablePath, NativePath } from './path';
export { normalizeLineEndings } from './FakeFS';
export type { CreateReadStreamOptions } from './FakeFS';
export type { CreateWriteStreamOptions } from './FakeFS';
export type { Dirent, SymlinkType } from './FakeFS';
export type { MkdirOptions } from './FakeFS';
export type { WatchOptions } from './FakeFS';
export type { WatchCallback } from './FakeFS';
export type { Watcher } from './FakeFS';
export type { WriteFileOptions } from './FakeFS';
export type { ExtractHintOptions } from './FakeFS';
export { DEFAULT_COMPRESSION_LEVEL } from './ZipFS';
export type { ZipCompression } from './ZipFS';
export { PortablePath, Filename } from './path';
export type { FSPath, Path, NativePath } from './path';
export type { ParsedPath, PathUtils, FormatInputPathObject } from './path';
export { npath, ppath, toFilename } from './path';
export { AliasFS } from './AliasFS';
export { FakeFS } from './FakeFS';
export { CwdFS } from './CwdFS';
export { JailFS } from './JailFS';
export { LazyFS } from './LazyFS';
export { NoFS } from './NoFS';
export { NodeFS } from './NodeFS';
export { PosixFS } from './PosixFS';
export { ProxiedFS } from './ProxiedFS';
export { VirtualFS } from './VirtualFS';
export { ZipFS } from './ZipFS';
export { ZipOpenFS } from './ZipOpenFS';
export declare function patchFs(patchedFs: typeof fs, fakeFs: FakeFS<NativePath>): void;
export declare function extendFs(realFs: typeof fs, fakeFs: FakeFS<NativePath>): typeof fs;
export declare type XFS = NodeFS & {
    detachTemp(p: PortablePath): void;
    mktempSync(): PortablePath;
    mktempSync<T>(cb: (p: PortablePath) => T): T;
    mktempPromise(): Promise<PortablePath>;
    mktempPromise<T>(cb: (p: PortablePath) => Promise<T>): Promise<T>;
};
export declare const xfs: XFS;
