"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLibzipPromise = exports.getLibzipSync = void 0;
const makeInterface_1 = require("./makeInterface");
let promise = null;
function getLibzipSync() {
    throw new Error(`Cannot use getLibzipSync when using the async version of the libzip`);
}
exports.getLibzipSync = getLibzipSync;
async function getLibzipPromise() {
    if (promise === null) {
        promise = new Promise(resolve => {
            require(`./libzipAsync`).then((libzip) => {
                resolve(makeInterface_1.makeInterface(libzip));
            });
        });
    }
}
exports.getLibzipPromise = getLibzipPromise;
