"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseShell = void 0;
const shell_1 = require("./grammars/shell");
function parseShell(source, options = { isGlobPattern: () => false }) {
    try {
        return shell_1.parse(source, options);
    }
    catch (error) {
        if (error.location)
            error.message = error.message.replace(/(\.)?$/, ` (line ${error.location.start.line}, column ${error.location.start.column})$1`);
        throw error;
    }
}
exports.parseShell = parseShell;
