/// <reference types="node" />
import { PortablePath, FakeFS } from '@yarnpkg/fslib';
import { Readable, Writable } from 'stream';
import { ProcessImplementation } from './pipe';
export declare type Glob = {
    isGlobPattern: (arg: string) => boolean;
    match: (pattern: string, options: {
        cwd: PortablePath;
        fs?: FakeFS<PortablePath>;
    }) => Promise<Array<string>>;
};
export declare type UserOptions = {
    builtins: {
        [key: string]: ShellBuiltin;
    };
    cwd: PortablePath;
    env: {
        [key: string]: string | undefined;
    };
    stdin: Readable | null;
    stdout: Writable;
    stderr: Writable;
    variables: {
        [key: string]: string;
    };
    glob: Glob;
};
export declare type ShellBuiltin = (args: Array<string>, opts: ShellOptions, state: ShellState) => Promise<number>;
export declare type ShellOptions = {
    args: Array<string>;
    builtins: Map<string, ShellBuiltin>;
    initialStdin: Readable;
    initialStdout: Writable;
    initialStderr: Writable;
    glob: Glob;
};
export declare type ShellState = {
    cwd: PortablePath;
    environment: {
        [key: string]: string;
    };
    exitCode: number | null;
    procedures: {
        [key: string]: ProcessImplementation;
    };
    stdin: Readable;
    stdout: Writable;
    stderr: Writable;
    variables: {
        [key: string]: string;
    };
};
export declare function execute(command: string, args?: Array<string>, { builtins, cwd, env, stdin, stdout, stderr, variables, glob, }?: Partial<UserOptions>): Promise<number>;
