Object.defineProperty(exports, "__esModule", {
  value: true
});
exports['default'] = disallowedIf;

var _wrapValidator = require('./helpers/wrapValidator');

var _wrapValidator2 = _interopRequireDefault(_wrapValidator);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function disallowedIf(propType, otherPropName, otherPropType) {
  if (typeof propType !== 'function' || typeof propType.isRequired !== 'function') {
    throw new TypeError('a propType validator is required; propType validators must also provide `.isRequired`');
  }

  if (typeof otherPropName !== 'string') {
    throw new TypeError('other prop name must be a string');
  }

  if (typeof otherPropType !== 'function') {
    throw new TypeError('other prop type validator is required');
  }

  function disallowedIfRequired(props, propName, componentName) {
    for (var _len = arguments.length, rest = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      rest[_key - 3] = arguments[_key];
    }

    var error = propType.isRequired.apply(propType, [props, propName, componentName].concat(rest));
    if (error) {
      return error;
    }

    if (props[otherPropName] == null) {
      return null;
    }

    var otherError = otherPropType.apply(undefined, [props, otherPropName, componentName].concat(rest));
    if (otherError) {
      return null;
    }
    return new Error('prop \u201C' + String(propName) + '\u201D is disallowed when \u201C' + String(otherPropName) + '\u201D matches the provided validator');
  }

  var validator = function () {
    function disallowedIfPropType(props, propName) {
      if (props[propName] == null) {
        return null;
      }

      for (var _len2 = arguments.length, rest = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        rest[_key2 - 2] = arguments[_key2];
      }

      return disallowedIfRequired.apply(undefined, [props, propName].concat(rest));
    }

    return disallowedIfPropType;
  }();

  validator.isRequired = disallowedIfRequired;

  return (0, _wrapValidator2['default'])(validator, 'disallowedIf', { propType: propType, otherPropName: otherPropName, otherPropType: otherPropType });
}
//# sourceMappingURL=disallowedIf.js.map