Object.defineProperty(exports, "__esModule", {
  value: true
});
exports['default'] = getRequiredBy;

var _objectIs = require('object-is');

var _objectIs2 = _interopRequireDefault(_objectIs);

var _wrapValidator = require('./helpers/wrapValidator');

var _wrapValidator2 = _interopRequireDefault(_wrapValidator);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function getRequiredBy(requiredByPropName, propType) {
  var defaultValue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  function requiredBy(props, propName, componentName) {
    if (props[requiredByPropName]) {
      var propValue = props[propName];

      if ((0, _objectIs2['default'])(propValue, defaultValue) || typeof propValue === 'undefined') {
        return new TypeError(String(componentName) + ': when ' + String(requiredByPropName) + ' is true, prop \u201C' + String(propName) + '\u201D must be present.');
      }
    }

    for (var _len = arguments.length, rest = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      rest[_key - 3] = arguments[_key];
    }

    return propType.apply(undefined, [props, propName, componentName].concat(rest));
  }
  requiredBy.isRequired = function () {
    function requiredByRequired(props, propName, componentName) {
      var propValue = props[propName];

      if ((0, _objectIs2['default'])(propValue, defaultValue)) {
        return new TypeError(String(componentName) + ': prop \u201C' + String(propName) + '\u201D must be present.');
      }

      for (var _len2 = arguments.length, rest = Array(_len2 > 3 ? _len2 - 3 : 0), _key2 = 3; _key2 < _len2; _key2++) {
        rest[_key2 - 3] = arguments[_key2];
      }

      return propType.isRequired.apply(propType, [props, propName, componentName].concat(rest));
    }

    return requiredByRequired;
  }();

  return (0, _wrapValidator2['default'])(requiredBy, 'requiredBy \u201C' + String(requiredByPropName) + '\u201D', [requiredByPropName, defaultValue]);
}
//# sourceMappingURL=requiredBy.js.map