Object.defineProperty(exports, "__esModule", {
  value: true
});
exports['default'] = stringStartsWithValidator;

var _propTypes = require('prop-types');

var _wrapValidator = require('./helpers/wrapValidator');

var _wrapValidator2 = _interopRequireDefault(_wrapValidator);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function stringStartsWithValidator(start) {
  if (typeof start !== 'string' || start.length === 0) {
    throw new TypeError('a non-empty string is required');
  }

  var validator = function () {
    function stringStartsWith(props, propName, componentName) {
      var propValue = props[propName];


      if (propValue == null) {
        return null;
      }

      for (var _len = arguments.length, rest = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
        rest[_key - 3] = arguments[_key];
      }

      var stringError = _propTypes.string.apply(undefined, [props, propName, componentName].concat(rest));
      if (stringError) {
        return stringError;
      }

      if (!propValue.startsWith(start) || propValue.length <= start.length) {
        return new TypeError(String(componentName) + ': ' + String(propName) + ' does not start with "' + String(start) + '"');
      }
      return null;
    }

    return stringStartsWith;
  }();

  validator.isRequired = function () {
    function requiredStringStartsWith() {
      var stringError = _propTypes.string.isRequired.apply(_propTypes.string, arguments);
      if (stringError) {
        return stringError;
      }
      return validator.apply(undefined, arguments);
    }

    return requiredStringStartsWith;
  }();

  return (0, _wrapValidator2['default'])(validator, 'stringStartsWith: ' + String(start));
}
//# sourceMappingURL=stringStartsWith.js.map