import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import * as React from 'react';
import classNames from 'classnames';
import { ConfigConsumer } from '../config-provider';

var Grid = function Grid(props) {
  return /*#__PURE__*/React.createElement(ConfigConsumer, null, function (_ref) {
    var getPrefixCls = _ref.getPrefixCls;

    var customizePrefixCls = props.prefixCls,
        className = props.className,
        _props$hoverable = props.hoverable,
        hoverable = _props$hoverable === void 0 ? true : _props$hoverable,
        others = __rest(props, ["prefixCls", "className", "hoverable"]);

    var prefixCls = getPrefixCls('card', customizePrefixCls);
    var classString = classNames("".concat(prefixCls, "-grid"), className, _defineProperty({}, "".concat(prefixCls, "-grid-hoverable"), hoverable));
    return /*#__PURE__*/React.createElement("div", _extends({}, others, {
      className: classString
    }));
  });
};

export default Grid;