import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import * as React from 'react';
import classNames from 'classnames';
import LoadingOutlined from '@ant-design/icons/LoadingOutlined';
import CloseCircleFilled from '@ant-design/icons/CloseCircleFilled';
import CheckCircleFilled from '@ant-design/icons/CheckCircleFilled';
import ExclamationCircleFilled from '@ant-design/icons/ExclamationCircleFilled';
import useMemo from "rc-util/es/hooks/useMemo";
import CSSMotion from "rc-animate/es/CSSMotion";
import Col from '../grid/col';
import { FormContext } from './context';
import useCacheErrors from './hooks/useCacheErrors';
var iconMap = {
  success: CheckCircleFilled,
  warning: ExclamationCircleFilled,
  error: CloseCircleFilled,
  validating: LoadingOutlined
};

var FormItemInput = function FormItemInput(_ref) {
  var prefixCls = _ref.prefixCls,
      wrapperCol = _ref.wrapperCol,
      children = _ref.children,
      help = _ref.help,
      errors = _ref.errors,
      onDomErrorVisibleChange = _ref.onDomErrorVisibleChange,
      hasFeedback = _ref.hasFeedback,
      validateStatus = _ref.validateStatus,
      extra = _ref.extra;

  var _React$useState = React.useState({}),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      forceUpdate = _React$useState2[1];

  var baseClassName = "".concat(prefixCls, "-item");
  var formContext = React.useContext(FormContext);
  var mergedWrapperCol = wrapperCol || formContext.wrapperCol || {};
  var className = classNames("".concat(baseClassName, "-control"), mergedWrapperCol.className);

  var _useCacheErrors = useCacheErrors(errors, function (changedVisible) {
    if (changedVisible) {
      /**
       * We trigger in sync to avoid dom shaking but this get warning in react 16.13.
       * So use Promise to keep in micro async to handle this.
       * https://github.com/ant-design/ant-design/issues/21698#issuecomment-593743485
       */
      Promise.resolve().then(function () {
        onDomErrorVisibleChange(true);
      });
    }

    forceUpdate({});
  }, !!help),
      _useCacheErrors2 = _slicedToArray(_useCacheErrors, 2),
      visible = _useCacheErrors2[0],
      cacheErrors = _useCacheErrors2[1];

  React.useEffect(function () {
    return function () {
      onDomErrorVisibleChange(false);
    };
  }, []);
  var memoErrors = useMemo(function () {
    return cacheErrors;
  }, visible, function (_, nextVisible) {
    return nextVisible;
  }); // Should provides additional icon if `hasFeedback`

  var IconNode = validateStatus && iconMap[validateStatus];
  var icon = hasFeedback && IconNode ? /*#__PURE__*/React.createElement("span", {
    className: "".concat(baseClassName, "-children-icon")
  }, /*#__PURE__*/React.createElement(IconNode, null)) : null; // Pass to sub FormItem should not with col info

  var subFormContext = _extends({}, formContext);

  delete subFormContext.labelCol;
  delete subFormContext.wrapperCol;
  return /*#__PURE__*/React.createElement(FormContext.Provider, {
    value: subFormContext
  }, /*#__PURE__*/React.createElement(Col, _extends({}, mergedWrapperCol, {
    className: className
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(baseClassName, "-control-input")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(baseClassName, "-control-input-content")
  }, children), icon), /*#__PURE__*/React.createElement(CSSMotion, {
    motionDeadline: 500,
    visible: visible,
    motionName: "show-help",
    onLeaveEnd: function onLeaveEnd() {
      onDomErrorVisibleChange(false);
    },
    motionAppear: true,
    removeOnLeave: true
  }, function (_ref2) {
    var motionClassName = _ref2.className;
    return /*#__PURE__*/React.createElement("div", {
      className: classNames("".concat(baseClassName, "-explain"), motionClassName),
      key: "help"
    }, memoErrors.map(function (error, index) {
      return (
        /*#__PURE__*/
        // eslint-disable-next-line react/no-array-index-key
        React.createElement("div", {
          key: index
        }, error)
      );
    }));
  }), extra && /*#__PURE__*/React.createElement("div", {
    className: "".concat(baseClassName, "-extra")
  }, extra)));
};

export default FormItemInput;