"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var React = _interopRequireWildcard(require("react"));

var _rcAnimate = _interopRequireDefault(require("rc-animate"));

var _classnames = _interopRequireDefault(require("classnames"));

var _LoadingOutlined = _interopRequireDefault(require("@ant-design/icons/LoadingOutlined"));

var _PaperClipOutlined = _interopRequireDefault(require("@ant-design/icons/PaperClipOutlined"));

var _PictureTwoTone = _interopRequireDefault(require("@ant-design/icons/PictureTwoTone"));

var _FileTwoTone = _interopRequireDefault(require("@ant-design/icons/FileTwoTone"));

var _EyeOutlined = _interopRequireDefault(require("@ant-design/icons/EyeOutlined"));

var _DeleteOutlined = _interopRequireDefault(require("@ant-design/icons/DeleteOutlined"));

var _DownloadOutlined = _interopRequireDefault(require("@ant-design/icons/DownloadOutlined"));

var _reactNode = require("../_util/reactNode");

var _utils = require("./utils");

var _tooltip = _interopRequireDefault(require("../tooltip"));

var _progress = _interopRequireDefault(require("../progress"));

var _configProvider = require("../config-provider");

var _button = _interopRequireDefault(require("../button"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

var UploadList = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2["default"])(UploadList, _React$Component);

  var _super = _createSuper(UploadList);

  function UploadList() {
    var _this;

    (0, _classCallCheck2["default"])(this, UploadList);
    _this = _super.apply(this, arguments);

    _this.handlePreview = function (file, e) {
      var onPreview = _this.props.onPreview;

      if (!onPreview) {
        return;
      }

      e.preventDefault();
      return onPreview(file);
    };

    _this.handleDownload = function (file) {
      var onDownload = _this.props.onDownload;

      if (typeof onDownload === 'function') {
        onDownload(file);
      } else if (file.url) {
        window.open(file.url);
      }
    };

    _this.handleClose = function (file) {
      var onRemove = _this.props.onRemove;

      if (onRemove) {
        onRemove(file);
      }
    };

    _this.handleIconRender = function (file) {
      var _this$props = _this.props,
          listType = _this$props.listType,
          locale = _this$props.locale,
          iconRender = _this$props.iconRender,
          isImgUrl = _this$props.isImageUrl;

      if (iconRender) {
        return iconRender(file, listType);
      }

      var isLoading = file.status === 'uploading';
      var fileIcon = isImgUrl && isImgUrl(file) ? /*#__PURE__*/React.createElement(_PictureTwoTone["default"], null) : /*#__PURE__*/React.createElement(_FileTwoTone["default"], null);
      var icon = isLoading ? /*#__PURE__*/React.createElement(_LoadingOutlined["default"], null) : /*#__PURE__*/React.createElement(_PaperClipOutlined["default"], null);

      if (listType === 'picture') {
        icon = isLoading ? /*#__PURE__*/React.createElement(_LoadingOutlined["default"], null) : fileIcon;
      } else if (listType === 'picture-card') {
        icon = isLoading ? locale.uploading : fileIcon;
      }

      return icon;
    };

    _this.handleActionIconRender = function (customIcon, callback, prefixCls, title) {
      var btnProps = {
        type: 'text',
        size: 'small',
        title: title,
        onClick: function onClick(e) {
          callback();

          if ((0, _reactNode.isValidElement)(customIcon) && customIcon.props.onClick) {
            customIcon.props.onClick(e);
          }
        },
        className: "".concat(prefixCls, "-list-item-card-actions-btn")
      };

      if ((0, _reactNode.isValidElement)(customIcon)) {
        var btnIcon = (0, _reactNode.cloneElement)(customIcon, (0, _extends2["default"])((0, _extends2["default"])({}, customIcon.props), {
          onClick: function onClick() {}
        }));
        return /*#__PURE__*/React.createElement(_button["default"], (0, _extends2["default"])({}, btnProps, {
          icon: btnIcon
        }));
      }

      return /*#__PURE__*/React.createElement(_button["default"], btnProps, /*#__PURE__*/React.createElement("span", null, customIcon));
    };

    _this.renderUploadList = function (_ref) {
      var _classNames6;

      var getPrefixCls = _ref.getPrefixCls,
          direction = _ref.direction;
      var _this$props2 = _this.props,
          customizePrefixCls = _this$props2.prefixCls,
          _this$props2$items = _this$props2.items,
          items = _this$props2$items === void 0 ? [] : _this$props2$items,
          listType = _this$props2.listType,
          showPreviewIcon = _this$props2.showPreviewIcon,
          showRemoveIcon = _this$props2.showRemoveIcon,
          showDownloadIcon = _this$props2.showDownloadIcon,
          customRemoveIcon = _this$props2.removeIcon,
          customDownloadIcon = _this$props2.downloadIcon,
          locale = _this$props2.locale,
          progressProps = _this$props2.progress,
          isImgUrl = _this$props2.isImageUrl;
      var prefixCls = getPrefixCls('upload', customizePrefixCls);
      var list = items.map(function (file) {
        var _classNames3, _classNames4;

        var progress;

        var iconNode = _this.handleIconRender(file);

        var icon = /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefixCls, "-text-icon")
        }, iconNode);

        if (listType === 'picture' || listType === 'picture-card') {
          if (file.status === 'uploading' || !file.thumbUrl && !file.url) {
            var _classNames;

            var uploadingClassName = (0, _classnames["default"])((_classNames = {}, (0, _defineProperty2["default"])(_classNames, "".concat(prefixCls, "-list-item-thumbnail"), true), (0, _defineProperty2["default"])(_classNames, "".concat(prefixCls, "-list-item-file"), file.status !== 'uploading'), _classNames));
            icon = /*#__PURE__*/React.createElement("div", {
              className: uploadingClassName
            }, iconNode);
          } else {
            var _classNames2;

            var thumbnail = isImgUrl && isImgUrl(file) ? /*#__PURE__*/React.createElement("img", {
              src: file.thumbUrl || file.url,
              alt: file.name,
              className: "".concat(prefixCls, "-list-item-image")
            }) : iconNode;
            var aClassName = (0, _classnames["default"])((_classNames2 = {}, (0, _defineProperty2["default"])(_classNames2, "".concat(prefixCls, "-list-item-thumbnail"), true), (0, _defineProperty2["default"])(_classNames2, "".concat(prefixCls, "-list-item-file"), isImgUrl && !isImgUrl(file)), _classNames2));
            icon = /*#__PURE__*/React.createElement("a", {
              className: aClassName,
              onClick: function onClick(e) {
                return _this.handlePreview(file, e);
              },
              href: file.url || file.thumbUrl,
              target: "_blank",
              rel: "noopener noreferrer"
            }, thumbnail);
          }
        }

        if (file.status === 'uploading') {
          // show loading icon if upload progress listener is disabled
          var loadingProgress = 'percent' in file ? /*#__PURE__*/React.createElement(_progress["default"], (0, _extends2["default"])({}, progressProps, {
            type: "line",
            percent: file.percent
          })) : null;
          progress = /*#__PURE__*/React.createElement("div", {
            className: "".concat(prefixCls, "-list-item-progress"),
            key: "progress"
          }, loadingProgress);
        }

        var infoUploadingClass = (0, _classnames["default"])((_classNames3 = {}, (0, _defineProperty2["default"])(_classNames3, "".concat(prefixCls, "-list-item"), true), (0, _defineProperty2["default"])(_classNames3, "".concat(prefixCls, "-list-item-").concat(file.status), true), (0, _defineProperty2["default"])(_classNames3, "".concat(prefixCls, "-list-item-list-type-").concat(listType), true), _classNames3));
        var linkProps = typeof file.linkProps === 'string' ? JSON.parse(file.linkProps) : file.linkProps;
        var removeIcon = showRemoveIcon ? _this.handleActionIconRender(customRemoveIcon || /*#__PURE__*/React.createElement(_DeleteOutlined["default"], null), function () {
          return _this.handleClose(file);
        }, prefixCls, locale.removeFile) : null;
        var downloadIcon = showDownloadIcon && file.status === 'done' ? _this.handleActionIconRender(customDownloadIcon || /*#__PURE__*/React.createElement(_DownloadOutlined["default"], null), function () {
          return _this.handleDownload(file);
        }, prefixCls, locale.downloadFile) : null;
        var downloadOrDelete = listType !== 'picture-card' && /*#__PURE__*/React.createElement("span", {
          key: "download-delete",
          className: "".concat(prefixCls, "-list-item-card-actions ").concat(listType === 'picture' ? 'picture' : '')
        }, downloadIcon, removeIcon);
        var listItemNameClass = (0, _classnames["default"])((_classNames4 = {}, (0, _defineProperty2["default"])(_classNames4, "".concat(prefixCls, "-list-item-name"), true), (0, _defineProperty2["default"])(_classNames4, "".concat(prefixCls, "-list-item-name-icon-count-").concat([downloadIcon, removeIcon].filter(function (x) {
          return x;
        }).length), true), _classNames4));
        var preview = file.url ? [/*#__PURE__*/React.createElement("a", (0, _extends2["default"])({
          key: "view",
          target: "_blank",
          rel: "noopener noreferrer",
          className: listItemNameClass,
          title: file.name
        }, linkProps, {
          href: file.url,
          onClick: function onClick(e) {
            return _this.handlePreview(file, e);
          }
        }), file.name), downloadOrDelete] : [/*#__PURE__*/React.createElement("span", {
          key: "view",
          className: listItemNameClass,
          onClick: function onClick(e) {
            return _this.handlePreview(file, e);
          },
          title: file.name
        }, file.name), downloadOrDelete];
        var style = {
          pointerEvents: 'none',
          opacity: 0.5
        };
        var previewIcon = showPreviewIcon ? /*#__PURE__*/React.createElement("a", {
          href: file.url || file.thumbUrl,
          target: "_blank",
          rel: "noopener noreferrer",
          style: file.url || file.thumbUrl ? undefined : style,
          onClick: function onClick(e) {
            return _this.handlePreview(file, e);
          },
          title: locale.previewFile
        }, /*#__PURE__*/React.createElement(_EyeOutlined["default"], null)) : null;
        var actions = listType === 'picture-card' && file.status !== 'uploading' && /*#__PURE__*/React.createElement("span", {
          className: "".concat(prefixCls, "-list-item-actions")
        }, previewIcon, file.status === 'done' && downloadIcon, removeIcon);
        var message;

        if (file.response && typeof file.response === 'string') {
          message = file.response;
        } else {
          message = file.error && file.error.statusText || locale.uploadError;
        }

        var iconAndPreview = /*#__PURE__*/React.createElement("span", null, icon, preview);
        var dom = /*#__PURE__*/React.createElement("div", {
          className: infoUploadingClass
        }, /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefixCls, "-list-item-info")
        }, iconAndPreview), actions, /*#__PURE__*/React.createElement(_rcAnimate["default"], {
          transitionName: "fade",
          component: ""
        }, progress));
        var listContainerNameClass = (0, _classnames["default"])((0, _defineProperty2["default"])({}, "".concat(prefixCls, "-list-picture-card-container"), listType === 'picture-card'));
        return /*#__PURE__*/React.createElement("div", {
          key: file.uid,
          className: listContainerNameClass
        }, file.status === 'error' ? /*#__PURE__*/React.createElement(_tooltip["default"], {
          title: message,
          getPopupContainer: function getPopupContainer(node) {
            return node.parentNode;
          }
        }, dom) : /*#__PURE__*/React.createElement("span", null, dom));
      });
      var listClassNames = (0, _classnames["default"])((_classNames6 = {}, (0, _defineProperty2["default"])(_classNames6, "".concat(prefixCls, "-list"), true), (0, _defineProperty2["default"])(_classNames6, "".concat(prefixCls, "-list-").concat(listType), true), (0, _defineProperty2["default"])(_classNames6, "".concat(prefixCls, "-list-rtl"), direction === 'rtl'), _classNames6));
      var animationDirection = listType === 'picture-card' ? 'animate-inline' : 'animate';
      return /*#__PURE__*/React.createElement(_rcAnimate["default"], {
        transitionName: "".concat(prefixCls, "-").concat(animationDirection),
        component: "div",
        className: listClassNames
      }, list);
    };

    return _this;
  }

  (0, _createClass2["default"])(UploadList, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this2 = this;

      var _this$props3 = this.props,
          listType = _this$props3.listType,
          items = _this$props3.items,
          previewFile = _this$props3.previewFile;

      if (listType !== 'picture' && listType !== 'picture-card') {
        return;
      }

      (items || []).forEach(function (file) {
        if (typeof document === 'undefined' || typeof window === 'undefined' || !window.FileReader || !window.File || !(file.originFileObj instanceof File || file.originFileObj instanceof Blob) || file.thumbUrl !== undefined) {
          return;
        }

        file.thumbUrl = '';

        if (previewFile) {
          previewFile(file.originFileObj).then(function (previewDataUrl) {
            // Need append '' to avoid dead loop
            file.thumbUrl = previewDataUrl || '';

            _this2.forceUpdate();
          });
        }
      });
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(_configProvider.ConfigConsumer, null, this.renderUploadList);
    }
  }]);
  return UploadList;
}(React.Component);

exports["default"] = UploadList;
UploadList.defaultProps = {
  listType: 'text',
  progress: {
    strokeWidth: 2,
    showInfo: false
  },
  showRemoveIcon: true,
  showDownloadIcon: false,
  showPreviewIcon: true,
  previewFile: _utils.previewImage,
  isImageUrl: _utils.isImageUrl
};