var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;


import { GL, Model, Geometry } from 'luma.gl';

import vs from './arc-layer-vertex.glsl';
import vs64 from './arc-layer-vertex-64.glsl';
import fs from './arc-layer-fragment.glsl';

var DEFAULT_COLOR = [0, 0, 0, 255];

var defaultProps = {
  strokeWidth: 1,
  fp64: false,

  getSourcePosition: function getSourcePosition(x) {
    return x.sourcePosition;
  },
  getTargetPosition: function getTargetPosition(x) {
    return x.targetPosition;
  },
  getSourceColor: function getSourceColor(x) {
    return x.color || DEFAULT_COLOR;
  },
  getTargetColor: function getTargetColor(x) {
    return x.color || DEFAULT_COLOR;
  }
};

var ArcLayer = function (_Layer) {
  _inherits(ArcLayer, _Layer);

  function ArcLayer() {
    _classCallCheck(this, ArcLayer);

    return _possibleConstructorReturn(this, (ArcLayer.__proto__ || Object.getPrototypeOf(ArcLayer)).apply(this, arguments));
  }

  _createClass(ArcLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'picking'] } : { vs: vs, fs: fs, modules: ['picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();

      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instancePositions: {
          size: 4,
          transition: true,
          accessor: ['getSourcePosition', 'getTargetPosition'],
          update: this.calculateInstancePositions
        },
        instanceSourceColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getSourceColor',
          update: this.calculateInstanceSourceColors
        },
        instanceTargetColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getTargetColor',
          update: this.calculateInstanceTargetColors
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instancePositions64Low: {
              size: 4,
              accessor: ['getSourcePosition', 'getTargetPosition'],
              update: this.calculateInstancePositions64Low
            }
          });
        } else {
          attributeManager.remove(['instancePositions64Low']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      _get(ArcLayer.prototype.__proto__ || Object.getPrototypeOf(ArcLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });
      // Re-generate model if geometry changed
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var strokeWidth = this.props.strokeWidth;


      this.state.model.render(Object.assign({}, uniforms, {
        strokeWidth: strokeWidth
      }));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      var positions = [];
      var NUM_SEGMENTS = 50;
      /*
       *  (0, -1)-------------_(1, -1)
       *       |          _,-"  |
       *       o      _,-"      o
       *       |  _,-"          |
       *   (0, 1)"-------------(1, 1)
       */
      for (var i = 0; i < NUM_SEGMENTS; i++) {
        positions = positions.concat([i, -1, 0, i, 1, 0]);
      }

      var model = new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: GL.TRIANGLE_STRIP,
          attributes: {
            positions: new Float32Array(positions)
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));

      model.setUniforms({ numSegments: NUM_SEGMENTS });

      return model;
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props = this.props,
          data = _props.data,
          getSourcePosition = _props.getSourcePosition,
          getTargetPosition = _props.getTargetPosition;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var object = _step.value;

          var sourcePosition = getSourcePosition(object);
          var targetPosition = getTargetPosition(object);
          value[i + 0] = sourcePosition[0];
          value[i + 1] = sourcePosition[1];
          value[i + 2] = targetPosition[0];
          value[i + 3] = targetPosition[1];
          i += size;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64Low',
    value: function calculateInstancePositions64Low(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getSourcePosition = _props2.getSourcePosition,
          getTargetPosition = _props2.getTargetPosition;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var object = _step2.value;

          var sourcePosition = getSourcePosition(object);
          var targetPosition = getTargetPosition(object);
          value[i + 0] = fp64LowPart(sourcePosition[0]);
          value[i + 1] = fp64LowPart(sourcePosition[1]);
          value[i + 2] = fp64LowPart(targetPosition[0]);
          value[i + 3] = fp64LowPart(targetPosition[1]);
          i += size;
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceSourceColors',
    value: function calculateInstanceSourceColors(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getSourceColor = _props3.getSourceColor;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var object = _step3.value;

          var color = getSourceColor(object);
          value[i + 0] = color[0];
          value[i + 1] = color[1];
          value[i + 2] = color[2];
          value[i + 3] = isNaN(color[3]) ? 255 : color[3];
          i += size;
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceTargetColors',
    value: function calculateInstanceTargetColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getTargetColor = _props4.getTargetColor;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = data[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var object = _step4.value;

          var color = getTargetColor(object);
          value[i + 0] = color[0];
          value[i + 1] = color[1];
          value[i + 2] = color[2];
          value[i + 3] = isNaN(color[3]) ? 255 : color[3];
          i += size;
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }
  }]);

  return ArcLayer;
}(Layer);

export default ArcLayer;


ArcLayer.layerName = 'ArcLayer';
ArcLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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