var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, CubeGeometry } from 'luma.gl';

import vs from './grid-cell-layer-vertex.glsl';
import vs64 from './grid-cell-layer-vertex-64.glsl';
import fs from './grid-cell-layer-fragment.glsl';

var DEFAULT_COLOR = [255, 0, 255, 255];

var defaultProps = {
  cellSize: 1000,
  coverage: 1,
  elevationScale: 1,
  extruded: true,
  fp64: false,

  getPosition: function getPosition(x) {
    return x.position;
  },
  getElevation: function getElevation(x) {
    return x.elevation;
  },
  getColor: function getColor(x) {
    return x.color;
  },

  lightSettings: {
    lightsPosition: [-122.45, 37.65, 8000, -122.45, 37.2, 1000],
    ambientRatio: 0.4,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [1.0, 0.0, 0.8, 0.0],
    numberOfLights: 2
  }
};

var GridCellLayer = function (_Layer) {
  _inherits(GridCellLayer, _Layer);

  function GridCellLayer() {
    _classCallCheck(this, GridCellLayer);

    return _possibleConstructorReturn(this, (GridCellLayer.__proto__ || Object.getPrototypeOf(GridCellLayer)).apply(this, arguments));
  }

  _createClass(GridCellLayer, [{
    key: 'getShaders',

    /**
     * A generic GridLayer that takes latitude longitude delta of cells as a uniform
     * and the min lat lng of cells. grid can be 3d when pass in a height
     * and set enable3d to true
     *
     * @param {array} props.data -
     * @param {boolean} props.extruded - enable grid elevation
     * @param {number} props.cellSize - grid cell size in meters
     * @param {function} props.getPosition - position accessor, returned as [minLng, minLat]
     * @param {function} props.getElevation - elevation accessor
     * @param {function} props.getColor - color accessor, returned as [r, g, b, a]
     */

    value: function getShaders() {
      var shaderCache = this.context.shaderCache;

      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'lighting', 'picking'], shaderCache: shaderCache } : { vs: vs, fs: fs, modules: ['lighting', 'picking'], shaderCache: shaderCache }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instancePositions: {
          size: 4,
          transition: true,
          accessor: ['getPosition', 'getElevation'],
          update: this.calculateInstancePositions
        },
        instanceColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getColor',
          update: this.calculateInstanceColors
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instancePositions64xyLow: {
              size: 2,
              accessor: 'getPosition',
              update: this.calculateInstancePositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instancePositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      _get(GridCellLayer.prototype.__proto__ || Object.getPrototypeOf(GridCellLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });
      // Re-generate model if geometry changed
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });
      this.updateUniforms();
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new CubeGeometry(),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'updateUniforms',
    value: function updateUniforms() {
      var _props = this.props,
          opacity = _props.opacity,
          extruded = _props.extruded,
          elevationScale = _props.elevationScale,
          coverage = _props.coverage,
          lightSettings = _props.lightSettings;
      var model = this.state.model;


      model.setUniforms(Object.assign({}, {
        extruded: extruded,
        elevationScale: elevationScale,
        opacity: opacity,
        coverage: coverage
      }, lightSettings));
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var viewport = this.context.viewport;
      // TODO - this should be a standard uniform in project package

      var _viewport$getDistance = viewport.getDistanceScales(),
          pixelsPerMeter = _viewport$getDistance.pixelsPerMeter;

      // cellSize needs to be updated on every draw call
      // because it is based on viewport


      _get(GridCellLayer.prototype.__proto__ || Object.getPrototypeOf(GridCellLayer.prototype), 'draw', this).call(this, {
        uniforms: Object.assign({
          cellSize: this.props.cellSize * pixelsPerMeter[0]
        }, uniforms)
      });
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getPosition = _props2.getPosition,
          getElevation = _props2.getElevation;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var object = _step.value;

          var position = getPosition(object);
          var elevation = getElevation(object) || 0;
          value[i + 0] = position[0];
          value[i + 1] = position[1];
          value[i + 2] = 0;
          value[i + 3] = elevation;
          i += size;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64xyLow',
    value: function calculateInstancePositions64xyLow(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getPosition = _props3.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var point = _step2.value;

          var position = getPosition(point);
          value[i++] = fp64LowPart(position[0]);
          value[i++] = fp64LowPart(position[1]);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getColor = _props4.getColor;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var object = _step3.value;

          var color = getColor(object) || DEFAULT_COLOR;
          value[i + 0] = color[0];
          value[i + 1] = color[1];
          value[i + 2] = color[2];
          value[i + 3] = Number.isFinite(color[3]) ? color[3] : DEFAULT_COLOR[3];
          i += size;
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }]);

  return GridCellLayer;
}(Layer);

export default GridCellLayer;


GridCellLayer.layerName = 'GridCellLayer';
GridCellLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb3JlLWxheWVycy9ncmlkLWNlbGwtbGF5ZXIvZ3JpZC1jZWxsLWxheWVyLmpzIl0sIm5hbWVzIjpbIkNPT1JESU5BVEVfU1lTVEVNIiwiTGF5ZXIiLCJleHBlcmltZW50YWwiLCJmcDY0TG93UGFydCIsImVuYWJsZTY0Yml0U3VwcG9ydCIsIkdMIiwiTW9kZWwiLCJDdWJlR2VvbWV0cnkiLCJ2cyIsInZzNjQiLCJmcyIsIkRFRkFVTFRfQ09MT1IiLCJkZWZhdWx0UHJvcHMiLCJjZWxsU2l6ZSIsImNvdmVyYWdlIiwiZWxldmF0aW9uU2NhbGUiLCJleHRydWRlZCIsImZwNjQiLCJnZXRQb3NpdGlvbiIsIngiLCJwb3NpdGlvbiIsImdldEVsZXZhdGlvbiIsImVsZXZhdGlvbiIsImdldENvbG9yIiwiY29sb3IiLCJsaWdodFNldHRpbmdzIiwibGlnaHRzUG9zaXRpb24iLCJhbWJpZW50UmF0aW8iLCJkaWZmdXNlUmF0aW8iLCJzcGVjdWxhclJhdGlvIiwibGlnaHRzU3RyZW5ndGgiLCJudW1iZXJPZkxpZ2h0cyIsIkdyaWRDZWxsTGF5ZXIiLCJzaGFkZXJDYWNoZSIsImNvbnRleHQiLCJwcm9wcyIsIm1vZHVsZXMiLCJhdHRyaWJ1dGVNYW5hZ2VyIiwiZ2V0QXR0cmlidXRlTWFuYWdlciIsImFkZEluc3RhbmNlZCIsImluc3RhbmNlUG9zaXRpb25zIiwic2l6ZSIsInRyYW5zaXRpb24iLCJhY2Nlc3NvciIsInVwZGF0ZSIsImNhbGN1bGF0ZUluc3RhbmNlUG9zaXRpb25zIiwiaW5zdGFuY2VDb2xvcnMiLCJ0eXBlIiwiVU5TSUdORURfQllURSIsImNhbGN1bGF0ZUluc3RhbmNlQ29sb3JzIiwib2xkUHJvcHMiLCJjaGFuZ2VGbGFncyIsImludmFsaWRhdGVBbGwiLCJjb29yZGluYXRlU3lzdGVtIiwiTE5HTEFUIiwiaW5zdGFuY2VQb3NpdGlvbnM2NHh5TG93IiwiY2FsY3VsYXRlSW5zdGFuY2VQb3NpdGlvbnM2NHh5TG93IiwicmVtb3ZlIiwiZ2wiLCJzdGF0ZSIsIm1vZGVsIiwiZGVsZXRlIiwic2V0U3RhdGUiLCJfZ2V0TW9kZWwiLCJ1cGRhdGVBdHRyaWJ1dGUiLCJ1cGRhdGVVbmlmb3JtcyIsIk9iamVjdCIsImFzc2lnbiIsImdldFNoYWRlcnMiLCJpZCIsImdlb21ldHJ5IiwiaXNJbnN0YW5jZWQiLCJvcGFjaXR5Iiwic2V0VW5pZm9ybXMiLCJ1bmlmb3JtcyIsInZpZXdwb3J0IiwiZ2V0RGlzdGFuY2VTY2FsZXMiLCJwaXhlbHNQZXJNZXRlciIsImF0dHJpYnV0ZSIsImRhdGEiLCJ2YWx1ZSIsImkiLCJvYmplY3QiLCJwb2ludCIsIk51bWJlciIsImlzRmluaXRlIiwibGF5ZXJOYW1lIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEsU0FBUUEsaUJBQVIsRUFBMkJDLEtBQTNCLEVBQWtDQyxZQUFsQyxRQUFxRCxZQUFyRDtJQUNPQyxXLEdBQW1DRCxZLENBQW5DQyxXO0lBQWFDLGtCLEdBQXNCRixZLENBQXRCRSxrQjs7QUFDcEIsU0FBUUMsRUFBUixFQUFZQyxLQUFaLEVBQW1CQyxZQUFuQixRQUFzQyxTQUF0Qzs7QUFFQSxPQUFPQyxFQUFQLE1BQWUsK0JBQWY7QUFDQSxPQUFPQyxJQUFQLE1BQWlCLGtDQUFqQjtBQUNBLE9BQU9DLEVBQVAsTUFBZSxpQ0FBZjs7QUFFQSxJQUFNQyxnQkFBZ0IsQ0FBQyxHQUFELEVBQU0sQ0FBTixFQUFTLEdBQVQsRUFBYyxHQUFkLENBQXRCOztBQUVBLElBQU1DLGVBQWU7QUFDbkJDLFlBQVUsSUFEUztBQUVuQkMsWUFBVSxDQUZTO0FBR25CQyxrQkFBZ0IsQ0FIRztBQUluQkMsWUFBVSxJQUpTO0FBS25CQyxRQUFNLEtBTGE7O0FBT25CQyxlQUFhO0FBQUEsV0FBS0MsRUFBRUMsUUFBUDtBQUFBLEdBUE07QUFRbkJDLGdCQUFjO0FBQUEsV0FBS0YsRUFBRUcsU0FBUDtBQUFBLEdBUks7QUFTbkJDLFlBQVU7QUFBQSxXQUFLSixFQUFFSyxLQUFQO0FBQUEsR0FUUzs7QUFXbkJDLGlCQUFlO0FBQ2JDLG9CQUFnQixDQUFDLENBQUMsTUFBRixFQUFVLEtBQVYsRUFBaUIsSUFBakIsRUFBdUIsQ0FBQyxNQUF4QixFQUFnQyxJQUFoQyxFQUFzQyxJQUF0QyxDQURIO0FBRWJDLGtCQUFjLEdBRkQ7QUFHYkMsa0JBQWMsR0FIRDtBQUliQyxtQkFBZSxHQUpGO0FBS2JDLG9CQUFnQixDQUFDLEdBQUQsRUFBTSxHQUFOLEVBQVcsR0FBWCxFQUFnQixHQUFoQixDQUxIO0FBTWJDLG9CQUFnQjtBQU5IO0FBWEksQ0FBckI7O0lBcUJxQkMsYTs7Ozs7Ozs7Ozs7O0FBQ25COzs7Ozs7Ozs7Ozs7O2lDQWFhO0FBQUEsVUFDSkMsV0FESSxHQUNXLEtBQUtDLE9BRGhCLENBQ0pELFdBREk7O0FBRVgsYUFBTzdCLG1CQUFtQixLQUFLK0IsS0FBeEIsSUFDSCxFQUFDM0IsSUFBSUMsSUFBTCxFQUFXQyxNQUFYLEVBQWUwQixTQUFTLENBQUMsV0FBRCxFQUFjLFVBQWQsRUFBMEIsU0FBMUIsQ0FBeEIsRUFBOERILHdCQUE5RCxFQURHLEdBRUgsRUFBQ3pCLE1BQUQsRUFBS0UsTUFBTCxFQUFTMEIsU0FBUyxDQUFDLFVBQUQsRUFBYSxTQUFiLENBQWxCLEVBQTJDSCx3QkFBM0MsRUFGSixDQUZXLENBSWtEO0FBQzlEOzs7c0NBRWlCO0FBQ2hCLFVBQU1JLG1CQUFtQixLQUFLQyxtQkFBTCxFQUF6QjtBQUNBO0FBQ0FELHVCQUFpQkUsWUFBakIsQ0FBOEI7QUFDNUJDLDJCQUFtQjtBQUNqQkMsZ0JBQU0sQ0FEVztBQUVqQkMsc0JBQVksSUFGSztBQUdqQkMsb0JBQVUsQ0FBQyxhQUFELEVBQWdCLGNBQWhCLENBSE87QUFJakJDLGtCQUFRLEtBQUtDO0FBSkksU0FEUztBQU81QkMsd0JBQWdCO0FBQ2RMLGdCQUFNLENBRFE7QUFFZE0sZ0JBQU0xQyxHQUFHMkMsYUFGSztBQUdkTixzQkFBWSxJQUhFO0FBSWRDLG9CQUFVLFVBSkk7QUFLZEMsa0JBQVEsS0FBS0s7QUFMQztBQVBZLE9BQTlCO0FBZUE7QUFDRDs7OzBDQUUrQztBQUFBLFVBQS9CZCxLQUErQixRQUEvQkEsS0FBK0I7QUFBQSxVQUF4QmUsUUFBd0IsUUFBeEJBLFFBQXdCO0FBQUEsVUFBZEMsV0FBYyxRQUFkQSxXQUFjOztBQUM5QyxVQUFJaEIsTUFBTWxCLElBQU4sS0FBZWlDLFNBQVNqQyxJQUE1QixFQUFrQztBQUNoQyxZQUFNb0IsbUJBQW1CLEtBQUtDLG1CQUFMLEVBQXpCO0FBQ0FELHlCQUFpQmUsYUFBakI7O0FBRUEsWUFBSWpCLE1BQU1sQixJQUFOLElBQWNrQixNQUFNa0IsZ0JBQU4sS0FBMkJyRCxrQkFBa0JzRCxNQUEvRCxFQUF1RTtBQUNyRWpCLDJCQUFpQkUsWUFBakIsQ0FBOEI7QUFDNUJnQixzQ0FBMEI7QUFDeEJkLG9CQUFNLENBRGtCO0FBRXhCRSx3QkFBVSxhQUZjO0FBR3hCQyxzQkFBUSxLQUFLWTtBQUhXO0FBREUsV0FBOUI7QUFPRCxTQVJELE1BUU87QUFDTG5CLDJCQUFpQm9CLE1BQWpCLENBQXdCLENBQUMsMEJBQUQsQ0FBeEI7QUFDRDtBQUNGO0FBQ0Y7Ozt1Q0FFMkM7QUFBQSxVQUEvQnRCLEtBQStCLFNBQS9CQSxLQUErQjtBQUFBLFVBQXhCZSxRQUF3QixTQUF4QkEsUUFBd0I7QUFBQSxVQUFkQyxXQUFjLFNBQWRBLFdBQWM7O0FBQzFDLGdJQUFrQixFQUFDaEIsWUFBRCxFQUFRZSxrQkFBUixFQUFrQkMsd0JBQWxCLEVBQWxCO0FBQ0E7QUFDQSxVQUFJaEIsTUFBTWxCLElBQU4sS0FBZWlDLFNBQVNqQyxJQUE1QixFQUFrQztBQUFBLFlBQ3pCeUMsRUFEeUIsR0FDbkIsS0FBS3hCLE9BRGMsQ0FDekJ3QixFQUR5Qjs7QUFFaEMsWUFBSSxLQUFLQyxLQUFMLENBQVdDLEtBQWYsRUFBc0I7QUFDcEIsZUFBS0QsS0FBTCxDQUFXQyxLQUFYLENBQWlCQyxNQUFqQjtBQUNEO0FBQ0QsYUFBS0MsUUFBTCxDQUFjLEVBQUNGLE9BQU8sS0FBS0csU0FBTCxDQUFlTCxFQUFmLENBQVIsRUFBZDtBQUNEO0FBQ0QsV0FBS00sZUFBTCxDQUFxQixFQUFDN0IsWUFBRCxFQUFRZSxrQkFBUixFQUFrQkMsd0JBQWxCLEVBQXJCO0FBQ0EsV0FBS2MsY0FBTDtBQUNEOzs7OEJBRVNQLEUsRUFBSTtBQUNaLGFBQU8sSUFBSXBELEtBQUosQ0FDTG9ELEVBREssRUFFTFEsT0FBT0MsTUFBUCxDQUFjLEVBQWQsRUFBa0IsS0FBS0MsVUFBTCxFQUFsQixFQUFxQztBQUNuQ0MsWUFBSSxLQUFLbEMsS0FBTCxDQUFXa0MsRUFEb0I7QUFFbkNDLGtCQUFVLElBQUkvRCxZQUFKLEVBRnlCO0FBR25DZ0UscUJBQWEsSUFIc0I7QUFJbkN0QyxxQkFBYSxLQUFLQyxPQUFMLENBQWFEO0FBSlMsT0FBckMsQ0FGSyxDQUFQO0FBU0Q7OztxQ0FFZ0I7QUFBQSxtQkFDc0QsS0FBS0UsS0FEM0Q7QUFBQSxVQUNScUMsT0FEUSxVQUNSQSxPQURRO0FBQUEsVUFDQ3hELFFBREQsVUFDQ0EsUUFERDtBQUFBLFVBQ1dELGNBRFgsVUFDV0EsY0FEWDtBQUFBLFVBQzJCRCxRQUQzQixVQUMyQkEsUUFEM0I7QUFBQSxVQUNxQ1csYUFEckMsVUFDcUNBLGFBRHJDO0FBQUEsVUFFUm1DLEtBRlEsR0FFQyxLQUFLRCxLQUZOLENBRVJDLEtBRlE7OztBQUlmQSxZQUFNYSxXQUFOLENBQ0VQLE9BQU9DLE1BQVAsQ0FDRSxFQURGLEVBRUU7QUFDRW5ELDBCQURGO0FBRUVELHNDQUZGO0FBR0V5RCx3QkFIRjtBQUlFMUQ7QUFKRixPQUZGLEVBUUVXLGFBUkYsQ0FERjtBQVlEOzs7Z0NBRWdCO0FBQUEsVUFBWGlELFFBQVcsU0FBWEEsUUFBVztBQUFBLFVBQ1JDLFFBRFEsR0FDSSxLQUFLekMsT0FEVCxDQUNSeUMsUUFEUTtBQUVmOztBQUZlLGtDQUdVQSxTQUFTQyxpQkFBVCxFQUhWO0FBQUEsVUFHUkMsY0FIUSx5QkFHUkEsY0FIUTs7QUFLZjtBQUNBOzs7QUFDQSx5SEFBVztBQUNUSCxrQkFBVVIsT0FBT0MsTUFBUCxDQUNSO0FBQ0V0RCxvQkFBVSxLQUFLc0IsS0FBTCxDQUFXdEIsUUFBWCxHQUFzQmdFLGVBQWUsQ0FBZjtBQURsQyxTQURRLEVBSVJILFFBSlE7QUFERCxPQUFYO0FBUUQ7OzsrQ0FFMEJJLFMsRUFBVztBQUFBLG9CQUNNLEtBQUszQyxLQURYO0FBQUEsVUFDN0I0QyxJQUQ2QixXQUM3QkEsSUFENkI7QUFBQSxVQUN2QjdELFdBRHVCLFdBQ3ZCQSxXQUR1QjtBQUFBLFVBQ1ZHLFlBRFUsV0FDVkEsWUFEVTtBQUFBLFVBRTdCMkQsS0FGNkIsR0FFZEYsU0FGYyxDQUU3QkUsS0FGNkI7QUFBQSxVQUV0QnZDLElBRnNCLEdBRWRxQyxTQUZjLENBRXRCckMsSUFGc0I7O0FBR3BDLFVBQUl3QyxJQUFJLENBQVI7QUFIb0M7QUFBQTtBQUFBOztBQUFBO0FBSXBDLDZCQUFxQkYsSUFBckIsOEhBQTJCO0FBQUEsY0FBaEJHLE1BQWdCOztBQUN6QixjQUFNOUQsV0FBV0YsWUFBWWdFLE1BQVosQ0FBakI7QUFDQSxjQUFNNUQsWUFBWUQsYUFBYTZELE1BQWIsS0FBd0IsQ0FBMUM7QUFDQUYsZ0JBQU1DLElBQUksQ0FBVixJQUFlN0QsU0FBUyxDQUFULENBQWY7QUFDQTRELGdCQUFNQyxJQUFJLENBQVYsSUFBZTdELFNBQVMsQ0FBVCxDQUFmO0FBQ0E0RCxnQkFBTUMsSUFBSSxDQUFWLElBQWUsQ0FBZjtBQUNBRCxnQkFBTUMsSUFBSSxDQUFWLElBQWUzRCxTQUFmO0FBQ0EyRCxlQUFLeEMsSUFBTDtBQUNEO0FBWm1DO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFhckM7OztzREFFaUNxQyxTLEVBQVc7QUFBQSxvQkFDZixLQUFLM0MsS0FEVTtBQUFBLFVBQ3BDNEMsSUFEb0MsV0FDcENBLElBRG9DO0FBQUEsVUFDOUI3RCxXQUQ4QixXQUM5QkEsV0FEOEI7QUFBQSxVQUVwQzhELEtBRm9DLEdBRTNCRixTQUYyQixDQUVwQ0UsS0FGb0M7O0FBRzNDLFVBQUlDLElBQUksQ0FBUjtBQUgyQztBQUFBO0FBQUE7O0FBQUE7QUFJM0MsOEJBQW9CRixJQUFwQixtSUFBMEI7QUFBQSxjQUFmSSxLQUFlOztBQUN4QixjQUFNL0QsV0FBV0YsWUFBWWlFLEtBQVosQ0FBakI7QUFDQUgsZ0JBQU1DLEdBQU4sSUFBYTlFLFlBQVlpQixTQUFTLENBQVQsQ0FBWixDQUFiO0FBQ0E0RCxnQkFBTUMsR0FBTixJQUFhOUUsWUFBWWlCLFNBQVMsQ0FBVCxDQUFaLENBQWI7QUFDRDtBQVIwQztBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBUzVDOzs7NENBRXVCMEQsUyxFQUFXO0FBQUEsb0JBQ1IsS0FBSzNDLEtBREc7QUFBQSxVQUMxQjRDLElBRDBCLFdBQzFCQSxJQUQwQjtBQUFBLFVBQ3BCeEQsUUFEb0IsV0FDcEJBLFFBRG9CO0FBQUEsVUFFMUJ5RCxLQUYwQixHQUVYRixTQUZXLENBRTFCRSxLQUYwQjtBQUFBLFVBRW5CdkMsSUFGbUIsR0FFWHFDLFNBRlcsQ0FFbkJyQyxJQUZtQjs7QUFHakMsVUFBSXdDLElBQUksQ0FBUjtBQUhpQztBQUFBO0FBQUE7O0FBQUE7QUFJakMsOEJBQXFCRixJQUFyQixtSUFBMkI7QUFBQSxjQUFoQkcsTUFBZ0I7O0FBQ3pCLGNBQU0xRCxRQUFRRCxTQUFTMkQsTUFBVCxLQUFvQnZFLGFBQWxDO0FBQ0FxRSxnQkFBTUMsSUFBSSxDQUFWLElBQWV6RCxNQUFNLENBQU4sQ0FBZjtBQUNBd0QsZ0JBQU1DLElBQUksQ0FBVixJQUFlekQsTUFBTSxDQUFOLENBQWY7QUFDQXdELGdCQUFNQyxJQUFJLENBQVYsSUFBZXpELE1BQU0sQ0FBTixDQUFmO0FBQ0F3RCxnQkFBTUMsSUFBSSxDQUFWLElBQWVHLE9BQU9DLFFBQVAsQ0FBZ0I3RCxNQUFNLENBQU4sQ0FBaEIsSUFBNEJBLE1BQU0sQ0FBTixDQUE1QixHQUF1Q2IsY0FBYyxDQUFkLENBQXREO0FBQ0FzRSxlQUFLeEMsSUFBTDtBQUNEO0FBWGdDO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFZbEM7Ozs7RUFoS3dDeEMsSzs7ZUFBdEIrQixhOzs7QUFtS3JCQSxjQUFjc0QsU0FBZCxHQUEwQixlQUExQjtBQUNBdEQsY0FBY3BCLFlBQWQsR0FBNkJBLFlBQTdCIiwiZmlsZSI6ImdyaWQtY2VsbC1sYXllci5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgMjAxNSAtIDIwMTcgVWJlciBUZWNobm9sb2dpZXMsIEluYy5cbi8vXG4vLyBQZXJtaXNzaW9uIGlzIGhlcmVieSBncmFudGVkLCBmcmVlIG9mIGNoYXJnZSwgdG8gYW55IHBlcnNvbiBvYnRhaW5pbmcgYSBjb3B5XG4vLyBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGRvY3VtZW50YXRpb24gZmlsZXMgKHRoZSBcIlNvZnR3YXJlXCIpLCB0byBkZWFsXG4vLyBpbiB0aGUgU29mdHdhcmUgd2l0aG91dCByZXN0cmljdGlvbiwgaW5jbHVkaW5nIHdpdGhvdXQgbGltaXRhdGlvbiB0aGUgcmlnaHRzXG4vLyB0byB1c2UsIGNvcHksIG1vZGlmeSwgbWVyZ2UsIHB1Ymxpc2gsIGRpc3RyaWJ1dGUsIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsXG4vLyBjb3BpZXMgb2YgdGhlIFNvZnR3YXJlLCBhbmQgdG8gcGVybWl0IHBlcnNvbnMgdG8gd2hvbSB0aGUgU29mdHdhcmUgaXNcbi8vIGZ1cm5pc2hlZCB0byBkbyBzbywgc3ViamVjdCB0byB0aGUgZm9sbG93aW5nIGNvbmRpdGlvbnM6XG4vL1xuLy8gVGhlIGFib3ZlIGNvcHlyaWdodCBub3RpY2UgYW5kIHRoaXMgcGVybWlzc2lvbiBub3RpY2Ugc2hhbGwgYmUgaW5jbHVkZWQgaW5cbi8vIGFsbCBjb3BpZXMgb3Igc3Vic3RhbnRpYWwgcG9ydGlvbnMgb2YgdGhlIFNvZnR3YXJlLlxuLy9cbi8vIFRIRSBTT0ZUV0FSRSBJUyBQUk9WSURFRCBcIkFTIElTXCIsIFdJVEhPVVQgV0FSUkFOVFkgT0YgQU5ZIEtJTkQsIEVYUFJFU1MgT1Jcbi8vIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuLy8gRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UgQU5EIE5PTklORlJJTkdFTUVOVC4gSU4gTk8gRVZFTlQgU0hBTEwgVEhFXG4vLyBBVVRIT1JTIE9SIENPUFlSSUdIVCBIT0xERVJTIEJFIExJQUJMRSBGT1IgQU5ZIENMQUlNLCBEQU1BR0VTIE9SIE9USEVSXG4vLyBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuLy8gT1VUIE9GIE9SIElOIENPTk5FQ1RJT04gV0lUSCBUSEUgU09GVFdBUkUgT1IgVEhFIFVTRSBPUiBPVEhFUiBERUFMSU5HUyBJTlxuLy8gVEhFIFNPRlRXQVJFLlxuXG5pbXBvcnQge0NPT1JESU5BVEVfU1lTVEVNLCBMYXllciwgZXhwZXJpbWVudGFsfSBmcm9tICcuLi8uLi9jb3JlJztcbmNvbnN0IHtmcDY0TG93UGFydCwgZW5hYmxlNjRiaXRTdXBwb3J0fSA9IGV4cGVyaW1lbnRhbDtcbmltcG9ydCB7R0wsIE1vZGVsLCBDdWJlR2VvbWV0cnl9IGZyb20gJ2x1bWEuZ2wnO1xuXG5pbXBvcnQgdnMgZnJvbSAnLi9ncmlkLWNlbGwtbGF5ZXItdmVydGV4Lmdsc2wnO1xuaW1wb3J0IHZzNjQgZnJvbSAnLi9ncmlkLWNlbGwtbGF5ZXItdmVydGV4LTY0Lmdsc2wnO1xuaW1wb3J0IGZzIGZyb20gJy4vZ3JpZC1jZWxsLWxheWVyLWZyYWdtZW50Lmdsc2wnO1xuXG5jb25zdCBERUZBVUxUX0NPTE9SID0gWzI1NSwgMCwgMjU1LCAyNTVdO1xuXG5jb25zdCBkZWZhdWx0UHJvcHMgPSB7XG4gIGNlbGxTaXplOiAxMDAwLFxuICBjb3ZlcmFnZTogMSxcbiAgZWxldmF0aW9uU2NhbGU6IDEsXG4gIGV4dHJ1ZGVkOiB0cnVlLFxuICBmcDY0OiBmYWxzZSxcblxuICBnZXRQb3NpdGlvbjogeCA9PiB4LnBvc2l0aW9uLFxuICBnZXRFbGV2YXRpb246IHggPT4geC5lbGV2YXRpb24sXG4gIGdldENvbG9yOiB4ID0+IHguY29sb3IsXG5cbiAgbGlnaHRTZXR0aW5nczoge1xuICAgIGxpZ2h0c1Bvc2l0aW9uOiBbLTEyMi40NSwgMzcuNjUsIDgwMDAsIC0xMjIuNDUsIDM3LjIsIDEwMDBdLFxuICAgIGFtYmllbnRSYXRpbzogMC40LFxuICAgIGRpZmZ1c2VSYXRpbzogMC42LFxuICAgIHNwZWN1bGFyUmF0aW86IDAuOCxcbiAgICBsaWdodHNTdHJlbmd0aDogWzEuMCwgMC4wLCAwLjgsIDAuMF0sXG4gICAgbnVtYmVyT2ZMaWdodHM6IDJcbiAgfVxufTtcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgR3JpZENlbGxMYXllciBleHRlbmRzIExheWVyIHtcbiAgLyoqXG4gICAqIEEgZ2VuZXJpYyBHcmlkTGF5ZXIgdGhhdCB0YWtlcyBsYXRpdHVkZSBsb25naXR1ZGUgZGVsdGEgb2YgY2VsbHMgYXMgYSB1bmlmb3JtXG4gICAqIGFuZCB0aGUgbWluIGxhdCBsbmcgb2YgY2VsbHMuIGdyaWQgY2FuIGJlIDNkIHdoZW4gcGFzcyBpbiBhIGhlaWdodFxuICAgKiBhbmQgc2V0IGVuYWJsZTNkIHRvIHRydWVcbiAgICpcbiAgICogQHBhcmFtIHthcnJheX0gcHJvcHMuZGF0YSAtXG4gICAqIEBwYXJhbSB7Ym9vbGVhbn0gcHJvcHMuZXh0cnVkZWQgLSBlbmFibGUgZ3JpZCBlbGV2YXRpb25cbiAgICogQHBhcmFtIHtudW1iZXJ9IHByb3BzLmNlbGxTaXplIC0gZ3JpZCBjZWxsIHNpemUgaW4gbWV0ZXJzXG4gICAqIEBwYXJhbSB7ZnVuY3Rpb259IHByb3BzLmdldFBvc2l0aW9uIC0gcG9zaXRpb24gYWNjZXNzb3IsIHJldHVybmVkIGFzIFttaW5MbmcsIG1pbkxhdF1cbiAgICogQHBhcmFtIHtmdW5jdGlvbn0gcHJvcHMuZ2V0RWxldmF0aW9uIC0gZWxldmF0aW9uIGFjY2Vzc29yXG4gICAqIEBwYXJhbSB7ZnVuY3Rpb259IHByb3BzLmdldENvbG9yIC0gY29sb3IgYWNjZXNzb3IsIHJldHVybmVkIGFzIFtyLCBnLCBiLCBhXVxuICAgKi9cblxuICBnZXRTaGFkZXJzKCkge1xuICAgIGNvbnN0IHtzaGFkZXJDYWNoZX0gPSB0aGlzLmNvbnRleHQ7XG4gICAgcmV0dXJuIGVuYWJsZTY0Yml0U3VwcG9ydCh0aGlzLnByb3BzKVxuICAgICAgPyB7dnM6IHZzNjQsIGZzLCBtb2R1bGVzOiBbJ3Byb2plY3Q2NCcsICdsaWdodGluZycsICdwaWNraW5nJ10sIHNoYWRlckNhY2hlfVxuICAgICAgOiB7dnMsIGZzLCBtb2R1bGVzOiBbJ2xpZ2h0aW5nJywgJ3BpY2tpbmcnXSwgc2hhZGVyQ2FjaGV9OyAvLyAncHJvamVjdCcgbW9kdWxlIGFkZGVkIGJ5IGRlZmF1bHQuXG4gIH1cblxuICBpbml0aWFsaXplU3RhdGUoKSB7XG4gICAgY29uc3QgYXR0cmlidXRlTWFuYWdlciA9IHRoaXMuZ2V0QXR0cmlidXRlTWFuYWdlcigpO1xuICAgIC8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4gKi9cbiAgICBhdHRyaWJ1dGVNYW5hZ2VyLmFkZEluc3RhbmNlZCh7XG4gICAgICBpbnN0YW5jZVBvc2l0aW9uczoge1xuICAgICAgICBzaXplOiA0LFxuICAgICAgICB0cmFuc2l0aW9uOiB0cnVlLFxuICAgICAgICBhY2Nlc3NvcjogWydnZXRQb3NpdGlvbicsICdnZXRFbGV2YXRpb24nXSxcbiAgICAgICAgdXBkYXRlOiB0aGlzLmNhbGN1bGF0ZUluc3RhbmNlUG9zaXRpb25zXG4gICAgICB9LFxuICAgICAgaW5zdGFuY2VDb2xvcnM6IHtcbiAgICAgICAgc2l6ZTogNCxcbiAgICAgICAgdHlwZTogR0wuVU5TSUdORURfQllURSxcbiAgICAgICAgdHJhbnNpdGlvbjogdHJ1ZSxcbiAgICAgICAgYWNjZXNzb3I6ICdnZXRDb2xvcicsXG4gICAgICAgIHVwZGF0ZTogdGhpcy5jYWxjdWxhdGVJbnN0YW5jZUNvbG9yc1xuICAgICAgfVxuICAgIH0pO1xuICAgIC8qIGVzbGludC1lbmFibGUgbWF4LWxlbiAqL1xuICB9XG5cbiAgdXBkYXRlQXR0cmlidXRlKHtwcm9wcywgb2xkUHJvcHMsIGNoYW5nZUZsYWdzfSkge1xuICAgIGlmIChwcm9wcy5mcDY0ICE9PSBvbGRQcm9wcy5mcDY0KSB7XG4gICAgICBjb25zdCBhdHRyaWJ1dGVNYW5hZ2VyID0gdGhpcy5nZXRBdHRyaWJ1dGVNYW5hZ2VyKCk7XG4gICAgICBhdHRyaWJ1dGVNYW5hZ2VyLmludmFsaWRhdGVBbGwoKTtcblxuICAgICAgaWYgKHByb3BzLmZwNjQgJiYgcHJvcHMuY29vcmRpbmF0ZVN5c3RlbSA9PT0gQ09PUkRJTkFURV9TWVNURU0uTE5HTEFUKSB7XG4gICAgICAgIGF0dHJpYnV0ZU1hbmFnZXIuYWRkSW5zdGFuY2VkKHtcbiAgICAgICAgICBpbnN0YW5jZVBvc2l0aW9uczY0eHlMb3c6IHtcbiAgICAgICAgICAgIHNpemU6IDIsXG4gICAgICAgICAgICBhY2Nlc3NvcjogJ2dldFBvc2l0aW9uJyxcbiAgICAgICAgICAgIHVwZGF0ZTogdGhpcy5jYWxjdWxhdGVJbnN0YW5jZVBvc2l0aW9uczY0eHlMb3dcbiAgICAgICAgICB9XG4gICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgYXR0cmlidXRlTWFuYWdlci5yZW1vdmUoWydpbnN0YW5jZVBvc2l0aW9uczY0eHlMb3cnXSk7XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgdXBkYXRlU3RhdGUoe3Byb3BzLCBvbGRQcm9wcywgY2hhbmdlRmxhZ3N9KSB7XG4gICAgc3VwZXIudXBkYXRlU3RhdGUoe3Byb3BzLCBvbGRQcm9wcywgY2hhbmdlRmxhZ3N9KTtcbiAgICAvLyBSZS1nZW5lcmF0ZSBtb2RlbCBpZiBnZW9tZXRyeSBjaGFuZ2VkXG4gICAgaWYgKHByb3BzLmZwNjQgIT09IG9sZFByb3BzLmZwNjQpIHtcbiAgICAgIGNvbnN0IHtnbH0gPSB0aGlzLmNvbnRleHQ7XG4gICAgICBpZiAodGhpcy5zdGF0ZS5tb2RlbCkge1xuICAgICAgICB0aGlzLnN0YXRlLm1vZGVsLmRlbGV0ZSgpO1xuICAgICAgfVxuICAgICAgdGhpcy5zZXRTdGF0ZSh7bW9kZWw6IHRoaXMuX2dldE1vZGVsKGdsKX0pO1xuICAgIH1cbiAgICB0aGlzLnVwZGF0ZUF0dHJpYnV0ZSh7cHJvcHMsIG9sZFByb3BzLCBjaGFuZ2VGbGFnc30pO1xuICAgIHRoaXMudXBkYXRlVW5pZm9ybXMoKTtcbiAgfVxuXG4gIF9nZXRNb2RlbChnbCkge1xuICAgIHJldHVybiBuZXcgTW9kZWwoXG4gICAgICBnbCxcbiAgICAgIE9iamVjdC5hc3NpZ24oe30sIHRoaXMuZ2V0U2hhZGVycygpLCB7XG4gICAgICAgIGlkOiB0aGlzLnByb3BzLmlkLFxuICAgICAgICBnZW9tZXRyeTogbmV3IEN1YmVHZW9tZXRyeSgpLFxuICAgICAgICBpc0luc3RhbmNlZDogdHJ1ZSxcbiAgICAgICAgc2hhZGVyQ2FjaGU6IHRoaXMuY29udGV4dC5zaGFkZXJDYWNoZVxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgdXBkYXRlVW5pZm9ybXMoKSB7XG4gICAgY29uc3Qge29wYWNpdHksIGV4dHJ1ZGVkLCBlbGV2YXRpb25TY2FsZSwgY292ZXJhZ2UsIGxpZ2h0U2V0dGluZ3N9ID0gdGhpcy5wcm9wcztcbiAgICBjb25zdCB7bW9kZWx9ID0gdGhpcy5zdGF0ZTtcblxuICAgIG1vZGVsLnNldFVuaWZvcm1zKFxuICAgICAgT2JqZWN0LmFzc2lnbihcbiAgICAgICAge30sXG4gICAgICAgIHtcbiAgICAgICAgICBleHRydWRlZCxcbiAgICAgICAgICBlbGV2YXRpb25TY2FsZSxcbiAgICAgICAgICBvcGFjaXR5LFxuICAgICAgICAgIGNvdmVyYWdlXG4gICAgICAgIH0sXG4gICAgICAgIGxpZ2h0U2V0dGluZ3NcbiAgICAgIClcbiAgICApO1xuICB9XG5cbiAgZHJhdyh7dW5pZm9ybXN9KSB7XG4gICAgY29uc3Qge3ZpZXdwb3J0fSA9IHRoaXMuY29udGV4dDtcbiAgICAvLyBUT0RPIC0gdGhpcyBzaG91bGQgYmUgYSBzdGFuZGFyZCB1bmlmb3JtIGluIHByb2plY3QgcGFja2FnZVxuICAgIGNvbnN0IHtwaXhlbHNQZXJNZXRlcn0gPSB2aWV3cG9ydC5nZXREaXN0YW5jZVNjYWxlcygpO1xuXG4gICAgLy8gY2VsbFNpemUgbmVlZHMgdG8gYmUgdXBkYXRlZCBvbiBldmVyeSBkcmF3IGNhbGxcbiAgICAvLyBiZWNhdXNlIGl0IGlzIGJhc2VkIG9uIHZpZXdwb3J0XG4gICAgc3VwZXIuZHJhdyh7XG4gICAgICB1bmlmb3JtczogT2JqZWN0LmFzc2lnbihcbiAgICAgICAge1xuICAgICAgICAgIGNlbGxTaXplOiB0aGlzLnByb3BzLmNlbGxTaXplICogcGl4ZWxzUGVyTWV0ZXJbMF1cbiAgICAgICAgfSxcbiAgICAgICAgdW5pZm9ybXNcbiAgICAgIClcbiAgICB9KTtcbiAgfVxuXG4gIGNhbGN1bGF0ZUluc3RhbmNlUG9zaXRpb25zKGF0dHJpYnV0ZSkge1xuICAgIGNvbnN0IHtkYXRhLCBnZXRQb3NpdGlvbiwgZ2V0RWxldmF0aW9ufSA9IHRoaXMucHJvcHM7XG4gICAgY29uc3Qge3ZhbHVlLCBzaXplfSA9IGF0dHJpYnV0ZTtcbiAgICBsZXQgaSA9IDA7XG4gICAgZm9yIChjb25zdCBvYmplY3Qgb2YgZGF0YSkge1xuICAgICAgY29uc3QgcG9zaXRpb24gPSBnZXRQb3NpdGlvbihvYmplY3QpO1xuICAgICAgY29uc3QgZWxldmF0aW9uID0gZ2V0RWxldmF0aW9uKG9iamVjdCkgfHwgMDtcbiAgICAgIHZhbHVlW2kgKyAwXSA9IHBvc2l0aW9uWzBdO1xuICAgICAgdmFsdWVbaSArIDFdID0gcG9zaXRpb25bMV07XG4gICAgICB2YWx1ZVtpICsgMl0gPSAwO1xuICAgICAgdmFsdWVbaSArIDNdID0gZWxldmF0aW9uO1xuICAgICAgaSArPSBzaXplO1xuICAgIH1cbiAgfVxuXG4gIGNhbGN1bGF0ZUluc3RhbmNlUG9zaXRpb25zNjR4eUxvdyhhdHRyaWJ1dGUpIHtcbiAgICBjb25zdCB7ZGF0YSwgZ2V0UG9zaXRpb259ID0gdGhpcy5wcm9wcztcbiAgICBjb25zdCB7dmFsdWV9ID0gYXR0cmlidXRlO1xuICAgIGxldCBpID0gMDtcbiAgICBmb3IgKGNvbnN0IHBvaW50IG9mIGRhdGEpIHtcbiAgICAgIGNvbnN0IHBvc2l0aW9uID0gZ2V0UG9zaXRpb24ocG9pbnQpO1xuICAgICAgdmFsdWVbaSsrXSA9IGZwNjRMb3dQYXJ0KHBvc2l0aW9uWzBdKTtcbiAgICAgIHZhbHVlW2krK10gPSBmcDY0TG93UGFydChwb3NpdGlvblsxXSk7XG4gICAgfVxuICB9XG5cbiAgY2FsY3VsYXRlSW5zdGFuY2VDb2xvcnMoYXR0cmlidXRlKSB7XG4gICAgY29uc3Qge2RhdGEsIGdldENvbG9yfSA9IHRoaXMucHJvcHM7XG4gICAgY29uc3Qge3ZhbHVlLCBzaXplfSA9IGF0dHJpYnV0ZTtcbiAgICBsZXQgaSA9IDA7XG4gICAgZm9yIChjb25zdCBvYmplY3Qgb2YgZGF0YSkge1xuICAgICAgY29uc3QgY29sb3IgPSBnZXRDb2xvcihvYmplY3QpIHx8IERFRkFVTFRfQ09MT1I7XG4gICAgICB2YWx1ZVtpICsgMF0gPSBjb2xvclswXTtcbiAgICAgIHZhbHVlW2kgKyAxXSA9IGNvbG9yWzFdO1xuICAgICAgdmFsdWVbaSArIDJdID0gY29sb3JbMl07XG4gICAgICB2YWx1ZVtpICsgM10gPSBOdW1iZXIuaXNGaW5pdGUoY29sb3JbM10pID8gY29sb3JbM10gOiBERUZBVUxUX0NPTE9SWzNdO1xuICAgICAgaSArPSBzaXplO1xuICAgIH1cbiAgfVxufVxuXG5HcmlkQ2VsbExheWVyLmxheWVyTmFtZSA9ICdHcmlkQ2VsbExheWVyJztcbkdyaWRDZWxsTGF5ZXIuZGVmYXVsdFByb3BzID0gZGVmYXVsdFByb3BzO1xuIl19