var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, Geometry, Texture2D, loadTextures } from 'luma.gl';

import vs from './icon-layer-vertex.glsl';
import vs64 from './icon-layer-vertex-64.glsl';
import fs from './icon-layer-fragment.glsl';

var DEFAULT_COLOR = [0, 0, 0, 255];
var DEFAULT_TEXTURE_MIN_FILTER = GL.LINEAR_MIPMAP_LINEAR;
// GL.LINEAR is the default value but explicitly set it here
var DEFAULT_TEXTURE_MAG_FILTER = GL.LINEAR;

/*
 * @param {object} props
 * @param {Texture2D | string} props.iconAtlas - atlas image url or texture
 * @param {object} props.iconMapping - icon names mapped to icon definitions
 * @param {object} props.iconMapping[icon_name].x - x position of icon on the atlas image
 * @param {object} props.iconMapping[icon_name].y - y position of icon on the atlas image
 * @param {object} props.iconMapping[icon_name].width - width of icon on the atlas image
 * @param {object} props.iconMapping[icon_name].height - height of icon on the atlas image
 * @param {object} props.iconMapping[icon_name].anchorX - x anchor of icon on the atlas image,
 *   default to width / 2
 * @param {object} props.iconMapping[icon_name].anchorY - y anchor of icon on the atlas image,
 *   default to height / 2
 * @param {object} props.iconMapping[icon_name].mask - whether icon is treated as a transparency
 *   mask. If true, user defined color is applied. If false, original color from the image is
 *   applied. Default to false.
 * @param {number} props.size - icon size in pixels
 * @param {func} props.getPosition - returns anchor position of the icon, in [lng, lat, z]
 * @param {func} props.getIcon - returns icon name as a string
 * @param {func} props.getSize - returns icon size multiplier as a number
 * @param {func} props.getColor - returns color of the icon in [r, g, b, a]. Only works on icons
 *   with mask: true.
 * @param {func} props.getAngle - returns rotating angle (in degree) of the icon.
 */
var defaultProps = {
  iconAtlas: null,
  iconMapping: {},
  sizeScale: 1,
  fp64: false,

  getPosition: function getPosition(x) {
    return x.position;
  },
  getIcon: function getIcon(x) {
    return x.icon;
  },
  getColor: function getColor(x) {
    return x.color || DEFAULT_COLOR;
  },
  getSize: function getSize(x) {
    return x.size || 1;
  },
  getAngle: function getAngle(x) {
    return x.angle || 0;
  }
};

var IconLayer = function (_Layer) {
  _inherits(IconLayer, _Layer);

  function IconLayer() {
    _classCallCheck(this, IconLayer);

    return _possibleConstructorReturn(this, (IconLayer.__proto__ || Object.getPrototypeOf(IconLayer)).apply(this, arguments));
  }

  _createClass(IconLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'picking'] } : { vs: vs, fs: fs, modules: ['picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();

      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          transition: true,
          accessor: 'getPosition',
          update: this.calculateInstancePositions
        },
        instanceSizes: {
          size: 1,
          transition: true,
          accessor: 'getSize',
          update: this.calculateInstanceSizes
        },
        instanceOffsets: { size: 2, accessor: 'getIcon', update: this.calculateInstanceOffsets },
        instanceIconFrames: { size: 4, accessor: 'getIcon', update: this.calculateInstanceIconFrames },
        instanceColorModes: {
          size: 1,
          type: GL.UNSIGNED_BYTE,
          accessor: 'getIcon',
          update: this.calculateInstanceColorMode
        },
        instanceColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getColor',
          update: this.calculateInstanceColors
        },
        instanceAngles: {
          size: 1,
          transition: true,
          accessor: 'getAngle',
          update: this.calculateInstanceAngles
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instancePositions64xyLow: {
              size: 2,
              accessor: 'getPosition',
              update: this.calculateInstancePositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instancePositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var _this2 = this;

      var oldProps = _ref2.oldProps,
          props = _ref2.props,
          changeFlags = _ref2.changeFlags;

      _get(IconLayer.prototype.__proto__ || Object.getPrototypeOf(IconLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });

      var iconAtlas = props.iconAtlas,
          iconMapping = props.iconMapping;


      if (oldProps.iconMapping !== iconMapping) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidate('instanceOffsets');
        attributeManager.invalidate('instanceIconFrames');
        attributeManager.invalidate('instanceColorModes');
      }

      if (oldProps.iconAtlas !== iconAtlas) {
        if (iconAtlas instanceof Texture2D) {
          var _iconAtlas$setParamet;

          iconAtlas.setParameters((_iconAtlas$setParamet = {}, _defineProperty(_iconAtlas$setParamet, GL.TEXTURE_MIN_FILTER, DEFAULT_TEXTURE_MIN_FILTER), _defineProperty(_iconAtlas$setParamet, GL.TEXTURE_MAG_FILTER, DEFAULT_TEXTURE_MAG_FILTER), _iconAtlas$setParamet));
          this.setState({ iconsTexture: iconAtlas });
        } else if (typeof iconAtlas === 'string') {
          loadTextures(this.context.gl, {
            urls: [iconAtlas]
          }).then(function (_ref3) {
            var _texture$setParameter;

            var _ref4 = _slicedToArray(_ref3, 1),
                texture = _ref4[0];

            texture.setParameters((_texture$setParameter = {}, _defineProperty(_texture$setParameter, GL.TEXTURE_MIN_FILTER, DEFAULT_TEXTURE_MIN_FILTER), _defineProperty(_texture$setParameter, GL.TEXTURE_MAG_FILTER, DEFAULT_TEXTURE_MAG_FILTER), _texture$setParameter));
            _this2.setState({ iconsTexture: texture });
          });
        }
      }

      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });
    }
  }, {
    key: 'draw',
    value: function draw(_ref5) {
      var uniforms = _ref5.uniforms;
      var sizeScale = this.props.sizeScale;
      var iconsTexture = this.state.iconsTexture;


      if (iconsTexture) {
        this.state.model.render(Object.assign({}, uniforms, {
          iconsTexture: iconsTexture,
          iconsTextureDim: [iconsTexture.width, iconsTexture.height],
          sizeScale: sizeScale
        }));
      }
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      var positions = [-1, -1, 0, -1, 1, 0, 1, 1, 0, 1, -1, 0];

      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: GL.TRIANGLE_FAN,
          attributes: {
            positions: new Float32Array(positions)
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props = this.props,
          data = _props.data,
          getPosition = _props.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var object = _step.value;

          var position = getPosition(object);
          value[i++] = position[0];
          value[i++] = position[1];
          value[i++] = position[2] || 0;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64xyLow',
    value: function calculateInstancePositions64xyLow(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getPosition = _props2.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var point = _step2.value;

          var position = getPosition(point);
          value[i++] = fp64LowPart(position[0]);
          value[i++] = fp64LowPart(position[1]);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceSizes',
    value: function calculateInstanceSizes(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getSize = _props3.getSize;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var object = _step3.value;

          value[i++] = getSize(object);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceAngles',
    value: function calculateInstanceAngles(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getAngle = _props4.getAngle;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = data[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var object = _step4.value;

          value[i++] = getAngle(object);
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props5 = this.props,
          data = _props5.data,
          getColor = _props5.getColor;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion5 = true;
      var _didIteratorError5 = false;
      var _iteratorError5 = undefined;

      try {
        for (var _iterator5 = data[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
          var object = _step5.value;

          var color = getColor(object);

          value[i++] = color[0];
          value[i++] = color[1];
          value[i++] = color[2];
          value[i++] = isNaN(color[3]) ? 255 : color[3];
        }
      } catch (err) {
        _didIteratorError5 = true;
        _iteratorError5 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion5 && _iterator5.return) {
            _iterator5.return();
          }
        } finally {
          if (_didIteratorError5) {
            throw _iteratorError5;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceOffsets',
    value: function calculateInstanceOffsets(attribute) {
      var _props6 = this.props,
          data = _props6.data,
          iconMapping = _props6.iconMapping,
          getIcon = _props6.getIcon;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion6 = true;
      var _didIteratorError6 = false;
      var _iteratorError6 = undefined;

      try {
        for (var _iterator6 = data[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
          var object = _step6.value;

          var icon = getIcon(object);
          var rect = iconMapping[icon] || {};
          value[i++] = rect.width / 2 - rect.anchorX || 0;
          value[i++] = rect.height / 2 - rect.anchorY || 0;
        }
      } catch (err) {
        _didIteratorError6 = true;
        _iteratorError6 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion6 && _iterator6.return) {
            _iterator6.return();
          }
        } finally {
          if (_didIteratorError6) {
            throw _iteratorError6;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColorMode',
    value: function calculateInstanceColorMode(attribute) {
      var _props7 = this.props,
          data = _props7.data,
          iconMapping = _props7.iconMapping,
          getIcon = _props7.getIcon;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion7 = true;
      var _didIteratorError7 = false;
      var _iteratorError7 = undefined;

      try {
        for (var _iterator7 = data[Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
          var object = _step7.value;

          var icon = getIcon(object);
          var colorMode = iconMapping[icon] && iconMapping[icon].mask;
          value[i++] = colorMode ? 1 : 0;
        }
      } catch (err) {
        _didIteratorError7 = true;
        _iteratorError7 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion7 && _iterator7.return) {
            _iterator7.return();
          }
        } finally {
          if (_didIteratorError7) {
            throw _iteratorError7;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceIconFrames',
    value: function calculateInstanceIconFrames(attribute) {
      var _props8 = this.props,
          data = _props8.data,
          iconMapping = _props8.iconMapping,
          getIcon = _props8.getIcon;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion8 = true;
      var _didIteratorError8 = false;
      var _iteratorError8 = undefined;

      try {
        for (var _iterator8 = data[Symbol.iterator](), _step8; !(_iteratorNormalCompletion8 = (_step8 = _iterator8.next()).done); _iteratorNormalCompletion8 = true) {
          var object = _step8.value;

          var icon = getIcon(object);
          var rect = iconMapping[icon] || {};
          value[i++] = rect.x || 0;
          value[i++] = rect.y || 0;
          value[i++] = rect.width || 0;
          value[i++] = rect.height || 0;
        }
      } catch (err) {
        _didIteratorError8 = true;
        _iteratorError8 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion8 && _iterator8.return) {
            _iterator8.return();
          }
        } finally {
          if (_didIteratorError8) {
            throw _iteratorError8;
          }
        }
      }
    }
  }]);

  return IconLayer;
}(Layer);

export default IconLayer;


IconLayer.layerName = 'IconLayer';
IconLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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