// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME line-layer-vertex-shader-64\n\nattribute vec3 positions;\nattribute vec3 instanceSourcePositions;\nattribute vec3 instanceTargetPositions;\nattribute vec4 instanceSourceTargetPositions64xyLow;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nvoid main(void) {\n  // Position\n  vec4 instanceSourcePositions64 = vec4(\n    instanceSourcePositions.x, instanceSourceTargetPositions64xyLow.x,\n    instanceSourcePositions.y, instanceSourceTargetPositions64xyLow.y);\n\n  vec4 instanceTargetPositions64 = vec4(\n    instanceTargetPositions.x, instanceSourceTargetPositions64xyLow.z,\n    instanceTargetPositions.y, instanceSourceTargetPositions64xyLow.w);\n\n  vec2 projected_source_coord[2];\n  vec2 projected_target_coord[2];\n\n  project_position_fp64(instanceSourcePositions64, projected_source_coord);\n  project_position_fp64(instanceTargetPositions64, projected_target_coord);\n\n  vec2 source_pos_modelspace[4];\n  source_pos_modelspace[0] =  projected_source_coord[0];\n  source_pos_modelspace[1] =  projected_source_coord[1];\n  source_pos_modelspace[2] = vec2(project_scale(instanceSourcePositions.z), 0.0);\n  source_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  vec4 source_pos_clipspace = project_to_clipspace_fp64(source_pos_modelspace);\n\n  vec2 target_pos_modelspace[4];\n  target_pos_modelspace[0] =  projected_target_coord[0];\n  target_pos_modelspace[1] =  projected_target_coord[1];\n  target_pos_modelspace[2] = vec2(project_scale(instanceTargetPositions.z), 0.0);\n  target_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  vec4 target_pos_clipspace = project_to_clipspace_fp64(target_pos_modelspace);\n\n  float segmentIndex = positions.x;\n  vec4 p = mix(source_pos_clipspace, target_pos_clipspace, segmentIndex);\n\n  vec2 offset = getExtrusionOffset(target_pos_clipspace.xy - source_pos_clipspace.xy, positions.y);\n\n  gl_Position = p + vec4(offset, 0.0, 0.0);\n\n  // Color\n  vColor = vec4(instanceColors.rgb, instanceColors.a * opacity) / 255.;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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