var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, Geometry } from 'luma.gl';

import vs from './line-layer-vertex.glsl';
import vs64 from './line-layer-vertex-64.glsl';
import fs from './line-layer-fragment.glsl';

var DEFAULT_COLOR = [0, 0, 0, 255];

var defaultProps = {
  strokeWidth: 1,
  fp64: false,

  getSourcePosition: function getSourcePosition(x) {
    return x.sourcePosition;
  },
  getTargetPosition: function getTargetPosition(x) {
    return x.targetPosition;
  },
  getColor: function getColor(x) {
    return x.color || DEFAULT_COLOR;
  }
};

var LineLayer = function (_Layer) {
  _inherits(LineLayer, _Layer);

  function LineLayer() {
    _classCallCheck(this, LineLayer);

    return _possibleConstructorReturn(this, (LineLayer.__proto__ || Object.getPrototypeOf(LineLayer)).apply(this, arguments));
  }

  _createClass(LineLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'picking'] } : { vs: vs, fs: fs, modules: ['picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();

      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instanceSourcePositions: {
          size: 3,
          transition: true,
          accessor: 'getSourcePosition',
          update: this.calculateInstanceSourcePositions
        },
        instanceTargetPositions: {
          size: 3,
          transition: true,
          accessor: 'getTargetPosition',
          update: this.calculateInstanceTargetPositions
        },
        instanceColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getColor',
          update: this.calculateInstanceColors
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instanceSourceTargetPositions64xyLow: {
              size: 4,
              accessor: ['getSourcePosition', 'getTargetPosition'],
              update: this.calculateInstanceSourceTargetPositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instanceSourceTargetPositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      _get(LineLayer.prototype.__proto__ || Object.getPrototypeOf(LineLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });

      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var strokeWidth = this.props.strokeWidth;


      this.state.model.render(Object.assign({}, uniforms, {
        strokeWidth: strokeWidth
      }));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      /*
       *  (0, -1)-------------_(1, -1)
       *       |          _,-"  |
       *       o      _,-"      o
       *       |  _,-"          |
       *   (0, 1)"-------------(1, 1)
       */
      var positions = [0, -1, 0, 0, 1, 0, 1, -1, 0, 1, 1, 0];

      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: GL.TRIANGLE_STRIP,
          attributes: {
            positions: new Float32Array(positions)
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'calculateInstanceSourcePositions',
    value: function calculateInstanceSourcePositions(attribute) {
      var _props = this.props,
          data = _props.data,
          getSourcePosition = _props.getSourcePosition;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var object = _step.value;

          var sourcePosition = getSourcePosition(object);
          value[i + 0] = sourcePosition[0];
          value[i + 1] = sourcePosition[1];
          value[i + 2] = isNaN(sourcePosition[2]) ? 0 : sourcePosition[2];
          i += size;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceTargetPositions',
    value: function calculateInstanceTargetPositions(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getTargetPosition = _props2.getTargetPosition;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var object = _step2.value;

          var targetPosition = getTargetPosition(object);
          value[i + 0] = targetPosition[0];
          value[i + 1] = targetPosition[1];
          value[i + 2] = isNaN(targetPosition[2]) ? 0 : targetPosition[2];
          i += size;
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceSourceTargetPositions64xyLow',
    value: function calculateInstanceSourceTargetPositions64xyLow(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getSourcePosition = _props3.getSourcePosition,
          getTargetPosition = _props3.getTargetPosition;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var object = _step3.value;

          var sourcePosition = getSourcePosition(object);
          var targetPosition = getTargetPosition(object);
          value[i + 0] = fp64LowPart(sourcePosition[0]);
          value[i + 1] = fp64LowPart(sourcePosition[1]);
          value[i + 2] = fp64LowPart(targetPosition[0]);
          value[i + 3] = fp64LowPart(targetPosition[1]);
          i += size;
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getColor = _props4.getColor;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = data[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var object = _step4.value;

          var color = getColor(object);
          value[i + 0] = color[0];
          value[i + 1] = color[1];
          value[i + 2] = color[2];
          value[i + 3] = isNaN(color[3]) ? 255 : color[3];
          i += size;
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }
  }]);

  return LineLayer;
}(Layer);

export default LineLayer;


LineLayer.layerName = 'LineLayer';
LineLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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