var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, Geometry } from 'luma.gl';

import vs from './point-cloud-layer-vertex.glsl';
import vs64 from './point-cloud-layer-vertex-64.glsl';
import fs from './point-cloud-layer-fragment.glsl';

var DEFAULT_COLOR = [0, 0, 0, 255];

var defaultProps = {
  radiusPixels: 10, //  point radius in pixels
  fp64: false,

  getPosition: function getPosition(x) {
    return x.position;
  },
  getNormal: function getNormal(x) {
    return x.normal;
  },
  getColor: function getColor(x) {
    return x.color || DEFAULT_COLOR;
  },

  lightSettings: {
    lightsPosition: [0, 0, 5000, -1000, 1000, 8000, 5000, -5000, 1000],
    ambientRatio: 0.2,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [1.0, 0.0, 0.8, 0.0, 0.4, 0.0],
    numberOfLights: 3
  }
};

var PointCloudLayer = function (_Layer) {
  _inherits(PointCloudLayer, _Layer);

  function PointCloudLayer() {
    _classCallCheck(this, PointCloudLayer);

    return _possibleConstructorReturn(this, (PointCloudLayer.__proto__ || Object.getPrototypeOf(PointCloudLayer)).apply(this, arguments));
  }

  _createClass(PointCloudLayer, [{
    key: 'getShaders',
    value: function getShaders(id) {
      var shaderCache = this.context.shaderCache;

      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'lighting', 'picking'], shaderCache: shaderCache } : { vs: vs, fs: fs, modules: ['lighting', 'picking'], shaderCache: shaderCache }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      /* eslint-disable max-len */
      this.state.attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          transition: true,
          accessor: 'getPosition',
          update: this.calculateInstancePositions
        },
        instanceNormals: {
          size: 3,
          transition: true,
          accessor: 'getNormal',
          defaultValue: 1,
          update: this.calculateInstanceNormals
        },
        instanceColors: {
          size: 4,
          type: GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getColor',
          update: this.calculateInstanceColors
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instancePositions64xyLow: {
              size: 2,
              accessor: 'getPosition',
              update: this.calculateInstancePositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instancePositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      _get(PointCloudLayer.prototype.__proto__ || Object.getPrototypeOf(PointCloudLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var _props = this.props,
          radiusPixels = _props.radiusPixels,
          lightSettings = _props.lightSettings;

      this.state.model.render(Object.assign({}, uniforms, {
        radiusPixels: radiusPixels
      }, lightSettings));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      // a triangle that minimally cover the unit circle
      var positions = [];
      for (var i = 0; i < 3; i++) {
        var angle = i / 3 * Math.PI * 2;
        positions.push(Math.cos(angle) * 2, Math.sin(angle) * 2, 0);
      }

      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: GL.TRIANGLES,
          attributes: {
            positions: new Float32Array(positions)
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getPosition = _props2.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var point = _step.value;

          var position = getPosition(point);
          value[i++] = position[0];
          value[i++] = position[1];
          value[i++] = position[2] || 0;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64xyLow',
    value: function calculateInstancePositions64xyLow(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getPosition = _props3.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var point = _step2.value;

          var position = getPosition(point);
          value[i++] = fp64LowPart(position[0]);
          value[i++] = fp64LowPart(position[1]);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceNormals',
    value: function calculateInstanceNormals(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getNormal = _props4.getNormal;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var point = _step3.value;

          var normal = getNormal(point);
          value[i++] = normal[0];
          value[i++] = normal[1];
          value[i++] = normal[2];
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props5 = this.props,
          data = _props5.data,
          getColor = _props5.getColor;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = data[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var point = _step4.value;

          var color = getColor(point);
          value[i++] = color[0];
          value[i++] = color[1];
          value[i++] = color[2];
          value[i++] = isNaN(color[3]) ? 255 : color[3];
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }
  }]);

  return PointCloudLayer;
}(Layer);

export default PointCloudLayer;


PointCloudLayer.layerName = 'PointCloudLayer';
PointCloudLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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