var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, Geometry } from 'luma.gl';

import vs from './scatterplot-layer-vertex.glsl';
import vs64 from './scatterplot-layer-vertex-64.glsl';
import fs from './scatterplot-layer-fragment.glsl';

var DEFAULT_COLOR = [0, 0, 0, 255];

var defaultProps = {
  radiusScale: 1,
  radiusMinPixels: 0, //  min point radius in pixels
  radiusMaxPixels: Number.MAX_SAFE_INTEGER, // max point radius in pixels
  strokeWidth: 1,
  outline: false,
  fp64: false,

  getPosition: function getPosition(x) {
    return x.position;
  },
  getRadius: function getRadius(x) {
    return x.radius || 1;
  },
  getColor: function getColor(x) {
    return x.color || DEFAULT_COLOR;
  }
};

var ScatterplotLayer = function (_Layer) {
  _inherits(ScatterplotLayer, _Layer);

  function ScatterplotLayer() {
    _classCallCheck(this, ScatterplotLayer);

    return _possibleConstructorReturn(this, (ScatterplotLayer.__proto__ || Object.getPrototypeOf(ScatterplotLayer)).apply(this, arguments));
  }

  _createClass(ScatterplotLayer, [{
    key: 'getShaders',
    value: function getShaders(id) {
      var shaderCache = this.context.shaderCache;

      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'picking'], shaderCache: shaderCache } : { vs: vs, fs: fs, modules: ['picking'], shaderCache: shaderCache }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      /* eslint-disable max-len */
      this.state.attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          transition: true,
          accessor: 'getPosition',
          update: this.calculateInstancePositions
        },
        instanceRadius: {
          size: 1,
          transition: true,
          accessor: 'getRadius',
          defaultValue: 1,
          update: this.calculateInstanceRadius
        },
        instanceColors: {
          size: 4,
          transition: true,
          type: GL.UNSIGNED_BYTE,
          accessor: 'getColor',
          update: this.calculateInstanceColors
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instancePositions64xyLow: {
              size: 2,
              accessor: 'getPosition',
              update: this.calculateInstancePositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instancePositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      _get(ScatterplotLayer.prototype.__proto__ || Object.getPrototypeOf(ScatterplotLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var _props = this.props,
          radiusScale = _props.radiusScale,
          radiusMinPixels = _props.radiusMinPixels,
          radiusMaxPixels = _props.radiusMaxPixels,
          outline = _props.outline,
          strokeWidth = _props.strokeWidth;

      this.state.model.render(Object.assign({}, uniforms, {
        outline: outline ? 1 : 0,
        strokeWidth: strokeWidth,
        radiusScale: radiusScale,
        radiusMinPixels: radiusMinPixels,
        radiusMaxPixels: radiusMaxPixels
      }));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      // a square that minimally cover the unit circle
      var positions = [-1, -1, 0, -1, 1, 0, 1, 1, 0, 1, -1, 0];

      return new Model(gl, Object.assign(this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: GL.TRIANGLE_FAN,
          attributes: {
            positions: new Float32Array(positions)
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getPosition = _props2.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var point = _step.value;

          var position = getPosition(point);
          value[i++] = position[0];
          value[i++] = position[1];
          value[i++] = position[2] || 0;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64xyLow',
    value: function calculateInstancePositions64xyLow(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getPosition = _props3.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var point = _step2.value;

          var position = getPosition(point);
          value[i++] = fp64LowPart(position[0]);
          value[i++] = fp64LowPart(position[1]);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceRadius',
    value: function calculateInstanceRadius(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getRadius = _props4.getRadius;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var point = _step3.value;

          var radius = getRadius(point);
          value[i++] = isNaN(radius) ? 1 : radius;
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props5 = this.props,
          data = _props5.data,
          getColor = _props5.getColor;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = data[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var point = _step4.value;

          var color = getColor(point) || DEFAULT_COLOR;
          value[i++] = color[0];
          value[i++] = color[1];
          value[i++] = color[2];
          value[i++] = isNaN(color[3]) ? 255 : color[3];
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }
  }]);

  return ScatterplotLayer;
}(Layer);

export default ScatterplotLayer;


ScatterplotLayer.layerName = 'ScatterplotLayer';
ScatterplotLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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