var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { Layer } from '../../core';
import { GL, Model, Geometry } from 'luma.gl';

import vs from './screen-grid-layer-vertex.glsl';
import fs from './screen-grid-layer-fragment.glsl';

var defaultProps = {
  cellSizePixels: 100,

  // Color range?
  minColor: [0, 0, 0, 255],
  maxColor: [0, 255, 0, 255],

  getPosition: function getPosition(d) {
    return d.position;
  },
  getWeight: function getWeight(d) {
    return 1;
  }
};

var ScreenGridLayer = function (_Layer) {
  _inherits(ScreenGridLayer, _Layer);

  function ScreenGridLayer() {
    _classCallCheck(this, ScreenGridLayer);

    return _possibleConstructorReturn(this, (ScreenGridLayer.__proto__ || Object.getPrototypeOf(ScreenGridLayer)).apply(this, arguments));
  }

  _createClass(ScreenGridLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return { vs: vs, fs: fs, modules: ['picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      var gl = this.context.gl;

      /* eslint-disable max-len */

      attributeManager.addInstanced({
        instancePositions: { size: 3, update: this.calculateInstancePositions },
        instanceCount: {
          size: 1,
          accessor: ['getPosition', 'getWeight'],
          update: this.calculateInstanceCount
        }
      });
      /* eslint-disable max-len */

      this.setState({ model: this._getModel(gl) });
    }
  }, {
    key: 'shouldUpdateState',
    value: function shouldUpdateState(_ref) {
      var changeFlags = _ref.changeFlags;

      return changeFlags.somethingChanged;
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var oldProps = _ref2.oldProps,
          props = _ref2.props,
          changeFlags = _ref2.changeFlags;

      _get(ScreenGridLayer.prototype.__proto__ || Object.getPrototypeOf(ScreenGridLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });
      var cellSizeChanged = props.cellSizePixels !== oldProps.cellSizePixels;

      if (cellSizeChanged || changeFlags.viewportChanged) {
        this.updateCell();
      }
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var _props = this.props,
          minColor = _props.minColor,
          maxColor = _props.maxColor,
          _props$parameters = _props.parameters,
          parameters = _props$parameters === undefined ? {} : _props$parameters;
      var _state = this.state,
          model = _state.model,
          cellScale = _state.cellScale,
          maxCount = _state.maxCount;

      uniforms = Object.assign({}, uniforms, { minColor: minColor, maxColor: maxColor, cellScale: cellScale, maxCount: maxCount });
      model.draw({
        uniforms: uniforms,
        parameters: Object.assign({
          depthTest: false,
          depthMask: false
        }, parameters)
      });
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: GL.TRIANGLE_FAN,
          attributes: {
            vertices: new Float32Array([0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0])
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'updateCell',
    value: function updateCell() {
      var _context$viewport = this.context.viewport,
          width = _context$viewport.width,
          height = _context$viewport.height;
      var cellSizePixels = this.props.cellSizePixels;


      var MARGIN = 2;
      var cellScale = new Float32Array([(cellSizePixels - MARGIN) / width * 2, -(cellSizePixels - MARGIN) / height * 2, 1]);
      var numCol = Math.ceil(width / cellSizePixels);
      var numRow = Math.ceil(height / cellSizePixels);

      this.setState({
        cellScale: cellScale,
        numCol: numCol,
        numRow: numRow,
        numInstances: numCol * numRow
      });

      var attributeManager = this.getAttributeManager();
      attributeManager.invalidateAll();
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute, _ref4) {
      var numInstances = _ref4.numInstances;
      var _context$viewport2 = this.context.viewport,
          width = _context$viewport2.width,
          height = _context$viewport2.height;
      var cellSizePixels = this.props.cellSizePixels;
      var numCol = this.state.numCol;
      var value = attribute.value,
          size = attribute.size;


      for (var i = 0; i < numInstances; i++) {
        var x = i % numCol;
        var y = Math.floor(i / numCol);
        value[i * size + 0] = x * cellSizePixels / width * 2 - 1;
        value[i * size + 1] = 1 - y * cellSizePixels / height * 2;
        value[i * size + 2] = 0;
      }
    }
  }, {
    key: 'calculateInstanceCount',
    value: function calculateInstanceCount(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          cellSizePixels = _props2.cellSizePixels,
          getPosition = _props2.getPosition,
          getWeight = _props2.getWeight;
      var _state2 = this.state,
          numCol = _state2.numCol,
          numRow = _state2.numRow;
      var value = attribute.value;

      var maxCount = 0;

      value.fill(0.0);

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var point = _step.value;

          var pixel = this.project(getPosition(point));
          var colId = Math.floor(pixel[0] / cellSizePixels);
          var rowId = Math.floor(pixel[1] / cellSizePixels);
          if (colId >= 0 && colId < numCol && rowId >= 0 && rowId < numRow) {
            var i = colId + rowId * numCol;
            value[i] += getWeight(point);
            if (value[i] > maxCount) {
              maxCount = value[i];
            }
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      this.setState({ maxCount: maxCount });
    }
  }]);

  return ScreenGridLayer;
}(Layer);

export default ScreenGridLayer;


ScreenGridLayer.layerName = 'ScreenGridLayer';
ScreenGridLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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