var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import * as Polygon from './polygon';
import { experimental } from '../../core';
var fp64LowPart = experimental.fp64LowPart,
    fillArray = experimental.fillArray;

import earcut from 'earcut';

function getPickingColor(index) {
  return [index + 1 & 255, index + 1 >> 8 & 255, index + 1 >> 8 >> 8 & 255];
}

function arrayPush(array, values) {
  var length = values.length;
  var offset = array.length;

  for (var index = 0; index < length; index++) {
    array[offset++] = values[index];
  }
  return array;
}

function flatten(values, level) {
  var result = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

  if (level > 1) {
    values.forEach(function (v) {
      return flatten(v, level - 1, result);
    });
  } else {
    arrayPush(result, values);
  }
  return result;
}

var DEFAULT_COLOR = [0, 0, 0, 255]; // Black

export var PolygonTesselatorExtruded = function () {
  function PolygonTesselatorExtruded(_ref) {
    var polygons = _ref.polygons,
        _ref$getHeight = _ref.getHeight,
        getHeight = _ref$getHeight === undefined ? function (x) {
      return 1000;
    } : _ref$getHeight,
        _ref$getColor = _ref.getColor,
        getColor = _ref$getColor === undefined ? function (x) {
      return DEFAULT_COLOR;
    } : _ref$getColor,
        _ref$wireframe = _ref.wireframe,
        wireframe = _ref$wireframe === undefined ? false : _ref$wireframe,
        _ref$fp = _ref.fp64,
        fp64 = _ref$fp === undefined ? false : _ref$fp;

    _classCallCheck(this, PolygonTesselatorExtruded);

    this.fp64 = fp64;

    // Expensive operation, convert all polygons to arrays
    polygons = polygons.map(function (complexPolygon, polygonIndex) {
      var height = getHeight(polygonIndex) || 0;
      return Polygon.normalize(complexPolygon).map(function (polygon) {
        return polygon.map(function (coord) {
          return [coord[0], coord[1], height];
        });
      });
    });

    var groupedVertices = polygons;
    this.groupedVertices = polygons;
    var pointCount = getPointCount(polygons);
    this.pointCount = pointCount;
    this.wireframe = wireframe;

    this.attributes = {};

    var positionsJS = calculatePositionsJS({ groupedVertices: groupedVertices, pointCount: pointCount, wireframe: wireframe });
    Object.assign(this.attributes, {
      positions: calculatePositions(positionsJS, this.fp64),
      indices: calculateIndices({ groupedVertices: groupedVertices, wireframe: wireframe }),
      normals: calculateNormals({ groupedVertices: groupedVertices, pointCount: pointCount, wireframe: wireframe }),
      // colors: calculateColors({groupedVertices, wireframe, getColor}),
      pickingColors: calculatePickingColors({ groupedVertices: groupedVertices, pointCount: pointCount, wireframe: wireframe })
    });
  }

  _createClass(PolygonTesselatorExtruded, [{
    key: 'indices',
    value: function indices() {
      return this.attributes.indices;
    }
  }, {
    key: 'positions',
    value: function positions() {
      return this.attributes.positions;
    }
  }, {
    key: 'normals',
    value: function normals() {
      return this.attributes.normals;
    }
  }, {
    key: 'colors',
    value: function colors() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$getColor = _ref2.getColor,
          getColor = _ref2$getColor === undefined ? function (x) {
        return DEFAULT_COLOR;
      } : _ref2$getColor;

      var groupedVertices = this.groupedVertices,
          pointCount = this.pointCount,
          wireframe = this.wireframe;

      return calculateColors({ groupedVertices: groupedVertices, pointCount: pointCount, wireframe: wireframe, getColor: getColor });
    }
  }, {
    key: 'pickingColors',
    value: function pickingColors() {
      return this.attributes.pickingColors;
    }

    // updateTriggers: {
    //   positions: ['getHeight'],
    //   colors: ['getColors']
    //   pickingColors: 'none'
    // }

  }]);

  return PolygonTesselatorExtruded;
}();

// Count number of points in a list of complex polygons
function getPointCount(polygons) {
  return polygons.reduce(function (points, polygon) {
    return points + Polygon.getVertexCount(polygon);
  }, 0);
}

function calculateIndices(_ref3) {
  var groupedVertices = _ref3.groupedVertices,
      _ref3$wireframe = _ref3.wireframe,
      wireframe = _ref3$wireframe === undefined ? false : _ref3$wireframe;

  // adjust index offset for multiple polygons
  var multiplier = wireframe ? 2 : 5;
  var offsets = [];
  groupedVertices.reduce(function (vertexIndex, vertices) {
    offsets.push(vertexIndex);
    return vertexIndex + Polygon.getVertexCount(vertices) * multiplier;
  }, 0);

  var indices = groupedVertices.map(function (vertices, polygonIndex) {
    return wireframe ? // 1. get sequentially ordered indices of each polygons wireframe
    // 2. offset them by the number of indices in previous polygons
    calculateContourIndices(vertices, offsets[polygonIndex]) : // 1. get triangulated indices for the internal areas
    // 2. offset them by the number of indices in previous polygons
    calculateSurfaceIndices(vertices, offsets[polygonIndex]);
  });

  return new Uint32Array(flatten(indices, 2));
}

// Calculate a flat position array in JS - can be mapped to 32 or 64 bit typed arrays
// Remarks:
// * each top vertex is on 3 surfaces
// * each bottom vertex is on 2 surfaces
function calculatePositionsJS(_ref4) {
  var groupedVertices = _ref4.groupedVertices,
      pointCount = _ref4.pointCount,
      _ref4$wireframe = _ref4.wireframe,
      wireframe = _ref4$wireframe === undefined ? false : _ref4$wireframe;

  var multiplier = wireframe ? 2 : 5;
  var positions = new Float32Array(pointCount * 3 * multiplier);
  var vertexIndex = 0;

  groupedVertices.forEach(function (vertices) {
    var topVertices = flatten(vertices, 3);

    var baseVertices = topVertices.slice(0);
    var i = topVertices.length - 1;
    while (i > 0) {
      baseVertices[i] = 0;
      i -= 3;
    }
    var len = topVertices.length;

    if (wireframe) {
      fillArray({ target: positions, source: topVertices, start: vertexIndex });
      fillArray({ target: positions, source: baseVertices, start: vertexIndex + len });
    } else {
      fillArray({ target: positions, source: topVertices, start: vertexIndex, count: 3 });
      fillArray({
        target: positions,
        source: baseVertices,
        start: vertexIndex + len * 3,
        count: 2
      });
    }
    vertexIndex += len * multiplier;
  });

  return positions;
}

function calculatePositions(positionsJS, fp64) {
  var positionLow = void 0;
  if (fp64) {
    // We only need x, y component
    var vertexCount = positionsJS.length / 3;
    positionLow = new Float32Array(vertexCount * 2);
    for (var i = 0; i < vertexCount; i++) {
      positionLow[i * 2 + 0] = fp64LowPart(positionsJS[i * 3 + 0]);
      positionLow[i * 2 + 1] = fp64LowPart(positionsJS[i * 3 + 1]);
    }
  }
  return { positions: positionsJS, positions64xyLow: positionLow };
}

function calculateNormals(_ref5) {
  var groupedVertices = _ref5.groupedVertices,
      pointCount = _ref5.pointCount,
      wireframe = _ref5.wireframe;

  var up = [0, 0, 1];
  var multiplier = wireframe ? 2 : 5;

  var normals = new Float32Array(pointCount * 3 * multiplier);
  var vertexIndex = 0;

  if (wireframe) {
    return fillArray({ target: normals, source: up, count: pointCount * multiplier });
  }

  groupedVertices.map(function (vertices, polygonIndex) {
    var vertexCount = Polygon.getVertexCount(vertices);

    fillArray({ target: normals, source: up, start: vertexIndex, count: vertexCount });
    vertexIndex += vertexCount * 3;

    var sideNormalsForward = [];
    var sideNormalsBackward = [];

    vertices.forEach(function (polygon) {
      var sideNormals = calculateSideNormals(polygon);
      var firstNormal = sideNormals.slice(0, 3);

      arrayPush(sideNormalsForward, sideNormals);
      arrayPush(sideNormalsForward, firstNormal);

      arrayPush(sideNormalsBackward, firstNormal);
      arrayPush(sideNormalsBackward, sideNormals);
    });

    fillArray({
      target: normals,
      start: vertexIndex,
      count: 2,
      source: sideNormalsForward.concat(sideNormalsBackward)
    });
    vertexIndex += vertexCount * 3 * 4;
  });

  return normals;
}

function calculateSideNormals(vertices) {
  var normals = [];

  var lastVertice = null;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = vertices[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var vertice = _step.value;

      if (lastVertice) {
        // vertex[i-1], vertex[i]
        var n = getNormal(lastVertice, vertice);
        arrayPush(normals, n);
      }
      lastVertice = vertice;
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return normals;
}

function calculateColors(_ref6) {
  var groupedVertices = _ref6.groupedVertices,
      pointCount = _ref6.pointCount,
      getColor = _ref6.getColor,
      _ref6$wireframe = _ref6.wireframe,
      wireframe = _ref6$wireframe === undefined ? false : _ref6$wireframe;

  var multiplier = wireframe ? 2 : 5;
  var colors = new Uint8ClampedArray(pointCount * 4 * multiplier);
  var vertexIndex = 0;

  groupedVertices.forEach(function (complexPolygon, polygonIndex) {
    var color = getColor(polygonIndex);
    color[3] = Number.isFinite(color[3]) ? color[3] : 255;

    var numVertices = Polygon.getVertexCount(complexPolygon);

    fillArray({ target: colors, source: color, start: vertexIndex, count: numVertices * multiplier });
    vertexIndex += color.length * numVertices * multiplier;
  });

  return colors;
}

function calculatePickingColors(_ref7) {
  var groupedVertices = _ref7.groupedVertices,
      pointCount = _ref7.pointCount,
      _ref7$wireframe = _ref7.wireframe,
      wireframe = _ref7$wireframe === undefined ? false : _ref7$wireframe;

  var multiplier = wireframe ? 2 : 5;
  var colors = new Uint8ClampedArray(pointCount * 3 * multiplier);
  var vertexIndex = 0;

  groupedVertices.forEach(function (vertices, polygonIndex) {
    var numVertices = Polygon.getVertexCount(vertices);
    var color = getPickingColor(polygonIndex);

    fillArray({ target: colors, source: color, start: vertexIndex, count: numVertices * multiplier });
    vertexIndex += color.length * numVertices * multiplier;
  });
  return colors;
}

function calculateContourIndices(vertices, offset) {
  var stride = Polygon.getVertexCount(vertices);
  var indices = [];

  vertices.forEach(function (polygon) {
    indices.push(offset);
    var numVertices = polygon.length;

    // polygon top
    // use vertex pairs for GL.LINES => [0, 1, 1, 2, 2, ..., n-1, n-1, 0]
    for (var i = 1; i < numVertices - 1; i++) {
      indices.push(i + offset, i + offset);
    }
    indices.push(offset);

    // polygon sides
    for (var _i = 0; _i < numVertices - 1; _i++) {
      indices.push(_i + offset, _i + stride + offset);
    }

    offset += numVertices;
  });

  return indices;
}

function drawSurfaceRectangle(targetArray, offset, stride) {
  targetArray.push(offset + stride, offset + stride * 3, offset + stride * 2 + 1, offset + stride * 2 + 1, offset + stride * 3, offset + stride * 4 + 1);
}

function calculateSurfaceIndices(vertices, offset) {
  var stride = Polygon.getVertexCount(vertices);

  var holes = null;
  var holeCount = vertices.length - 1;

  if (holeCount) {
    holes = [];
    var vertexIndex = 0;
    for (var i = 0; i < holeCount; i++) {
      vertexIndex += vertices[i].length;
      holes[i] = vertexIndex;
    }
  }

  var indices = earcut(flatten(vertices, 3), holes, 3).map(function (index) {
    return index + offset;
  });

  vertices.forEach(function (polygon) {
    var numVertices = polygon.length;

    // polygon sides
    for (var _i2 = 0; _i2 < numVertices - 1; _i2++) {
      drawSurfaceRectangle(indices, offset + _i2, stride);
    }

    offset += numVertices;
  });

  return indices;
}

// helpers

// get normal vector of line segment
function getNormal(p1, p2) {
  return [p1[1] - p2[1], p2[0] - p1[0], 0];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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