// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME solid-polygon-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec3 normals;\nattribute vec4 colors;\nattribute vec3 pickingColors;\n\nuniform float extruded;\nuniform float elevationScale;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nvoid main(void) {\n  \n  vec4 position_worldspace = vec4(project_position(\n    vec3(positions.x, positions.y, positions.z * elevationScale)),\n    1.0\n  );\n  gl_Position = project_to_clipspace(position_worldspace);\n\n  float lightWeight = 1.0;\n  \n  if (extruded > 0.5) {\n    // Here, the input parameters should be\n    // position_worldspace.xyz / position_worldspace.w.\n    // However, this calculation generates all zeros on\n    // MacBook Pro with Intel Iris Pro GPUs for unclear reasons.\n    // (see https://github.com/uber/deck.gl/issues/559)\n    // Since the w component is always 1.0 in our shaders,\n    // we decided to just provide xyz component of position_worldspace\n    // to the getLightWeight() function\n    lightWeight = getLightWeight(\n      position_worldspace.xyz,\n      project_normal(normals)\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * colors.rgb;\n  vColor = vec4(lightWeightedColor, colors.a * opacity) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(pickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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