var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import ViewState from './view-state';
import WebMercatorViewport, { normalizeViewportProps } from 'viewport-mercator-project';
import assert from 'assert';

// MAPBOX LIMITS
export var MAPBOX_LIMITS = {
  minZoom: 0,
  maxZoom: 20,
  minPitch: 0,
  maxPitch: 60
};

var DEFAULT_STATE = {
  pitch: 0,
  bearing: 0,
  altitude: 1.5
};

/* Utils */
function clamp(value, min, max) {
  return value < min ? min : value > max ? max : value;
}

var MapState = function (_ViewState) {
  _inherits(MapState, _ViewState);

  function MapState() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        width = _ref.width,
        height = _ref.height,
        latitude = _ref.latitude,
        longitude = _ref.longitude,
        zoom = _ref.zoom,
        _ref$bearing = _ref.bearing,
        bearing = _ref$bearing === undefined ? DEFAULT_STATE.bearing : _ref$bearing,
        _ref$pitch = _ref.pitch,
        pitch = _ref$pitch === undefined ? DEFAULT_STATE.pitch : _ref$pitch,
        _ref$altitude = _ref.altitude,
        altitude = _ref$altitude === undefined ? DEFAULT_STATE.altitude : _ref$altitude,
        _ref$maxZoom = _ref.maxZoom,
        maxZoom = _ref$maxZoom === undefined ? MAPBOX_LIMITS.maxZoom : _ref$maxZoom,
        _ref$minZoom = _ref.minZoom,
        minZoom = _ref$minZoom === undefined ? MAPBOX_LIMITS.minZoom : _ref$minZoom,
        _ref$maxPitch = _ref.maxPitch,
        maxPitch = _ref$maxPitch === undefined ? MAPBOX_LIMITS.maxPitch : _ref$maxPitch,
        _ref$minPitch = _ref.minPitch,
        minPitch = _ref$minPitch === undefined ? MAPBOX_LIMITS.minPitch : _ref$minPitch,
        startPanLngLat = _ref.startPanLngLat,
        startZoomLngLat = _ref.startZoomLngLat,
        startBearing = _ref.startBearing,
        startPitch = _ref.startPitch,
        startZoom = _ref.startZoom;

    _classCallCheck(this, MapState);

    assert(Number.isFinite(longitude), '`longitude` must be supplied');
    assert(Number.isFinite(latitude), '`latitude` must be supplied');
    assert(Number.isFinite(zoom), '`zoom` must be supplied');

    var _this = _possibleConstructorReturn(this, (MapState.__proto__ || Object.getPrototypeOf(MapState)).call(this, {
      width: width,
      height: height,
      latitude: latitude,
      longitude: longitude,
      zoom: zoom,
      bearing: bearing,
      pitch: pitch,
      altitude: altitude,
      maxZoom: maxZoom,
      minZoom: minZoom,
      maxPitch: maxPitch,
      minPitch: minPitch
    }));

    _this._interactiveState = {
      startPanLngLat: startPanLngLat,
      startZoomLngLat: startZoomLngLat,
      startBearing: startBearing,
      startPitch: startPitch,
      startZoom: startZoom
    };
    return _this;
  }

  /* Public API */

  _createClass(MapState, [{
    key: 'getViewportProps',
    value: function getViewportProps() {
      return this._viewportProps;
    }
  }, {
    key: 'getInteractiveState',
    value: function getInteractiveState() {
      return this._interactiveState;
    }

    /**
     * Start panning
     * @param {[Number, Number]} pos - position on screen where the pointer grabs
     */

  }, {
    key: 'panStart',
    value: function panStart(_ref2) {
      var pos = _ref2.pos;

      return this._getUpdatedState({
        startPanLngLat: this._unproject(pos)
      });
    }

    /**
     * Pan
     * @param {[Number, Number]} pos - position on screen where the pointer is
     * @param {[Number, Number], optional} startPos - where the pointer grabbed at
     *   the start of the operation. Must be supplied of `panStart()` was not called
     */

  }, {
    key: 'pan',
    value: function pan(_ref3) {
      var pos = _ref3.pos,
          startPos = _ref3.startPos;

      var startPanLngLat = this._interactiveState.startPanLngLat || this._unproject(startPos);

      if (!startPanLngLat) {
        return this;
      }

      var _calculateNewLngLat2 = this._calculateNewLngLat({ startPanLngLat: startPanLngLat, pos: pos }),
          _calculateNewLngLat3 = _slicedToArray(_calculateNewLngLat2, 2),
          longitude = _calculateNewLngLat3[0],
          latitude = _calculateNewLngLat3[1];

      return this._getUpdatedState({
        longitude: longitude,
        latitude: latitude
      });
    }

    /**
     * End panning
     * Must call if `panStart()` was called
     */

  }, {
    key: 'panEnd',
    value: function panEnd() {
      return this._getUpdatedState({
        startPanLngLat: null
      });
    }

    /**
     * Start rotating
     * @param {[Number, Number]} pos - position on screen where the center is
     */

  }, {
    key: 'rotateStart',
    value: function rotateStart(_ref4) {
      var pos = _ref4.pos;

      return this._getUpdatedState({
        startBearing: this._viewportProps.bearing,
        startPitch: this._viewportProps.pitch
      });
    }

    /**
     * Rotate
     * @param {Number} deltaScaleX - a number between [-1, 1] specifying the
     *   change to bearing.
     * @param {Number} deltaScaleY - a number between [-1, 1] specifying the
     *   change to pitch. -1 sets to minPitch and 1 sets to maxPitch.
     */

  }, {
    key: 'rotate',
    value: function rotate(_ref5) {
      var _ref5$deltaScaleX = _ref5.deltaScaleX,
          deltaScaleX = _ref5$deltaScaleX === undefined ? 0 : _ref5$deltaScaleX,
          _ref5$deltaScaleY = _ref5.deltaScaleY,
          deltaScaleY = _ref5$deltaScaleY === undefined ? 0 : _ref5$deltaScaleY;
      var _interactiveState = this._interactiveState,
          startBearing = _interactiveState.startBearing,
          startPitch = _interactiveState.startPitch;


      if (!Number.isFinite(startBearing) || !Number.isFinite(startPitch)) {
        return this;
      }

      var _calculateNewPitchAnd = this._calculateNewPitchAndBearing({
        deltaScaleX: deltaScaleX,
        deltaScaleY: deltaScaleY,
        startBearing: startBearing,
        startPitch: startPitch
      }),
          pitch = _calculateNewPitchAnd.pitch,
          bearing = _calculateNewPitchAnd.bearing;

      return this._getUpdatedState({
        bearing: bearing,
        pitch: pitch
      });
    }

    /**
     * End rotating
     * Must call if `rotateStart()` was called
     */

  }, {
    key: 'rotateEnd',
    value: function rotateEnd() {
      return this._getUpdatedState({
        startBearing: null,
        startPitch: null
      });
    }

    /**
     * Start zooming
     * @param {[Number, Number]} pos - position on screen where the center is
     */

  }, {
    key: 'zoomStart',
    value: function zoomStart(_ref6) {
      var pos = _ref6.pos;

      return this._getUpdatedState({
        startZoomLngLat: this._unproject(pos),
        startZoom: this._viewportProps.zoom
      });
    }

    /**
     * Zoom
     * @param {[Number, Number]} pos - position on screen where the current center is
     * @param {[Number, Number]} startPos - the center position at
     *   the start of the operation. Must be supplied of `zoomStart()` was not called
     * @param {Number} scale - a number between [0, 1] specifying the accumulated
     *   relative scale.
     */

  }, {
    key: 'zoom',
    value: function zoom(_ref7) {
      var pos = _ref7.pos,
          startPos = _ref7.startPos,
          scale = _ref7.scale;

      assert(scale > 0, '`scale` must be a positive number');

      // Make sure we zoom around the current mouse position rather than map center
      var _interactiveState2 = this._interactiveState,
          startZoom = _interactiveState2.startZoom,
          startZoomLngLat = _interactiveState2.startZoomLngLat;


      if (!Number.isFinite(startZoom)) {
        // We have two modes of zoom:
        // scroll zoom that are discrete events (transform from the current zoom level),
        // and pinch zoom that are continuous events (transform from the zoom level when
        // pinch started).
        // If startZoom state is defined, then use the startZoom state;
        // otherwise assume discrete zooming
        startZoom = this._viewportProps.zoom;
        startZoomLngLat = this._unproject(startPos) || this._unproject(pos);
      }

      // take the start lnglat and put it where the mouse is down.
      assert(startZoomLngLat, '`startZoomLngLat` prop is required ' + 'for zoom behavior to calculate where to position the map.');

      var zoom = this._calculateNewZoom({ scale: scale, startZoom: startZoom });

      var zoomedViewport = new WebMercatorViewport(Object.assign({}, this._viewportProps, { zoom: zoom }));

      var _zoomedViewport$getLo = zoomedViewport.getLocationAtPoint({ lngLat: startZoomLngLat, pos: pos }),
          _zoomedViewport$getLo2 = _slicedToArray(_zoomedViewport$getLo, 2),
          longitude = _zoomedViewport$getLo2[0],
          latitude = _zoomedViewport$getLo2[1];

      return this._getUpdatedState({
        zoom: zoom,
        longitude: longitude,
        latitude: latitude
      });
    }

    /**
     * End zooming
     * Must call if `zoomStart()` was called
     */

  }, {
    key: 'zoomEnd',
    value: function zoomEnd() {
      return this._getUpdatedState({
        startZoomLngLat: null,
        startZoom: null
      });
    }
  }, {
    key: 'zoomIn',
    value: function zoomIn() {
      return this._zoomFromCenter(2);
    }
  }, {
    key: 'zoomOut',
    value: function zoomOut() {
      return this._zoomFromCenter(0.5);
    }
  }, {
    key: 'moveLeft',
    value: function moveLeft() {
      return this._panFromCenter([100, 0]);
    }
  }, {
    key: 'moveRight',
    value: function moveRight() {
      return this._panFromCenter([-100, 0]);
    }
  }, {
    key: 'moveUp',
    value: function moveUp() {
      return this._panFromCenter([0, 100]);
    }
  }, {
    key: 'moveDown',
    value: function moveDown() {
      return this._panFromCenter([0, -100]);
    }
  }, {
    key: 'rotateLeft',
    value: function rotateLeft() {
      return this._getUpdatedState({
        bearing: this._viewportProps.bearing - 15
      });
    }
  }, {
    key: 'rotateRight',
    value: function rotateRight() {
      return this._getUpdatedState({
        bearing: this._viewportProps.bearing + 15
      });
    }
  }, {
    key: 'rotateUp',
    value: function rotateUp() {
      return this._getUpdatedState({
        pitch: this._viewportProps.pitch + 10
      });
    }
  }, {
    key: 'rotateDown',
    value: function rotateDown() {
      return this._getUpdatedState({
        pitch: this._viewportProps.pitch - 10
      });
    }

    /* Private methods */

  }, {
    key: '_zoomFromCenter',
    value: function _zoomFromCenter(scale) {
      var _viewportProps = this._viewportProps,
          width = _viewportProps.width,
          height = _viewportProps.height;

      return this.zoom({
        pos: [width / 2, height / 2],
        scale: scale
      });
    }
  }, {
    key: '_panFromCenter',
    value: function _panFromCenter(offset) {
      var _viewportProps2 = this._viewportProps,
          width = _viewportProps2.width,
          height = _viewportProps2.height;

      return this.pan({
        startPos: [width / 2, height / 2],
        pos: [width / 2 + offset[0], height / 2 + offset[1]]
      });
    }
  }, {
    key: '_getUpdatedState',
    value: function _getUpdatedState(newProps) {
      // Update _viewportProps
      return new MapState(Object.assign({}, this._viewportProps, this._interactiveState, newProps));
    }

    // Apply any constraints (mathematical or defined by _viewportProps) to map state

  }, {
    key: '_applyConstraints',
    value: function _applyConstraints(props) {
      // Ensure zoom is within specified range
      var maxZoom = props.maxZoom,
          minZoom = props.minZoom,
          zoom = props.zoom;

      props.zoom = clamp(zoom, minZoom, maxZoom);

      // Ensure pitch is within specified range
      var maxPitch = props.maxPitch,
          minPitch = props.minPitch,
          pitch = props.pitch;

      props.pitch = clamp(pitch, minPitch, maxPitch);

      Object.assign(props, normalizeViewportProps(props));

      return props;
    }
  }, {
    key: '_unproject',
    value: function _unproject(pos) {
      var viewport = new WebMercatorViewport(this._viewportProps);
      return pos && viewport.unproject(pos);
    }

    // Calculate a new lnglat based on pixel dragging position

  }, {
    key: '_calculateNewLngLat',
    value: function _calculateNewLngLat(_ref8) {
      var startPanLngLat = _ref8.startPanLngLat,
          pos = _ref8.pos;

      var viewport = new WebMercatorViewport(this._viewportProps);
      return viewport.getMapCenterByLngLatPosition({ lngLat: startPanLngLat, pos: pos });
    }

    // Calculates new zoom

  }, {
    key: '_calculateNewZoom',
    value: function _calculateNewZoom(_ref9) {
      var scale = _ref9.scale,
          startZoom = _ref9.startZoom;
      var _viewportProps3 = this._viewportProps,
          maxZoom = _viewportProps3.maxZoom,
          minZoom = _viewportProps3.minZoom;

      var zoom = startZoom + Math.log2(scale);
      return clamp(zoom, minZoom, maxZoom);
    }

    // Calculates a new pitch and bearing from a position (coming from an event)

  }, {
    key: '_calculateNewPitchAndBearing',
    value: function _calculateNewPitchAndBearing(_ref10) {
      var deltaScaleX = _ref10.deltaScaleX,
          deltaScaleY = _ref10.deltaScaleY,
          startBearing = _ref10.startBearing,
          startPitch = _ref10.startPitch;

      // clamp deltaScaleY to [-1, 1] so that rotation is constrained between minPitch and maxPitch.
      // deltaScaleX does not need to be clamped as bearing does not have constraints.
      deltaScaleY = clamp(deltaScaleY, -1, 1);

      var _viewportProps4 = this._viewportProps,
          minPitch = _viewportProps4.minPitch,
          maxPitch = _viewportProps4.maxPitch;


      var bearing = startBearing + 180 * deltaScaleX;
      var pitch = startPitch;
      if (deltaScaleY > 0) {
        // Gradually increase pitch
        pitch = startPitch + deltaScaleY * (maxPitch - startPitch);
      } else if (deltaScaleY < 0) {
        // Gradually decrease pitch
        pitch = startPitch - deltaScaleY * (minPitch - startPitch);
      }

      return {
        pitch: pitch,
        bearing: bearing
      };
    }
  }]);

  return MapState;
}(ViewState);

export default MapState;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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