var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Copyright (c) 2015 Uber Technologies, Inc.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import MapState from './map-state';
import LinearInterpolator from '../transitions/linear-interpolator';
import { TRANSITION_EVENTS } from '../lib/transition-manager';
import assert from 'assert';

var NO_TRANSITION_PROPS = {
  transitionDuration: 0
};
var LINEAR_TRANSITION_PROPS = {
  transitionDuration: 300,
  transitionEasing: function transitionEasing(t) {
    return t;
  },
  transitionInterpolator: new LinearInterpolator(),
  transitionInterruption: TRANSITION_EVENTS.BREAK
};

// EVENT HANDLING PARAMETERS
var PITCH_MOUSE_THRESHOLD = 5;
var PITCH_ACCEL = 1.2;
var ZOOM_ACCEL = 0.01;

var EVENT_TYPES = {
  WHEEL: ['wheel'],
  PAN: ['panstart', 'panmove', 'panend'],
  PINCH: ['pinchstart', 'pinchmove', 'pinchend'],
  DOUBLE_TAP: ['doubletap'],
  KEYBOARD: ['keydown']
};

var ViewportControls = function () {
  /**
   * @classdesc
   * A class that handles events and updates mercator style viewport parameters
   */
  function ViewportControls(ViewportState) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, ViewportControls);

    assert(ViewportState);
    this.ViewportState = ViewportState;
    this.viewportState = null;
    this.viewportStateProps = null;
    this.eventManager = null;
    this._events = null;
    this._state = {
      isDragging: false
    };
    this.events = [];

    this.handleEvent = this.handleEvent.bind(this);

    this.setOptions(options);

    if (this.constructor === ViewportControls) {
      Object.seal(this);
    }
  }

  /**
   * Callback for events
   * @param {hammer.Event} event
   */


  _createClass(ViewportControls, [{
    key: 'handleEvent',
    value: function handleEvent(event) {
      var ViewportState = this.ViewportState;

      this.viewportState = new ViewportState(Object.assign({}, this.viewportStateProps, this._state));

      switch (event.type) {
        case 'panstart':
          return this._onPanStart(event);
        case 'panmove':
          return this._onPan(event);
        case 'panend':
          return this._onPanEnd(event);
        case 'pinchstart':
          return this._onPinchStart(event);
        case 'pinchmove':
          return this._onPinch(event);
        case 'pinchend':
          return this._onPinchEnd(event);
        case 'doubletap':
          return this._onDoubleTap(event);
        case 'wheel':
          return this._onWheel(event);
        case 'keydown':
          return this._onKeyDown(event);
        default:
          return false;
      }
    }

    /* Event utils */
    // Event object: http://hammerjs.github.io/api/#event-object

  }, {
    key: 'getCenter',
    value: function getCenter(event) {
      var _event$offsetCenter = event.offsetCenter,
          x = _event$offsetCenter.x,
          y = _event$offsetCenter.y;

      return [x, y];
    }
  }, {
    key: 'isFunctionKeyPressed',
    value: function isFunctionKeyPressed(event) {
      var srcEvent = event.srcEvent;

      return Boolean(srcEvent.metaKey || srcEvent.altKey || srcEvent.ctrlKey || srcEvent.shiftKey);
    }
  }, {
    key: 'isDragging',
    value: function isDragging() {
      return this._state.isDragging;
    }

    /**
     * Extract interactivity options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      var onViewportChange = options.onViewportChange,
          _options$onStateChang = options.onStateChange,
          onStateChange = _options$onStateChang === undefined ? this.onStateChange : _options$onStateChang,
          _options$eventManager = options.eventManager,
          eventManager = _options$eventManager === undefined ? this.eventManager : _options$eventManager,
          _options$scrollZoom = options.scrollZoom,
          scrollZoom = _options$scrollZoom === undefined ? true : _options$scrollZoom,
          _options$dragPan = options.dragPan,
          dragPan = _options$dragPan === undefined ? true : _options$dragPan,
          _options$dragRotate = options.dragRotate,
          dragRotate = _options$dragRotate === undefined ? true : _options$dragRotate,
          _options$doubleClickZ = options.doubleClickZoom,
          doubleClickZoom = _options$doubleClickZ === undefined ? true : _options$doubleClickZ,
          _options$touchZoom = options.touchZoom,
          touchZoom = _options$touchZoom === undefined ? true : _options$touchZoom,
          _options$touchRotate = options.touchRotate,
          touchRotate = _options$touchRotate === undefined ? false : _options$touchRotate,
          _options$keyboard = options.keyboard,
          keyboard = _options$keyboard === undefined ? true : _options$keyboard;


      this.onViewportChange = onViewportChange;
      this.onStateChange = onStateChange;
      this.viewportStateProps = options;

      if (this.eventManager !== eventManager) {
        // EventManager has changed
        this.eventManager = eventManager;
        this._events = {};
        this.toggleEvents(this.events, true);
      }

      // Register/unregister events
      var isInteractive = Boolean(this.onViewportChange);
      this.toggleEvents(EVENT_TYPES.WHEEL, isInteractive && scrollZoom);
      this.toggleEvents(EVENT_TYPES.PAN, isInteractive && (dragPan || dragRotate));
      this.toggleEvents(EVENT_TYPES.PINCH, isInteractive && (touchZoom || touchRotate));
      this.toggleEvents(EVENT_TYPES.DOUBLE_TAP, isInteractive && doubleClickZoom);
      this.toggleEvents(EVENT_TYPES.KEYBOARD, isInteractive && keyboard);

      // Interaction toggles
      this.scrollZoom = scrollZoom;
      this.dragPan = dragPan;
      this.dragRotate = dragRotate;
      this.doubleClickZoom = doubleClickZoom;
      this.touchZoom = touchZoom;
      this.touchRotate = touchRotate;
      this.keyboard = keyboard;
    }
  }, {
    key: 'toggleEvents',
    value: function toggleEvents(eventNames, enabled) {
      var _this = this;

      if (this.eventManager) {
        eventNames.forEach(function (eventName) {
          if (_this._events[eventName] !== enabled) {
            _this._events[eventName] = enabled;
            if (enabled) {
              _this.eventManager.on(eventName, _this.handleEvent);
            } else {
              _this.eventManager.off(eventName, _this.handleEvent);
            }
          }
        });
      }
    }

    // Private Methods

  }, {
    key: 'setState',
    value: function setState(newState) {
      Object.assign(this._state, newState);
      if (this.onStateChange) {
        this.onStateChange(this._state);
      }
    }

    /* Callback util */
    // formats map state and invokes callback function

  }, {
    key: 'updateViewport',
    value: function updateViewport(newViewportState) {
      var extraProps = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var extraState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      var oldViewport = this.viewportState.getViewportProps();
      var newViewport = Object.assign({}, newViewportState.getViewportProps(), extraProps);

      if (this.onViewportChange && Object.keys(newViewport).some(function (key) {
        return oldViewport[key] !== newViewport[key];
      })) {
        // Viewport has changed
        var viewport = this.viewportState.getViewport ? this.viewportState.getViewport() : null;
        this.onViewportChange(newViewport, viewport);
      }

      this.setState(Object.assign({}, newViewportState.getInteractiveState(), extraState));
    }

    /* Event handlers */
    // Default handler for the `panstart` event.

  }, {
    key: '_onPanStart',
    value: function _onPanStart(event) {
      var pos = this.getCenter(event);
      var newViewportState = this.viewportState.panStart({ pos: pos }).rotateStart({ pos: pos });
      return this.updateViewport(newViewportState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `panmove` event.

  }, {
    key: '_onPan',
    value: function _onPan(event) {
      return this.isFunctionKeyPressed(event) || event.rightButton ? this._onPanRotate(event) : this._onPanMove(event);
    }

    // Default handler for the `panend` event.

  }, {
    key: '_onPanEnd',
    value: function _onPanEnd(event) {
      var newViewportState = this.viewportState.panEnd().rotateEnd();
      return this.updateViewport(newViewportState, null, { isDragging: false });
    }

    // Default handler for panning to move.
    // Called by `_onPan` when panning without function key pressed.

  }, {
    key: '_onPanMove',
    value: function _onPanMove(event) {
      if (!this.dragPan) {
        return false;
      }
      var pos = this.getCenter(event);
      var newViewportState = this.viewportState.pan({ pos: pos });
      return this.updateViewport(newViewportState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for panning to rotate.
    // Called by `_onPan` when panning with function key pressed.

  }, {
    key: '_onPanRotate',
    value: function _onPanRotate(event) {
      if (!this.dragRotate) {
        return false;
      }

      return this.viewportState instanceof MapState ? this._onPanRotateMap(event) : this._onPanRotateStandard(event);
    }

    // Normal pan to rotate

  }, {
    key: '_onPanRotateStandard',
    value: function _onPanRotateStandard(event) {
      var deltaX = event.deltaX,
          deltaY = event.deltaY;

      var _viewportState$getVie = this.viewportState.getViewportProps(),
          width = _viewportState$getVie.width,
          height = _viewportState$getVie.height;

      var deltaScaleX = deltaX / width;
      var deltaScaleY = deltaY / height;

      var newViewportState = this.viewportState.rotate({ deltaScaleX: deltaScaleX, deltaScaleY: deltaScaleY });
      return this.updateViewport(newViewportState, NO_TRANSITION_PROPS, { isDragging: true });
    }
  }, {
    key: '_onPanRotateMap',
    value: function _onPanRotateMap(event) {
      var deltaX = event.deltaX,
          deltaY = event.deltaY;

      var _getCenter = this.getCenter(event),
          _getCenter2 = _slicedToArray(_getCenter, 2),
          centerY = _getCenter2[1];

      var startY = centerY - deltaY;

      var _viewportState$getVie2 = this.viewportState.getViewportProps(),
          width = _viewportState$getVie2.width,
          height = _viewportState$getVie2.height;

      var deltaScaleX = deltaX / width;
      var deltaScaleY = 0;

      if (deltaY > 0) {
        if (Math.abs(height - startY) > PITCH_MOUSE_THRESHOLD) {
          // Move from 0 to -1 as we drag upwards
          deltaScaleY = deltaY / (startY - height) * PITCH_ACCEL;
        }
      } else if (deltaY < 0) {
        if (startY > PITCH_MOUSE_THRESHOLD) {
          // Move from 0 to 1 as we drag upwards
          deltaScaleY = 1 - centerY / startY;
        }
      }
      deltaScaleY = Math.min(1, Math.max(-1, deltaScaleY));

      var newViewportState = this.viewportState.rotate({ deltaScaleX: deltaScaleX, deltaScaleY: deltaScaleY });
      return this.updateViewport(newViewportState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `wheel` event.

  }, {
    key: '_onWheel',
    value: function _onWheel(event) {
      if (!this.scrollZoom) {
        return false;
      }

      var pos = this.getCenter(event);
      var delta = event.delta;

      // Map wheel delta to relative scale

      var scale = 2 / (1 + Math.exp(-Math.abs(delta * ZOOM_ACCEL)));
      if (delta < 0 && scale !== 0) {
        scale = 1 / scale;
      }

      var newViewportState = this.viewportState.zoom({ pos: pos, scale: scale });
      return this.updateViewport(newViewportState, NO_TRANSITION_PROPS);
    }

    // Default handler for the `pinchstart` event.

  }, {
    key: '_onPinchStart',
    value: function _onPinchStart(event) {
      var pos = this.getCenter(event);
      var newViewportState = this.viewportState.zoomStart({ pos: pos }).rotateStart({ pos: pos });
      // hack - hammer's `rotation` field doesn't seem to produce the correct angle
      this._state.startPinchRotation = event.rotation;
      return this.updateViewport(newViewportState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `pinch` event.

  }, {
    key: '_onPinch',
    value: function _onPinch(event) {
      if (!this.touchZoom && !this.touchRotate) {
        return false;
      }

      var newViewportState = this.viewportState;
      if (this.touchZoom) {
        var scale = event.scale;

        var pos = this.getCenter(event);
        newViewportState = newViewportState.zoom({ pos: pos, scale: scale });
      }
      if (this.touchRotate) {
        var rotation = event.rotation;
        var startPinchRotation = this._state.startPinchRotation;

        newViewportState = newViewportState.rotate({
          deltaScaleX: -(rotation - startPinchRotation) / 180
        });
      }

      return this.updateViewport(newViewportState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `pinchend` event.

  }, {
    key: '_onPinchEnd',
    value: function _onPinchEnd(event) {
      var newViewportState = this.viewportState.zoomEnd().rotateEnd();
      this._state.startPinchRotation = 0;
      return this.updateViewport(newViewportState, null, { isDragging: false });
    }

    // Default handler for the `doubletap` event.

  }, {
    key: '_onDoubleTap',
    value: function _onDoubleTap(event) {
      if (!this.doubleClickZoom) {
        return false;
      }
      var pos = this.getCenter(event);
      var isZoomOut = this.isFunctionKeyPressed(event);

      var newViewportState = this.viewportState.zoom({ pos: pos, scale: isZoomOut ? 0.5 : 2 });
      return this.updateViewport(newViewportState, LINEAR_TRANSITION_PROPS);
    }

    /* eslint-disable complexity */
    // Default handler for the `keydown` event

  }, {
    key: '_onKeyDown',
    value: function _onKeyDown(event) {
      if (!this.keyboard) {
        return false;
      }
      var funcKey = this.isFunctionKeyPressed(event);
      var viewportState = this.viewportState;

      var newViewportState = void 0;

      switch (event.srcEvent.keyCode) {
        case 189:
          // -
          newViewportState = funcKey ? viewportState.zoomOut().zoomOut() : viewportState.zoomOut();
          break;
        case 187:
          // +
          newViewportState = funcKey ? viewportState.zoomIn().zoomIn() : viewportState.zoomIn();
          break;
        case 37:
          // left
          newViewportState = funcKey ? viewportState.rotateLeft() : viewportState.moveLeft();
          break;
        case 39:
          // right
          newViewportState = funcKey ? viewportState.rotateRight() : viewportState.moveRight();
          break;
        case 38:
          // up
          newViewportState = funcKey ? viewportState.rotateUp() : viewportState.moveUp();
          break;
        case 40:
          // down
          newViewportState = funcKey ? viewportState.rotateDown() : viewportState.moveDown();
          break;
        default:
          return false;
      }
      return this.updateViewport(newViewportState, LINEAR_TRANSITION_PROPS);
    }
    /* eslint-enable complexity */

  }]);

  return ViewportControls;
}();

export default ViewportControls;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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