// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
export function compareArrays(array1, array2) {
  var length = Math.min(array1.length, array2.length);
  for (var i = 0; i < length; ++i) {
    if (array1[i] !== array2[i]) {
      return "Arrays are different in element " + i + ": " + array1[i] + " vs " + array2[i];
    }
  }

  if (array1.length !== array2.length) {
    return "Arrays have different length " + array1.length + " vs " + array2.length;
  }

  return null;
}

export function checkArray(array) {
  for (var i = 0; i < array.length; ++i) {
    if (!Number.isFinite(array[i])) {
      throw new Error("Array has invalid element " + i + ": " + array[i]);
    }
  }
  return null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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