var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { GL, Model, Geometry } from 'luma.gl';

var ATTRIBUTE_MAPPING = {
  1: 'float',
  2: 'vec2',
  3: 'vec3',
  4: 'vec4'
};

function getShaders(transitions) {
  // Build shaders
  var varyings = [];
  var attributeDeclarations = [];
  var uniformsDeclarations = [];
  var varyingDeclarations = [];
  var calculations = [];

  for (var attributeName in transitions) {
    var transition = transitions[attributeName];
    var attributeType = ATTRIBUTE_MAPPING[transition.attribute.size];

    if (attributeType) {
      transition.bufferIndex = varyings.length;
      varyings.push(attributeName);

      attributeDeclarations.push('attribute ' + attributeType + ' ' + attributeName + 'From;');
      attributeDeclarations.push('attribute ' + attributeType + ' ' + attributeName + 'To;');
      uniformsDeclarations.push('uniform float ' + attributeName + 'Time;');
      varyingDeclarations.push('varying ' + attributeType + ' ' + attributeName + ';');
      calculations.push(attributeName + ' = mix(' + attributeName + 'From, ' + attributeName + 'To,\n        ' + attributeName + 'Time);');
    }
  }

  var vs = '\n#define SHADER_NAME feedback-vertex-shader\n' + attributeDeclarations.join('\n') + '\n' + uniformsDeclarations.join('\n') + '\n' + varyingDeclarations.join('\n') + '\n\nvoid main(void) {\n  ' + calculations.join('\n') + '\n  gl_Position = vec4(0.0);\n}\n';

  var fs = '#define SHADER_NAME feedback-fragment-shader\n\n#ifdef GL_ES\nprecision highp float;\n#endif\n\n' + varyingDeclarations.join('\n') + '\n\nvoid main(void) {\n  gl_FragColor = vec4(0.0);\n}\n';
  return { vs: vs, fs: fs, varyings: varyings };
}

var AttributeTransitionModel = function (_Model) {
  _inherits(AttributeTransitionModel, _Model);

  function AttributeTransitionModel(gl, _ref) {
    var id = _ref.id,
        transitions = _ref.transitions;

    _classCallCheck(this, AttributeTransitionModel);

    var _this = _possibleConstructorReturn(this, (AttributeTransitionModel.__proto__ || Object.getPrototypeOf(AttributeTransitionModel)).call(this, gl, Object.assign({
      id: id,
      geometry: new Geometry({
        id: id,
        drawMode: GL.POINTS
      }),
      vertexCount: 0,
      isIndexed: true
    }, getShaders(transitions))));

    _this.setTransitions(transitions);
    return _this;
  }

  // Update attributes and vertex count


  _createClass(AttributeTransitionModel, [{
    key: 'setTransitions',
    value: function setTransitions(transitions) {
      for (var attributeName in transitions) {
        var _setAttributes;

        var _transitions$attribut = transitions[attributeName],
            fromState = _transitions$attribut.fromState,
            toState = _transitions$attribut.toState,
            attribute = _transitions$attribut.attribute;


        this.setAttributes((_setAttributes = {}, _defineProperty(_setAttributes, attributeName + 'From', fromState), _defineProperty(_setAttributes, attributeName + 'To', toState), _setAttributes));

        this.setVertexCount(attribute.value.length / attribute.size);
      }
    }
  }]);

  return AttributeTransitionModel;
}(Model);

export default AttributeTransitionModel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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