// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Note: The numeric values here are matched by shader code in the
// "project" and "project64" shader modules. Both places need to be
// updated.

// TODO: Maybe "POSITIONS" would be a better name?
export var COORDINATE_SYSTEM = {
  // Positions are interpreted as [lng, lat, elevation]
  // lng lat are degrees, elevation is meters. distances as meters.
  LNGLAT: 1.0,

  // Positions are interpreted as meter offsets, distances as meters
  // Planned to deprecate in later versions
  METER_OFFSETS: 2.0,
  METERS: 2.0,

  // Positions are interpreted as lng lat offsets: [deltaLng, deltaLat, elevation]
  // deltaLng, deltaLat are delta degrees, elevation is meters.
  // distances as meters.
  LNGLAT_OFFSETS: 3.0,

  // Positions and distances are not transformed: [x, y, z] in unit coordinates
  IDENTITY: 0.0
};

export var LIFECYCLE = {
  NO_STATE: 'Awaiting state',
  MATCHED: 'Matched. State transferred from previous layer',
  INITIALIZED: 'Intialized',
  AWAITING_GC: 'Discarded. Awaiting garbage collection',
  AWAITING_FINALIZATION: 'No longer matched. Awaiting garbage collection',
  FINALIZED: 'Finalized! Awaiting garbage collection'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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