var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import PropTypes from 'prop-types';
import OrbitViewport from '../viewports/orbit-viewport';
import OrbitState from '../controllers/orbit-state';
import ViewportControls from '../controllers/viewport-controls';
import { EventManager } from 'mjolnir.js';

var PREFIX = '-webkit-';

var CURSOR = {
  GRABBING: PREFIX + 'grabbing',
  GRAB: PREFIX + 'grab',
  POINTER: 'pointer'
};

var propTypes = {
  /* Viewport properties */
  lookAt: PropTypes.arrayOf(PropTypes.number), // target position
  distance: PropTypes.number, // distance from camera to the target
  rotationX: PropTypes.number, // rotation around X axis
  rotationY: PropTypes.number, // rotation around Y axis
  translationX: PropTypes.number, // translation x in screen space
  translationY: PropTypes.number, // translation y in screen space
  zoom: PropTypes.number, // scale in screen space
  minZoom: PropTypes.number,
  maxZoom: PropTypes.number,
  fov: PropTypes.number, // field of view
  near: PropTypes.number,
  far: PropTypes.number,
  width: PropTypes.number.isRequired, // viewport width in pixels
  height: PropTypes.number.isRequired, // viewport height in pixels

  /* Model properties */
  bounds: PropTypes.object, // bounds in the shape of {minX, minY, minZ, maxX, maxY, maxZ}

  /* Callbacks */
  onViewportChange: PropTypes.func.isRequired,

  /** Accessor that returns a cursor style to show interactive state */
  getCursor: PropTypes.func,

  /* Controls */
  orbitControls: PropTypes.object
};

var getDefaultCursor = function getDefaultCursor(_ref) {
  var isDragging = _ref.isDragging;
  return isDragging ? CURSOR.GRABBING : CURSOR.GRAB;
};

var defaultProps = {
  lookAt: [0, 0, 0],
  rotationX: 0,
  rotationY: 0,
  translationX: 0,
  translationY: 0,
  distance: 10,
  zoom: 1,
  minZoom: 0,
  maxZoom: Infinity,
  fov: 50,
  near: 1,
  far: 1000,
  getCursor: getDefaultCursor
};

/*
 * Maps mouse interaction to a deck.gl Viewport
 */

var OrbitControllerJS = function () {
  _createClass(OrbitControllerJS, null, [{
    key: 'getViewport',

    // Returns a deck.gl Viewport instance, to be used with the DeckGL component
    value: function getViewport(viewport) {
      return new OrbitViewport(viewport);
    }
  }]);

  function OrbitControllerJS(props) {
    _classCallCheck(this, OrbitControllerJS);

    props = Object.assign({}, defaultProps, props);

    this.props = props;

    this.state = {
      // Whether the cursor is down
      isDragging: false
    };

    this.canvas = props.canvas;

    var eventManager = new EventManager(this.canvas);

    this._eventManager = eventManager;

    this._controls = props.orbitControls || new ViewportControls(OrbitState);
    this._controls.setOptions(Object.assign({}, this.props, {
      onStateChange: this._onInteractiveStateChange.bind(this),
      eventManager: eventManager
    }));
  }

  _createClass(OrbitControllerJS, [{
    key: 'setProps',
    value: function setProps(props) {
      props = Object.assign({}, this.props, props);
      this.props = props;

      this._controls.setOptions(props);
    }
  }, {
    key: 'finalize',
    value: function finalize() {
      this._eventManager.destroy();
    }
  }, {
    key: '_onInteractiveStateChange',
    value: function _onInteractiveStateChange(_ref2) {
      var _ref2$isDragging = _ref2.isDragging,
          isDragging = _ref2$isDragging === undefined ? false : _ref2$isDragging;

      if (isDragging !== this.state.isDragging) {
        this.state.isDragging = isDragging;
        var getCursor = this.props.getCursor;

        this.canvas.style.cursor = getCursor(this.state);
      }
    }
  }]);

  return OrbitControllerJS;
}();

export default OrbitControllerJS;


OrbitControllerJS.displayName = 'OrbitController';
OrbitControllerJS.propTypes = propTypes;
OrbitControllerJS.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb3JlL3B1cmUtanMvb3JiaXQtY29udHJvbGxlci1qcy5qcyJdLCJuYW1lcyI6WyJQcm9wVHlwZXMiLCJPcmJpdFZpZXdwb3J0IiwiT3JiaXRTdGF0ZSIsIlZpZXdwb3J0Q29udHJvbHMiLCJFdmVudE1hbmFnZXIiLCJQUkVGSVgiLCJDVVJTT1IiLCJHUkFCQklORyIsIkdSQUIiLCJQT0lOVEVSIiwicHJvcFR5cGVzIiwibG9va0F0IiwiYXJyYXlPZiIsIm51bWJlciIsImRpc3RhbmNlIiwicm90YXRpb25YIiwicm90YXRpb25ZIiwidHJhbnNsYXRpb25YIiwidHJhbnNsYXRpb25ZIiwiem9vbSIsIm1pblpvb20iLCJtYXhab29tIiwiZm92IiwibmVhciIsImZhciIsIndpZHRoIiwiaXNSZXF1aXJlZCIsImhlaWdodCIsImJvdW5kcyIsIm9iamVjdCIsIm9uVmlld3BvcnRDaGFuZ2UiLCJmdW5jIiwiZ2V0Q3Vyc29yIiwib3JiaXRDb250cm9scyIsImdldERlZmF1bHRDdXJzb3IiLCJpc0RyYWdnaW5nIiwiZGVmYXVsdFByb3BzIiwiSW5maW5pdHkiLCJPcmJpdENvbnRyb2xsZXJKUyIsInZpZXdwb3J0IiwicHJvcHMiLCJPYmplY3QiLCJhc3NpZ24iLCJzdGF0ZSIsImNhbnZhcyIsImV2ZW50TWFuYWdlciIsIl9ldmVudE1hbmFnZXIiLCJfY29udHJvbHMiLCJzZXRPcHRpb25zIiwib25TdGF0ZUNoYW5nZSIsIl9vbkludGVyYWN0aXZlU3RhdGVDaGFuZ2UiLCJiaW5kIiwiZGVzdHJveSIsInN0eWxlIiwiY3Vyc29yIiwiZGlzcGxheU5hbWUiXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPQSxTQUFQLE1BQXNCLFlBQXRCO0FBQ0EsT0FBT0MsYUFBUCxNQUEwQiw2QkFBMUI7QUFDQSxPQUFPQyxVQUFQLE1BQXVCLDRCQUF2QjtBQUNBLE9BQU9DLGdCQUFQLE1BQTZCLGtDQUE3QjtBQUNBLFNBQVFDLFlBQVIsUUFBMkIsWUFBM0I7O0FBRUEsSUFBTUMsU0FBUyxVQUFmOztBQUVBLElBQU1DLFNBQVM7QUFDYkMsWUFBYUYsTUFBYixhQURhO0FBRWJHLFFBQVNILE1BQVQsU0FGYTtBQUdiSSxXQUFTO0FBSEksQ0FBZjs7QUFNQSxJQUFNQyxZQUFZO0FBQ2hCO0FBQ0FDLFVBQVFYLFVBQVVZLE9BQVYsQ0FBa0JaLFVBQVVhLE1BQTVCLENBRlEsRUFFNkI7QUFDN0NDLFlBQVVkLFVBQVVhLE1BSEosRUFHWTtBQUM1QkUsYUFBV2YsVUFBVWEsTUFKTCxFQUlhO0FBQzdCRyxhQUFXaEIsVUFBVWEsTUFMTCxFQUthO0FBQzdCSSxnQkFBY2pCLFVBQVVhLE1BTlIsRUFNZ0I7QUFDaENLLGdCQUFjbEIsVUFBVWEsTUFQUixFQU9nQjtBQUNoQ00sUUFBTW5CLFVBQVVhLE1BUkEsRUFRUTtBQUN4Qk8sV0FBU3BCLFVBQVVhLE1BVEg7QUFVaEJRLFdBQVNyQixVQUFVYSxNQVZIO0FBV2hCUyxPQUFLdEIsVUFBVWEsTUFYQyxFQVdPO0FBQ3ZCVSxRQUFNdkIsVUFBVWEsTUFaQTtBQWFoQlcsT0FBS3hCLFVBQVVhLE1BYkM7QUFjaEJZLFNBQU96QixVQUFVYSxNQUFWLENBQWlCYSxVQWRSLEVBY29CO0FBQ3BDQyxVQUFRM0IsVUFBVWEsTUFBVixDQUFpQmEsVUFmVCxFQWVxQjs7QUFFckM7QUFDQUUsVUFBUTVCLFVBQVU2QixNQWxCRixFQWtCVTs7QUFFMUI7QUFDQUMsb0JBQWtCOUIsVUFBVStCLElBQVYsQ0FBZUwsVUFyQmpCOztBQXVCaEI7QUFDQU0sYUFBV2hDLFVBQVUrQixJQXhCTDs7QUEwQmhCO0FBQ0FFLGlCQUFlakMsVUFBVTZCO0FBM0JULENBQWxCOztBQThCQSxJQUFNSyxtQkFBbUIsU0FBbkJBLGdCQUFtQjtBQUFBLE1BQUVDLFVBQUYsUUFBRUEsVUFBRjtBQUFBLFNBQW1CQSxhQUFhN0IsT0FBT0MsUUFBcEIsR0FBK0JELE9BQU9FLElBQXpEO0FBQUEsQ0FBekI7O0FBRUEsSUFBTTRCLGVBQWU7QUFDbkJ6QixVQUFRLENBQUMsQ0FBRCxFQUFJLENBQUosRUFBTyxDQUFQLENBRFc7QUFFbkJJLGFBQVcsQ0FGUTtBQUduQkMsYUFBVyxDQUhRO0FBSW5CQyxnQkFBYyxDQUpLO0FBS25CQyxnQkFBYyxDQUxLO0FBTW5CSixZQUFVLEVBTlM7QUFPbkJLLFFBQU0sQ0FQYTtBQVFuQkMsV0FBUyxDQVJVO0FBU25CQyxXQUFTZ0IsUUFUVTtBQVVuQmYsT0FBSyxFQVZjO0FBV25CQyxRQUFNLENBWGE7QUFZbkJDLE9BQUssSUFaYztBQWFuQlEsYUFBV0U7QUFiUSxDQUFyQjs7QUFnQkE7Ozs7SUFHcUJJLGlCOzs7O0FBQ25CO2dDQUNtQkMsUSxFQUFVO0FBQzNCLGFBQU8sSUFBSXRDLGFBQUosQ0FBa0JzQyxRQUFsQixDQUFQO0FBQ0Q7OztBQUVELDZCQUFZQyxLQUFaLEVBQW1CO0FBQUE7O0FBQ2pCQSxZQUFRQyxPQUFPQyxNQUFQLENBQWMsRUFBZCxFQUFrQk4sWUFBbEIsRUFBZ0NJLEtBQWhDLENBQVI7O0FBRUEsU0FBS0EsS0FBTCxHQUFhQSxLQUFiOztBQUVBLFNBQUtHLEtBQUwsR0FBYTtBQUNYO0FBQ0FSLGtCQUFZO0FBRkQsS0FBYjs7QUFLQSxTQUFLUyxNQUFMLEdBQWNKLE1BQU1JLE1BQXBCOztBQUVBLFFBQU1DLGVBQWUsSUFBSXpDLFlBQUosQ0FBaUIsS0FBS3dDLE1BQXRCLENBQXJCOztBQUVBLFNBQUtFLGFBQUwsR0FBcUJELFlBQXJCOztBQUVBLFNBQUtFLFNBQUwsR0FBaUJQLE1BQU1QLGFBQU4sSUFBdUIsSUFBSTlCLGdCQUFKLENBQXFCRCxVQUFyQixDQUF4QztBQUNBLFNBQUs2QyxTQUFMLENBQWVDLFVBQWYsQ0FDRVAsT0FBT0MsTUFBUCxDQUFjLEVBQWQsRUFBa0IsS0FBS0YsS0FBdkIsRUFBOEI7QUFDNUJTLHFCQUFlLEtBQUtDLHlCQUFMLENBQStCQyxJQUEvQixDQUFvQyxJQUFwQyxDQURhO0FBRTVCTjtBQUY0QixLQUE5QixDQURGO0FBTUQ7Ozs7NkJBRVFMLEssRUFBTztBQUNkQSxjQUFRQyxPQUFPQyxNQUFQLENBQWMsRUFBZCxFQUFrQixLQUFLRixLQUF2QixFQUE4QkEsS0FBOUIsQ0FBUjtBQUNBLFdBQUtBLEtBQUwsR0FBYUEsS0FBYjs7QUFFQSxXQUFLTyxTQUFMLENBQWVDLFVBQWYsQ0FBMEJSLEtBQTFCO0FBQ0Q7OzsrQkFFVTtBQUNULFdBQUtNLGFBQUwsQ0FBbUJNLE9BQW5CO0FBQ0Q7OztxREFFK0M7QUFBQSxtQ0FBckJqQixVQUFxQjtBQUFBLFVBQXJCQSxVQUFxQixvQ0FBUixLQUFROztBQUM5QyxVQUFJQSxlQUFlLEtBQUtRLEtBQUwsQ0FBV1IsVUFBOUIsRUFBMEM7QUFDeEMsYUFBS1EsS0FBTCxDQUFXUixVQUFYLEdBQXdCQSxVQUF4QjtBQUR3QyxZQUVqQ0gsU0FGaUMsR0FFcEIsS0FBS1EsS0FGZSxDQUVqQ1IsU0FGaUM7O0FBR3hDLGFBQUtZLE1BQUwsQ0FBWVMsS0FBWixDQUFrQkMsTUFBbEIsR0FBMkJ0QixVQUFVLEtBQUtXLEtBQWYsQ0FBM0I7QUFDRDtBQUNGOzs7Ozs7ZUFoRGtCTCxpQjs7O0FBbURyQkEsa0JBQWtCaUIsV0FBbEIsR0FBZ0MsaUJBQWhDO0FBQ0FqQixrQkFBa0I1QixTQUFsQixHQUE4QkEsU0FBOUI7QUFDQTRCLGtCQUFrQkYsWUFBbEIsR0FBaUNBLFlBQWpDIiwiZmlsZSI6Im9yYml0LWNvbnRyb2xsZXItanMuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IE9yYml0Vmlld3BvcnQgZnJvbSAnLi4vdmlld3BvcnRzL29yYml0LXZpZXdwb3J0JztcbmltcG9ydCBPcmJpdFN0YXRlIGZyb20gJy4uL2NvbnRyb2xsZXJzL29yYml0LXN0YXRlJztcbmltcG9ydCBWaWV3cG9ydENvbnRyb2xzIGZyb20gJy4uL2NvbnRyb2xsZXJzL3ZpZXdwb3J0LWNvbnRyb2xzJztcbmltcG9ydCB7RXZlbnRNYW5hZ2VyfSBmcm9tICdtam9sbmlyLmpzJztcblxuY29uc3QgUFJFRklYID0gJy13ZWJraXQtJztcblxuY29uc3QgQ1VSU09SID0ge1xuICBHUkFCQklORzogYCR7UFJFRklYfWdyYWJiaW5nYCxcbiAgR1JBQjogYCR7UFJFRklYfWdyYWJgLFxuICBQT0lOVEVSOiAncG9pbnRlcidcbn07XG5cbmNvbnN0IHByb3BUeXBlcyA9IHtcbiAgLyogVmlld3BvcnQgcHJvcGVydGllcyAqL1xuICBsb29rQXQ6IFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5udW1iZXIpLCAvLyB0YXJnZXQgcG9zaXRpb25cbiAgZGlzdGFuY2U6IFByb3BUeXBlcy5udW1iZXIsIC8vIGRpc3RhbmNlIGZyb20gY2FtZXJhIHRvIHRoZSB0YXJnZXRcbiAgcm90YXRpb25YOiBQcm9wVHlwZXMubnVtYmVyLCAvLyByb3RhdGlvbiBhcm91bmQgWCBheGlzXG4gIHJvdGF0aW9uWTogUHJvcFR5cGVzLm51bWJlciwgLy8gcm90YXRpb24gYXJvdW5kIFkgYXhpc1xuICB0cmFuc2xhdGlvblg6IFByb3BUeXBlcy5udW1iZXIsIC8vIHRyYW5zbGF0aW9uIHggaW4gc2NyZWVuIHNwYWNlXG4gIHRyYW5zbGF0aW9uWTogUHJvcFR5cGVzLm51bWJlciwgLy8gdHJhbnNsYXRpb24geSBpbiBzY3JlZW4gc3BhY2VcbiAgem9vbTogUHJvcFR5cGVzLm51bWJlciwgLy8gc2NhbGUgaW4gc2NyZWVuIHNwYWNlXG4gIG1pblpvb206IFByb3BUeXBlcy5udW1iZXIsXG4gIG1heFpvb206IFByb3BUeXBlcy5udW1iZXIsXG4gIGZvdjogUHJvcFR5cGVzLm51bWJlciwgLy8gZmllbGQgb2Ygdmlld1xuICBuZWFyOiBQcm9wVHlwZXMubnVtYmVyLFxuICBmYXI6IFByb3BUeXBlcy5udW1iZXIsXG4gIHdpZHRoOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsIC8vIHZpZXdwb3J0IHdpZHRoIGluIHBpeGVsc1xuICBoZWlnaHQ6IFByb3BUeXBlcy5udW1iZXIuaXNSZXF1aXJlZCwgLy8gdmlld3BvcnQgaGVpZ2h0IGluIHBpeGVsc1xuXG4gIC8qIE1vZGVsIHByb3BlcnRpZXMgKi9cbiAgYm91bmRzOiBQcm9wVHlwZXMub2JqZWN0LCAvLyBib3VuZHMgaW4gdGhlIHNoYXBlIG9mIHttaW5YLCBtaW5ZLCBtaW5aLCBtYXhYLCBtYXhZLCBtYXhafVxuXG4gIC8qIENhbGxiYWNrcyAqL1xuICBvblZpZXdwb3J0Q2hhbmdlOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuXG4gIC8qKiBBY2Nlc3NvciB0aGF0IHJldHVybnMgYSBjdXJzb3Igc3R5bGUgdG8gc2hvdyBpbnRlcmFjdGl2ZSBzdGF0ZSAqL1xuICBnZXRDdXJzb3I6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8qIENvbnRyb2xzICovXG4gIG9yYml0Q29udHJvbHM6IFByb3BUeXBlcy5vYmplY3Rcbn07XG5cbmNvbnN0IGdldERlZmF1bHRDdXJzb3IgPSAoe2lzRHJhZ2dpbmd9KSA9PiAoaXNEcmFnZ2luZyA/IENVUlNPUi5HUkFCQklORyA6IENVUlNPUi5HUkFCKTtcblxuY29uc3QgZGVmYXVsdFByb3BzID0ge1xuICBsb29rQXQ6IFswLCAwLCAwXSxcbiAgcm90YXRpb25YOiAwLFxuICByb3RhdGlvblk6IDAsXG4gIHRyYW5zbGF0aW9uWDogMCxcbiAgdHJhbnNsYXRpb25ZOiAwLFxuICBkaXN0YW5jZTogMTAsXG4gIHpvb206IDEsXG4gIG1pblpvb206IDAsXG4gIG1heFpvb206IEluZmluaXR5LFxuICBmb3Y6IDUwLFxuICBuZWFyOiAxLFxuICBmYXI6IDEwMDAsXG4gIGdldEN1cnNvcjogZ2V0RGVmYXVsdEN1cnNvclxufTtcblxuLypcbiAqIE1hcHMgbW91c2UgaW50ZXJhY3Rpb24gdG8gYSBkZWNrLmdsIFZpZXdwb3J0XG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIE9yYml0Q29udHJvbGxlckpTIHtcbiAgLy8gUmV0dXJucyBhIGRlY2suZ2wgVmlld3BvcnQgaW5zdGFuY2UsIHRvIGJlIHVzZWQgd2l0aCB0aGUgRGVja0dMIGNvbXBvbmVudFxuICBzdGF0aWMgZ2V0Vmlld3BvcnQodmlld3BvcnQpIHtcbiAgICByZXR1cm4gbmV3IE9yYml0Vmlld3BvcnQodmlld3BvcnQpO1xuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBwcm9wcyA9IE9iamVjdC5hc3NpZ24oe30sIGRlZmF1bHRQcm9wcywgcHJvcHMpO1xuXG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIC8vIFdoZXRoZXIgdGhlIGN1cnNvciBpcyBkb3duXG4gICAgICBpc0RyYWdnaW5nOiBmYWxzZVxuICAgIH07XG5cbiAgICB0aGlzLmNhbnZhcyA9IHByb3BzLmNhbnZhcztcblxuICAgIGNvbnN0IGV2ZW50TWFuYWdlciA9IG5ldyBFdmVudE1hbmFnZXIodGhpcy5jYW52YXMpO1xuXG4gICAgdGhpcy5fZXZlbnRNYW5hZ2VyID0gZXZlbnRNYW5hZ2VyO1xuXG4gICAgdGhpcy5fY29udHJvbHMgPSBwcm9wcy5vcmJpdENvbnRyb2xzIHx8IG5ldyBWaWV3cG9ydENvbnRyb2xzKE9yYml0U3RhdGUpO1xuICAgIHRoaXMuX2NvbnRyb2xzLnNldE9wdGlvbnMoXG4gICAgICBPYmplY3QuYXNzaWduKHt9LCB0aGlzLnByb3BzLCB7XG4gICAgICAgIG9uU3RhdGVDaGFuZ2U6IHRoaXMuX29uSW50ZXJhY3RpdmVTdGF0ZUNoYW5nZS5iaW5kKHRoaXMpLFxuICAgICAgICBldmVudE1hbmFnZXJcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIHNldFByb3BzKHByb3BzKSB7XG4gICAgcHJvcHMgPSBPYmplY3QuYXNzaWduKHt9LCB0aGlzLnByb3BzLCBwcm9wcyk7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuXG4gICAgdGhpcy5fY29udHJvbHMuc2V0T3B0aW9ucyhwcm9wcyk7XG4gIH1cblxuICBmaW5hbGl6ZSgpIHtcbiAgICB0aGlzLl9ldmVudE1hbmFnZXIuZGVzdHJveSgpO1xuICB9XG5cbiAgX29uSW50ZXJhY3RpdmVTdGF0ZUNoYW5nZSh7aXNEcmFnZ2luZyA9IGZhbHNlfSkge1xuICAgIGlmIChpc0RyYWdnaW5nICE9PSB0aGlzLnN0YXRlLmlzRHJhZ2dpbmcpIHtcbiAgICAgIHRoaXMuc3RhdGUuaXNEcmFnZ2luZyA9IGlzRHJhZ2dpbmc7XG4gICAgICBjb25zdCB7Z2V0Q3Vyc29yfSA9IHRoaXMucHJvcHM7XG4gICAgICB0aGlzLmNhbnZhcy5zdHlsZS5jdXJzb3IgPSBnZXRDdXJzb3IodGhpcy5zdGF0ZSk7XG4gICAgfVxuICB9XG59XG5cbk9yYml0Q29udHJvbGxlckpTLmRpc3BsYXlOYW1lID0gJ09yYml0Q29udHJvbGxlcic7XG5PcmJpdENvbnRyb2xsZXJKUy5wcm9wVHlwZXMgPSBwcm9wVHlwZXM7XG5PcmJpdENvbnRyb2xsZXJKUy5kZWZhdWx0UHJvcHMgPSBkZWZhdWx0UHJvcHM7XG4iXX0=