// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { fp32 } from 'luma.gl';
import projectShader from './project.glsl';
import projectDeprecatedShader from '../../deprecated/shaderlib/project/project-deprecated.glsl';
import { getUniformsFromViewport } from './viewport-uniforms';

var INITIAL_MODULE_OPTIONS = {};

function getUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL_MODULE_OPTIONS;

  if (opts.viewport) {
    return getUniformsFromViewport(opts);
  }
  return {};
}

export default {
  name: 'project',
  dependencies: [fp32],
  vs: '' + projectShader + projectDeprecatedShader,
  getUniforms: getUniforms,
  deprecations: [
  // Removed custom picking uinforms
  // These don't really belong here but we need to check them for all shaders
  // the project module is by default included for all
  { type: 'uniform vec3', old: 'selectedPickingColor', new: "luma.gl's picking module" }, { type: 'uniform float', old: 'renderPickingBuffer', new: "luma.gl's picking module" }, { type: 'uniform float', old: 'pickingEnabled', new: "luma.gl's picking module" },

  // Removed project uniforms
  { type: 'uniform float', old: 'projectionMode', new: 'project_uCoordinateSystem' }, { type: 'uniform vec4', old: 'projectionCenter', new: 'project_uCenter' }, { type: 'uniform vec2', old: 'projectionOrigin' }, { type: 'uniform mat4', old: 'modelMatrix', new: 'project_uModelMatrix' }, { type: 'uniform mat4', old: 'viewMatrix' }, { type: 'uniform mat4', old: 'projectionMatrix', new: 'project_uViewProjectionMatrix' }, { type: 'uniform vec3', old: 'projectionPixelsPerUnit', new: 'project_uPixelsPerUnit' }, { type: 'uniform float', old: 'projectionScale', new: 'project_uScale' }, { type: 'uniform vec2', old: 'viewportSize', new: 'project_uViewportSize' }, { type: 'uniform float', old: 'devicePixelRatio', new: 'project_uDevicePixelRatio' }, { type: 'uniform vec3', old: 'cameraPos', new: 'project_uCameraPosition' },

  // Deprecated project functions
  { type: 'function', old: 'scale', new: 'project_scale', deprecated: 1 }, { type: 'function', old: 'preproject', new: 'project_position', deprecated: 1 }, { type: 'function', old: 'project', new: 'project_to_clipspace', deprecated: 1 }]
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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