// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "\nconst vec2 WORLD_SCALE_FP64 = vec2(81.4873275756836, 0.0000032873668232014097);\n\nuniform vec2 project64_uScale;\nuniform vec2 project_uViewProjectionMatrixFP64[16];\n\n// longitude: lnglat_fp64.xy; latitude: lnglat_fp64.zw\nvoid mercatorProject_fp64(vec4 lnglat_fp64, out vec2 out_val[2]) {\n\n#if defined(NVIDIA_FP64_WORKAROUND)\n  out_val[0] = sum_fp64(radians_fp64(lnglat_fp64.xy), PI_FP64 * ONE);\n#else\n  out_val[0] = sum_fp64(radians_fp64(lnglat_fp64.xy), PI_FP64);\n#endif\n  out_val[1] = sub_fp64(PI_FP64,\n    log_fp64(tan_fp64(sum_fp64(PI_4_FP64, radians_fp64(lnglat_fp64.zw) / 2.0))));\n  return;\n}\n\nvoid project_position_fp64(vec4 position_fp64, out vec2 out_val[2]) {\n  vec2 pos_fp64[2];\n  mercatorProject_fp64(position_fp64, pos_fp64);\n  vec2 x_fp64 = mul_fp64(pos_fp64[0], project64_uScale);\n  vec2 y_fp64 = mul_fp64(pos_fp64[1], project64_uScale);\n  out_val[0] = mul_fp64(x_fp64, WORLD_SCALE_FP64);\n  out_val[1] = mul_fp64(y_fp64, WORLD_SCALE_FP64);\n\n  return;\n}\n\nvec4 project_to_clipspace_fp64(vec2 vertex_pos_modelspace[4]) {\n  vec2 vertex_pos_clipspace[4];\n  mat4_vec4_mul_fp64(project_uViewProjectionMatrixFP64, vertex_pos_modelspace,\n    vertex_pos_clipspace);\n  return vec4(\n    vertex_pos_clipspace[0].x,\n    vertex_pos_clipspace[1].x,\n    vertex_pos_clipspace[2].x,\n    vertex_pos_clipspace[3].x\n    );\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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