// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { fp64 } from 'luma.gl';
import project from '../project/project';
import { fp64ify, fp64ifyMatrix4 } from '../../utils/fp64';
import memoize from '../../utils/memoize';

import project64Shader from './project64.glsl';

export default {
  name: 'project64',
  dependencies: [project, fp64],
  vs: project64Shader,
  getUniforms: getUniforms,
  deprecations: [{ type: 'uniform vec2', old: 'projectionFP64[16]', new: 'project_uViewProjectionMatrixFP64' }, { type: 'uniform vec2', old: 'projectionScaleFP64', new: 'project64_uScale' }]
};

// TODO - this module should calculate the 64 bit uniforms
// It is currently done by project to minimize duplicated work

var DEFAULT_MODULE_OPTIONS = {};
var getMemoizedUniforms = memoize(calculateUniforms);

function getUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT_MODULE_OPTIONS;
  var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  // These two uniforms are generated by the fp32 project module
  var project_uViewProjectionMatrix = context.project_uViewProjectionMatrix,
      project_uScale = context.project_uScale;


  if (project_uViewProjectionMatrix && project_uScale) {
    // We only need to update fp64 uniforms if fp32 projection is being updated
    return getMemoizedUniforms({ project_uViewProjectionMatrix: project_uViewProjectionMatrix, project_uScale: project_uScale });
  }
  return {};
}

function calculateUniforms(_ref) {
  var project_uViewProjectionMatrix = _ref.project_uViewProjectionMatrix,
      project_uScale = _ref.project_uScale;

  var glViewProjectionMatrixFP64 = fp64ifyMatrix4(project_uViewProjectionMatrix);
  var scaleFP64 = fp64ify(project_uScale);

  return {
    project_uViewProjectionMatrixFP64: glViewProjectionMatrixFP64,
    project64_uViewProjectionMatrix: glViewProjectionMatrixFP64,
    project64_uScale: scaleFP64
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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