var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { equals } from 'math.gl';
import assert from 'assert';

var TransitionInterpolator = function () {
  function TransitionInterpolator() {
    _classCallCheck(this, TransitionInterpolator);
  }

  _createClass(TransitionInterpolator, [{
    key: 'arePropsEqual',

    /**
     * Checks if two sets of props need transition in between
     * @param currentProps {object} - a list of viewport props
     * @param nextProps {object} - a list of viewport props
     * @returns {bool} - true if two props are equivalent
     */
    value: function arePropsEqual(currentProps, nextProps) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = (this.propNames || [])[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var key = _step.value;

          if (!equals(currentProps[key], nextProps[key])) {
            return false;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return true;
    }

    /**
     * Called before transition starts to validate/pre-process start and end props
     * @param startProps {object} - a list of starting viewport props
     * @param endProps {object} - a list of target viewport props
     * @returns {Object} {start, end} - start and end props to be passed
     *   to `interpolateProps`
     */

  }, {
    key: 'initializeProps',
    value: function initializeProps(startProps, endProps) {
      return { start: startProps, end: endProps };
    }

    /**
     * Returns viewport props in transition
     * @param startProps {object} - a list of starting viewport props
     * @param endProps {object} - a list of target viewport props
     * @param t {number} - a time factor between [0, 1]
     * @returns {object} - a list of interpolated viewport props
     */

  }, {
    key: 'interpolateProps',
    value: function interpolateProps(startProps, endProps, t) {
      assert(false, 'interpolateProps is not implemented');
    }
  }]);

  return TransitionInterpolator;
}();

export default TransitionInterpolator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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