// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Parse array or string color
function parseColor(color, target) {
  var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

  if (Array.isArray(color) || ArrayBuffer.isView(color)) {
    if (!target && color.length === 4) {
      return color;
    }

    target = target || [];
    target[index + 0] = color[0];
    target[index + 1] = color[1];
    target[index + 2] = color[2];
    target[index + 3] = color.length === 4 ? color[4] : 255;
    return target;
  }

  if (typeof color === 'string') {
    target = target || [];
    parseHexColor(color, target, index);
    return target;
  }

  return [0, 0, 0, 255];
}

// Parse a hex color
function parseHexColor(color, target, index) {
  if (color.length === 7) {
    var value = parseInt(color.substring(1), 16);
    target[index + 0] = Math.floor(value / 65536);
    target[index + 1] = Math.floor(value / 256 % 256);
    target[index + 2] = value % 256;
    target[index + 3] = 255;
  } else if (color.length === 9) {
    var _value = parseInt(color.substring(1), 16);
    target[index + 0] = Math.floor(_value / 16777216);
    target[index + 1] = Math.floor(_value / 65536 % 256);
    target[index + 2] = Math.floor(_value / 256 % 256);
    target[index + 3] = _value % 256;
  }
  return index + 4;
}

function setOpacity(color) {
  var opacity = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 127;

  return [color[0], color[1], color[2], opacity];
}

function applyOpacity(color) {
  var opacity = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 127;

  return [color[0], color[1], color[2], opacity];
}

// Named exports have a small perf hit in webpack, normally OK
// but for utils that will be called in tight inner loops, export as object
export default { parseColor: parseColor, setOpacity: setOpacity, applyOpacity: applyOpacity };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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