// Extensions to math.gl library. Intended to be folded back.

import vec4_multiply from 'gl-vec4/multiply';
import vec4_transformMat4 from 'gl-vec4/transformMat4';
import assert from 'assert';

export function transformVector(matrix, vector) {
  // Handle non-invertible matrix
  if (!matrix) {
    return null;
  }
  var result = vec4_transformMat4([0, 0, 0, 0], vector, matrix);
  var scale = 1 / result[3];
  vec4_multiply(result, result, [scale, scale, scale, scale]);
  return result;
}

// Helper, avoids low-precision 32 bit matrices from gl-matrix mat4.create()
export function createMat4() {
  return [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
}

// Extract camera vectors (move to math library?)
export function extractCameraVectors(_ref) {
  var viewMatrix = _ref.viewMatrix,
      viewMatrixInverse = _ref.viewMatrixInverse;

  // Read the translation from the inverse view matrix
  return {
    eye: [viewMatrixInverse[12], viewMatrixInverse[13], viewMatrixInverse[14]],
    direction: [viewMatrix[2], viewMatrix[6], viewMatrix[10]],
    up: [viewMatrix[1], viewMatrix[5], viewMatrix[9]]
  };
}

export function mod(value, divisor) {
  assert(Number.isFinite(value) && Number.isFinite(divisor));
  var modulus = value % divisor;
  return modulus < 0 ? divisor + modulus : modulus;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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