function isEqual(a, b) {
  if (a === b) {
    return true;
  }
  if (Array.isArray(a)) {
    // Special treatment for arrays: compare 1-level deep
    // This is to support equality of matrix/coordinate props
    var len = a.length;
    if (!b || b.length !== len) {
      return false;
    }

    for (var i = 0; i < len; i++) {
      if (a[i] !== b[i]) {
        return false;
      }
    }
    return true;
  }
  return false;
}

/**
 * Speed up consecutive function calls by caching the result of calls with identical input
 * https://en.wikipedia.org/wiki/Memoization
 * @param {function} compute - the function to be memoized
 */
export default function memoize(compute) {
  var cachedArgs = {};
  var cachedResult = void 0;

  return function (args) {
    for (var key in args) {
      if (!isEqual(args[key], cachedArgs[key])) {
        cachedResult = compute(args);
        cachedArgs = args;
        break;
      }
    }
    return cachedResult;
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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