var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import log from '../utils/log';
import { createMat4, extractCameraVectors } from '../utils/math-utils';

import { Matrix4, Vector3, equals as _equals } from 'math.gl';
import mat4_scale from 'gl-mat4/scale';
import mat4_translate from 'gl-mat4/translate';
import mat4_multiply from 'gl-mat4/multiply';
import mat4_invert from 'gl-mat4/invert';
import mat4_perspective from 'gl-mat4/perspective';

var ZERO_VECTOR = [0, 0, 0];

import { getDistanceScales as _getDistanceScales, getWorldPosition, getMeterZoom, worldToPixels, pixelsToWorld } from 'viewport-mercator-project';

import assert from 'assert';

var IDENTITY = createMat4();

var DEFAULT_DISTANCE_SCALES = {
  pixelsPerMeter: [1, 1, 1],
  metersPerPixel: [1, 1, 1],
  pixelsPerDegree: [1, 1, 1],
  degreesPerPixel: [1, 1, 1]
};

var DEFAULT_ZOOM = 0;

var ERR_ARGUMENT = 'Illegal argument to Viewport';

var Viewport = function () {
  /**
   * @classdesc
   * Manages coordinate system transformations for deck.gl.
   *
   * Note: The Viewport is immutable in the sense that it only has accessors.
   * A new viewport instance should be created if any parameters have changed.
   */
  /* eslint-disable complexity, max-statements */
  function Viewport() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Viewport);

    var _opts$id = opts.id,
        id = _opts$id === undefined ? null : _opts$id,
        _opts$x = opts.x,
        x = _opts$x === undefined ? 0 : _opts$x,
        _opts$y = opts.y,
        y = _opts$y === undefined ? 0 : _opts$y,
        _opts$width = opts.width,
        width = _opts$width === undefined ? 1 : _opts$width,
        _opts$height = opts.height,
        height = _opts$height === undefined ? 1 : _opts$height,
        _opts$viewMatrix = opts.viewMatrix,
        viewMatrix = _opts$viewMatrix === undefined ? IDENTITY : _opts$viewMatrix,
        _opts$projectionMatri = opts.projectionMatrix,
        projectionMatrix = _opts$projectionMatri === undefined ? null : _opts$projectionMatri,
        _opts$fovy = opts.fovy,
        fovy = _opts$fovy === undefined ? 75 : _opts$fovy,
        _opts$near = opts.near,
        near = _opts$near === undefined ? 0.1 : _opts$near,
        _opts$far = opts.far,
        far = _opts$far === undefined ? 1000 : _opts$far,
        _opts$longitude = opts.longitude,
        longitude = _opts$longitude === undefined ? null : _opts$longitude,
        _opts$latitude = opts.latitude,
        latitude = _opts$latitude === undefined ? null : _opts$latitude,
        _opts$zoom = opts.zoom,
        zoom = _opts$zoom === undefined ? null : _opts$zoom,
        _opts$position = opts.position,
        position = _opts$position === undefined ? null : _opts$position,
        _opts$modelMatrix = opts.modelMatrix,
        modelMatrix = _opts$modelMatrix === undefined ? null : _opts$modelMatrix,
        _opts$distanceScales = opts.distanceScales,
        distanceScales = _opts$distanceScales === undefined ? null : _opts$distanceScales;


    this.id = id || this.constructor.displayName || 'viewport';

    // Check if we have a geospatial anchor
    this.isGeospatial = Number.isFinite(latitude) && Number.isFinite(longitude);

    // Silently allow apps to send in w,h = 0,0
    this.x = x;
    this.y = y;
    this.width = width || 1;
    this.height = height || 1;

    this.zoom = zoom;
    if (!Number.isFinite(this.zoom)) {
      this.zoom = this.isGeospatial ? getMeterZoom({ latitude: latitude }) : DEFAULT_ZOOM;
    }
    this.scale = Math.pow(2, this.zoom);

    // Calculate distance scales if lng/lat/zoom are provided
    this.distanceScales = this.isGeospatial ? _getDistanceScales({ latitude: latitude, longitude: longitude, scale: this.scale }) : distanceScales || DEFAULT_DISTANCE_SCALES;

    this.focalDistance = opts.focalDistance || 1;

    this.distanceScales.metersPerPixel = new Vector3(this.distanceScales.metersPerPixel);
    this.distanceScales.pixelsPerMeter = new Vector3(this.distanceScales.pixelsPerMeter);

    this.position = ZERO_VECTOR;
    this.meterOffset = ZERO_VECTOR;
    if (position) {
      // Apply model matrix if supplied
      this.position = position;
      this.modelMatrix = modelMatrix;
      this.meterOffset = modelMatrix ? modelMatrix.transformVector(position) : position;
    }

    this.viewMatrixUncentered = viewMatrix;

    if (this.isGeospatial) {
      // Determine camera center
      this.center = getWorldPosition({
        longitude: longitude,
        latitude: latitude,
        scale: this.scale,
        distanceScales: this.distanceScales,
        meterOffset: this.meterOffset
      });

      // Make a centered version of the matrix for projection modes without an offset
      this.viewMatrix = new Matrix4()
      // Apply the uncentered view matrix
      .multiplyRight(this.viewMatrixUncentered)
      // The Mercator world coordinate system is upper left,
      // but GL expects lower left, so we flip it around the center after all transforms are done
      .scale([1, -1, 1])
      // And center it
      .translate(new Vector3(this.center || ZERO_VECTOR).negate());
    } else {
      this.center = position;
      this.viewMatrix = viewMatrix;
    }

    // Create a projection matrix if not supplied
    if (projectionMatrix) {
      this.projectionMatrix = projectionMatrix;
    } else {
      assert(Number.isFinite(fovy));
      var DEGREES_TO_RADIANS = Math.PI / 180;
      var fovyRadians = fovy * DEGREES_TO_RADIANS;
      var aspect = this.width / this.height;
      this.projectionMatrix = mat4_perspective([], fovyRadians, aspect, near, far);
    }

    // Init pixel matrices
    this._initMatrices();

    // Bind methods for easy access
    this.equals = this.equals.bind(this);
    this.project = this.project.bind(this);
    this.unproject = this.unproject.bind(this);
    this.projectFlat = this.projectFlat.bind(this);
    this.unprojectFlat = this.unprojectFlat.bind(this);
    this.getMatrices = this.getMatrices.bind(this);
  }
  /* eslint-enable complexity, max-statements */

  // Two viewports are equal if width and height are identical, and if
  // their view and projection matrices are (approximately) equal.


  _createClass(Viewport, [{
    key: 'equals',
    value: function equals(viewport) {
      if (!(viewport instanceof Viewport)) {
        return false;
      }

      return viewport.width === this.width && viewport.height === this.height && _equals(viewport.projectionMatrix, this.projectionMatrix) && _equals(viewport.viewMatrix, this.viewMatrix);
      // TODO - check distance scales?
    }

    /**
     * Projects xyz (possibly latitude and longitude) to pixel coordinates in window
     * using viewport projection parameters
     * - [longitude, latitude] to [x, y]
     * - [longitude, latitude, Z] => [x, y, z]
     * Note: By default, returns top-left coordinates for canvas/SVG type render
     *
     * @param {Array} lngLatZ - [lng, lat] or [lng, lat, Z]
     * @param {Object} opts - options
     * @param {Object} opts.topLeft=true - Whether projected coords are top left
     * @return {Array} - [x, y] or [x, y, z] in top left coords
     */

  }, {
    key: 'project',
    value: function project(xyz) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref$topLeft = _ref.topLeft,
          topLeft = _ref$topLeft === undefined ? true : _ref$topLeft;

      var _xyz = _slicedToArray(xyz, 3),
          x0 = _xyz[0],
          y0 = _xyz[1],
          _xyz$ = _xyz[2],
          z0 = _xyz$ === undefined ? 0 : _xyz$;

      var _projectFlat2 = this.projectFlat([x0, y0]),
          _projectFlat3 = _slicedToArray(_projectFlat2, 2),
          X = _projectFlat3[0],
          Y = _projectFlat3[1];

      var coord = worldToPixels([X, Y, z0], this.pixelProjectionMatrix);

      var _coord = _slicedToArray(coord, 2),
          x = _coord[0],
          y = _coord[1];

      var y2 = topLeft ? y : this.height - y;
      return xyz.length === 2 ? [x, y2] : [x, y2, coord[2]];
    }

    /**
     * Unproject pixel coordinates on screen onto world coordinates,
     * (possibly [lon, lat]) on map.
     * - [x, y] => [lng, lat]
     * - [x, y, z] => [lng, lat, Z]
     * @param {Array} xyz -
     * @param {Object} opts - options
     * @param {Object} opts.topLeft=true - Whether origin is top left
     * @return {Array|null} - [lng, lat, Z] or [X, Y, Z]
     */

  }, {
    key: 'unproject',
    value: function unproject(xyz) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref2$topLeft = _ref2.topLeft,
          topLeft = _ref2$topLeft === undefined ? true : _ref2$topLeft,
          targetZ = _ref2.targetZ;

      var _xyz2 = _slicedToArray(xyz, 3),
          x = _xyz2[0],
          y = _xyz2[1],
          z = _xyz2[2];

      var y2 = topLeft ? y : this.height - y;
      var coord = pixelsToWorld([x, y2, z], this.pixelUnprojectionMatrix, targetZ);

      var _unprojectFlat2 = this.unprojectFlat(coord),
          _unprojectFlat3 = _slicedToArray(_unprojectFlat2, 2),
          X = _unprojectFlat3[0],
          Y = _unprojectFlat3[1];

      if (Number.isFinite(z)) {
        // Has depth component
        return [X, Y, coord[2]];
      }

      return Number.isFinite(targetZ) ? [X, Y, targetZ] : [X, Y];
    }

    // NON_LINEAR PROJECTION HOOKS
    // Used for web meractor projection

    /**
     * Project [lng,lat] on sphere onto [x,y] on 512*512 Mercator Zoom 0 tile.
     * Performs the nonlinear part of the web mercator projection.
     * Remaining projection is done with 4x4 matrices which also handles
     * perspective.
     * @param {Array} lngLat - [lng, lat] coordinates
     *   Specifies a point on the sphere to project onto the map.
     * @return {Array} [x,y] coordinates.
     */

  }, {
    key: 'projectFlat',
    value: function projectFlat(_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          x = _ref4[0],
          y = _ref4[1];

      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;

      return this._projectFlat.apply(this, arguments);
    }

    /**
     * Unproject world point [x,y] on map onto {lat, lon} on sphere
     * @param {object|Vector} xy - object with {x,y} members
     *  representing point on projected map plane
     * @return {GeoCoordinates} - object with {lat,lon} of point on sphere.
     *   Has toArray method if you need a GeoJSON Array.
     *   Per cartographic tradition, lat and lon are specified as degrees.
     */

  }, {
    key: 'unprojectFlat',
    value: function unprojectFlat(xyz) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;

      return this._unprojectFlat.apply(this, arguments);
    }

    // TODO - why do we need these?

  }, {
    key: '_projectFlat',
    value: function _projectFlat(xyz) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;

      return xyz;
    }
  }, {
    key: '_unprojectFlat',
    value: function _unprojectFlat(xyz) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;

      return xyz;
    }
  }, {
    key: 'getMercatorParams',
    value: function getMercatorParams() {
      var lngLat = this._addMetersToLngLat([this.longitude || 0, this.latitude || 0], this.meterOffset);
      return {
        longitude: lngLat[0],
        latitude: lngLat[1]
      };
    }
  }, {
    key: 'isMapSynched',
    value: function isMapSynched() {
      return false;
    }
  }, {
    key: 'getDistanceScales',
    value: function getDistanceScales() {
      var coordinateOrigin = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

      if (coordinateOrigin) {
        return _getDistanceScales({
          longitude: coordinateOrigin[0],
          latitude: coordinateOrigin[1],
          scale: this.scale,
          highPrecision: true
        });
      }
      return this.distanceScales;
    }
  }, {
    key: 'getMatrices',
    value: function getMatrices() {
      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref5$modelMatrix = _ref5.modelMatrix,
          modelMatrix = _ref5$modelMatrix === undefined ? null : _ref5$modelMatrix;

      var modelViewProjectionMatrix = this.viewProjectionMatrix;
      var pixelProjectionMatrix = this.pixelProjectionMatrix;
      var pixelUnprojectionMatrix = this.pixelUnprojectionMatrix;

      if (modelMatrix) {
        modelViewProjectionMatrix = mat4_multiply([], this.viewProjectionMatrix, modelMatrix);
        pixelProjectionMatrix = mat4_multiply([], this.pixelProjectionMatrix, modelMatrix);
        pixelUnprojectionMatrix = mat4_invert([], pixelProjectionMatrix);
      }

      var matrices = Object.assign({
        modelViewProjectionMatrix: modelViewProjectionMatrix,
        viewProjectionMatrix: this.viewProjectionMatrix,
        viewMatrix: this.viewMatrix,
        projectionMatrix: this.projectionMatrix,

        // project/unproject between pixels and world
        pixelProjectionMatrix: pixelProjectionMatrix,
        pixelUnprojectionMatrix: pixelUnprojectionMatrix,

        width: this.width,
        height: this.height,
        scale: this.scale
      });

      return matrices;
    }

    // EXPERIMENTAL METHODS

  }, {
    key: 'getCameraPosition',
    value: function getCameraPosition() {
      return this.cameraPosition;
    }
  }, {
    key: 'getCameraDirection',
    value: function getCameraDirection() {
      return this.cameraDirection;
    }
  }, {
    key: 'getCameraUp',
    value: function getCameraUp() {
      return this.cameraUp;
    }

    // TODO - these are duplicating WebMercator methods

  }, {
    key: '_addMetersToLngLat',
    value: function _addMetersToLngLat(lngLatZ, xyz) {
      var _lngLatZ = _slicedToArray(lngLatZ, 3),
          lng = _lngLatZ[0],
          lat = _lngLatZ[1],
          _lngLatZ$ = _lngLatZ[2],
          Z = _lngLatZ$ === undefined ? 0 : _lngLatZ$;

      var _metersToLngLatDelta2 = this._metersToLngLatDelta(xyz),
          _metersToLngLatDelta3 = _slicedToArray(_metersToLngLatDelta2, 3),
          deltaLng = _metersToLngLatDelta3[0],
          deltaLat = _metersToLngLatDelta3[1],
          _metersToLngLatDelta4 = _metersToLngLatDelta3[2],
          deltaZ = _metersToLngLatDelta4 === undefined ? 0 : _metersToLngLatDelta4;

      return lngLatZ.length === 2 ? [lng + deltaLng, lat + deltaLat] : [lng + deltaLng, lat + deltaLat, Z + deltaZ];
    }
  }, {
    key: '_metersToLngLatDelta',
    value: function _metersToLngLatDelta(xyz) {
      var _xyz3 = _slicedToArray(xyz, 3),
          x = _xyz3[0],
          y = _xyz3[1],
          _xyz3$ = _xyz3[2],
          z = _xyz3$ === undefined ? 0 : _xyz3$;

      assert(Number.isFinite(x) && Number.isFinite(y) && Number.isFinite(z), ERR_ARGUMENT);
      var _distanceScales = this.distanceScales,
          pixelsPerMeter = _distanceScales.pixelsPerMeter,
          degreesPerPixel = _distanceScales.degreesPerPixel;

      var deltaLng = x * pixelsPerMeter[0] * degreesPerPixel[0];
      var deltaLat = y * pixelsPerMeter[1] * degreesPerPixel[1];
      return xyz.length === 2 ? [deltaLng, deltaLat] : [deltaLng, deltaLat, z];
    }

    // INTERNAL METHODS

  }, {
    key: '_initMatrices',
    value: function _initMatrices() {
      // Note: As usual, matrix operations should be applied in "reverse" order
      // since vectors will be multiplied in from the right during transformation
      var vpm = createMat4();
      mat4_multiply(vpm, vpm, this.projectionMatrix);
      mat4_multiply(vpm, vpm, this.viewMatrix);
      this.viewProjectionMatrix = vpm;

      // console.log('VPM', this.viewMatrix, this.projectionMatrix, this.viewProjectionMatrix);

      // Calculate inverse view matrix
      this.viewMatrixInverse = mat4_invert([], this.viewMatrix) || this.viewMatrix;

      // Decompose camera directions

      var _extractCameraVectors = extractCameraVectors({
        viewMatrix: this.viewMatrix,
        viewMatrixInverse: this.viewMatrixInverse
      }),
          eye = _extractCameraVectors.eye,
          direction = _extractCameraVectors.direction,
          up = _extractCameraVectors.up;

      this.cameraPosition = eye;
      this.cameraDirection = direction;
      this.cameraUp = up;

      // console.log(this.cameraPosition, this.cameraDirection, this.cameraUp);

      /*
       * Builds matrices that converts preprojected lngLats to screen pixels
       * and vice versa.
       * Note: Currently returns bottom-left coordinates!
       * Note: Starts with the GL projection matrix and adds steps to the
       *       scale and translate that matrix onto the window.
       * Note: WebGL controls clip space to screen projection with gl.viewport
       *       and does not need this step.
       */

      // matrix for conversion from world location to screen (pixel) coordinates
      var m = createMat4();
      mat4_scale(m, m, [this.width / 2, -this.height / 2, 1]);
      mat4_translate(m, m, [1, -1, 0]);
      mat4_multiply(m, m, this.viewProjectionMatrix);
      this.pixelProjectionMatrix = m;

      this.pixelUnprojectionMatrix = mat4_invert(createMat4(), this.pixelProjectionMatrix);
      if (!this.pixelUnprojectionMatrix) {
        log.warn('Pixel project matrix not invertible');
        // throw new Error('Pixel project matrix not invertible');
      }
    }
  }]);

  return Viewport;
}();

export default Viewport;


Viewport.displayName = 'Viewport';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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