var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// View and Projection Matrix calculations for mapbox-js style
// map view properties
import Viewport from './viewport';

import { lngLatToWorld, worldToLngLat, pixelsToWorld, getProjectionMatrix, getViewMatrix, fitBounds as _fitBounds } from 'viewport-mercator-project';

// TODO - import from viewport-mercator-project
// import {fitBounds} from '../viewport-mercator-project/fit-bounds';

// TODO - import from math.gl
/* eslint-disable camelcase */
import vec2_add from 'gl-vec2/add';
import vec2_negate from 'gl-vec2/negate';

import assert from 'assert';

var ERR_ARGUMENT = 'Illegal argument to WebMercatorViewport';

var WebMercatorViewport = function (_Viewport) {
  _inherits(WebMercatorViewport, _Viewport);

  /**
   * @classdesc
   * Creates view/projection matrices from mercator params
   * Note: The Viewport is immutable in the sense that it only has accessors.
   * A new viewport instance should be created if any parameters have changed.
   */
  /* eslint-disable complexity, max-statements */
  function WebMercatorViewport() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, WebMercatorViewport);

    var _opts$latitude = opts.latitude,
        latitude = _opts$latitude === undefined ? 0 : _opts$latitude,
        _opts$longitude = opts.longitude,
        longitude = _opts$longitude === undefined ? 0 : _opts$longitude,
        _opts$zoom = opts.zoom,
        zoom = _opts$zoom === undefined ? 11 : _opts$zoom,
        _opts$pitch = opts.pitch,
        pitch = _opts$pitch === undefined ? 0 : _opts$pitch,
        _opts$bearing = opts.bearing,
        bearing = _opts$bearing === undefined ? 0 : _opts$bearing,
        _opts$farZMultiplier = opts.farZMultiplier,
        farZMultiplier = _opts$farZMultiplier === undefined ? 10 : _opts$farZMultiplier;
    var width = opts.width,
        height = opts.height,
        _opts$altitude = opts.altitude,
        altitude = _opts$altitude === undefined ? 1.5 : _opts$altitude;

    // Silently allow apps to send in 0,0 to facilitate isomorphic render etc

    width = width || 1;
    height = height || 1;

    // Altitude - prevent division by 0
    // TODO - just throw an Error instead?
    altitude = Math.max(0.75, altitude);

    var projectionMatrix = getProjectionMatrix({
      width: width,
      height: height,
      pitch: pitch,
      altitude: altitude,
      farZMultiplier: farZMultiplier
    });

    // The uncentered matrix allows us two move the center addition to the
    // shader (cheap) which gives a coordinate system that has its center in
    // the layer's center position. This makes rotations and other modelMatrx
    // transforms much more useful.
    var viewMatrixUncentered = getViewMatrix({
      height: height,
      pitch: pitch,
      bearing: bearing,
      altitude: altitude
    });

    // Save parameters
    var _this = _possibleConstructorReturn(this, (WebMercatorViewport.__proto__ || Object.getPrototypeOf(WebMercatorViewport)).call(this, Object.assign({}, opts, {
      // x, y, position, ...
      // TODO / hack - prevent vertical offsets if not FirstPersonViewport
      position: opts.position && [opts.position[0], opts.position[1], 0],
      width: width,
      height: height,
      viewMatrix: viewMatrixUncentered,
      longitude: longitude,
      latitude: latitude,
      zoom: zoom,
      projectionMatrix: projectionMatrix,
      focalDistance: 1 // Viewport is already carefully set up to "focus" on ground
    })));

    _this.latitude = latitude;
    _this.longitude = longitude;
    _this.zoom = zoom;
    _this.pitch = pitch;
    _this.bearing = bearing;
    _this.altitude = altitude;

    // Bind methods
    _this.metersToLngLatDelta = _this.metersToLngLatDelta.bind(_this);
    _this.lngLatDeltaToMeters = _this.lngLatDeltaToMeters.bind(_this);
    _this.addMetersToLngLat = _this.addMetersToLngLat.bind(_this);

    Object.freeze(_this);
    return _this;
  }
  /* eslint-enable complexity, max-statements */

  /**
   * Project [lng,lat] on sphere onto [x,y] on 512*512 Mercator Zoom 0 tile.
   * Performs the nonlinear part of the web mercator projection.
   * Remaining projection is done with 4x4 matrices which also handles
   * perspective.
   *
   * @param {Array} lngLat - [lng, lat] coordinates
   *   Specifies a point on the sphere to project onto the map.
   * @return {Array} [x,y] coordinates.
   */


  _createClass(WebMercatorViewport, [{
    key: '_projectFlat',
    value: function _projectFlat(lngLat) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;

      return lngLatToWorld(lngLat, scale);
    }

    /**
     * Unproject world point [x,y] on map onto {lat, lon} on sphere
     *
     * @param {object|Vector} xy - object with {x,y} members
     *  representing point on projected map plane
     * @return {GeoCoordinates} - object with {lat,lon} of point on sphere.
     *   Has toArray method if you need a GeoJSON Array.
     *   Per cartographic tradition, lat and lon are specified as degrees.
     */

  }, {
    key: '_unprojectFlat',
    value: function _unprojectFlat(xy) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;

      return worldToLngLat(xy, scale);
    }

    /**
     * Converts a meter offset to a lnglat offset
     *
     * Note: Uses simple linear approximation around the viewport center
     * Error increases with size of offset (roughly 1% per 100km)
     *
     * @param {[Number,Number]|[Number,Number,Number]) xyz - array of meter deltas
     * @return {[Number,Number]|[Number,Number,Number]) - array of [lng,lat,z] deltas
     */

  }, {
    key: 'metersToLngLatDelta',
    value: function metersToLngLatDelta(xyz) {
      var _xyz = _slicedToArray(xyz, 3),
          x = _xyz[0],
          y = _xyz[1],
          _xyz$ = _xyz[2],
          z = _xyz$ === undefined ? 0 : _xyz$;

      assert(Number.isFinite(x) && Number.isFinite(y) && Number.isFinite(z), ERR_ARGUMENT);
      var _distanceScales = this.distanceScales,
          pixelsPerMeter = _distanceScales.pixelsPerMeter,
          degreesPerPixel = _distanceScales.degreesPerPixel;

      var deltaLng = x * pixelsPerMeter[0] * degreesPerPixel[0];
      var deltaLat = y * pixelsPerMeter[1] * degreesPerPixel[1];
      return xyz.length === 2 ? [deltaLng, deltaLat] : [deltaLng, deltaLat, z];
    }

    /**
     * Converts a lnglat offset to a meter offset
     *
     * Note: Uses simple linear approximation around the viewport center
     * Error increases with size of offset (roughly 1% per 100km)
     *
     * @param {[Number,Number]|[Number,Number,Number]) deltaLngLatZ - array of [lng,lat,z] deltas
     * @return {[Number,Number]|[Number,Number,Number]) - array of meter deltas
     */

  }, {
    key: 'lngLatDeltaToMeters',
    value: function lngLatDeltaToMeters(deltaLngLatZ) {
      var _deltaLngLatZ = _slicedToArray(deltaLngLatZ, 3),
          deltaLng = _deltaLngLatZ[0],
          deltaLat = _deltaLngLatZ[1],
          _deltaLngLatZ$ = _deltaLngLatZ[2],
          deltaZ = _deltaLngLatZ$ === undefined ? 0 : _deltaLngLatZ$;

      assert(Number.isFinite(deltaLng) && Number.isFinite(deltaLat) && Number.isFinite(deltaZ), ERR_ARGUMENT);
      var _distanceScales2 = this.distanceScales,
          pixelsPerDegree = _distanceScales2.pixelsPerDegree,
          metersPerPixel = _distanceScales2.metersPerPixel;

      var deltaX = deltaLng * pixelsPerDegree[0] * metersPerPixel[0];
      var deltaY = deltaLat * pixelsPerDegree[1] * metersPerPixel[1];
      return deltaLngLatZ.length === 2 ? [deltaX, deltaY] : [deltaX, deltaY, deltaZ];
    }

    /**
     * Add a meter delta to a base lnglat coordinate, returning a new lnglat array
     *
     * Note: Uses simple linear approximation around the viewport center
     * Error increases with size of offset (roughly 1% per 100km)
     *
     * @param {[Number,Number]|[Number,Number,Number]) lngLatZ - base coordinate
     * @param {[Number,Number]|[Number,Number,Number]) xyz - array of meter deltas
     * @return {[Number,Number]|[Number,Number,Number]) array of [lng,lat,z] deltas
     */

  }, {
    key: 'addMetersToLngLat',
    value: function addMetersToLngLat(lngLatZ, xyz) {
      var _lngLatZ = _slicedToArray(lngLatZ, 3),
          lng = _lngLatZ[0],
          lat = _lngLatZ[1],
          _lngLatZ$ = _lngLatZ[2],
          Z = _lngLatZ$ === undefined ? 0 : _lngLatZ$;

      var _metersToLngLatDelta = this.metersToLngLatDelta(xyz),
          _metersToLngLatDelta2 = _slicedToArray(_metersToLngLatDelta, 3),
          deltaLng = _metersToLngLatDelta2[0],
          deltaLat = _metersToLngLatDelta2[1],
          _metersToLngLatDelta3 = _metersToLngLatDelta2[2],
          deltaZ = _metersToLngLatDelta3 === undefined ? 0 : _metersToLngLatDelta3;

      return lngLatZ.length === 2 ? [lng + deltaLng, lat + deltaLat] : [lng + deltaLng, lat + deltaLat, Z + deltaZ];
    }

    /**
     * Get the map center that place a given [lng, lat] coordinate at screen
     * point [x, y]
     *
     * @param {Array} lngLat - [lng,lat] coordinates
     *   Specifies a point on the sphere.
     * @param {Array} pos - [x,y] coordinates
     *   Specifies a point on the screen.
     * @return {Array} [lng,lat] new map center.
     */

  }, {
    key: 'getMapCenterByLngLatPosition',
    value: function getMapCenterByLngLatPosition(_ref) {
      var lngLat = _ref.lngLat,
          pos = _ref.pos;

      var fromLocation = pixelsToWorld(pos, this.pixelUnprojectionMatrix);
      var toLocation = lngLatToWorld(lngLat, this.scale);

      var translate = vec2_add([], toLocation, vec2_negate([], fromLocation));
      var newCenter = vec2_add([], this.center, translate);

      return worldToLngLat(newCenter, this.scale);
    }

    // Legacy method name

  }, {
    key: 'getLocationAtPoint',
    value: function getLocationAtPoint(_ref2) {
      var lngLat = _ref2.lngLat,
          pos = _ref2.pos;

      return this.getMapCenterByLngLatPosition({ lngLat: lngLat, pos: pos });
    }

    /**
     * Returns a new viewport that fit around the given rectangle.
     * Only supports non-perspective mode.
     * @param {Array} bounds - [[lon, lat], [lon, lat]]
     * @param {Number} [options.padding] - The amount of padding in pixels to add to the given bounds.
     * @param {Array} [options.offset] - The center of the given bounds relative to the map's center,
     *    [x, y] measured in pixels.
     * @returns {WebMercatorViewport}
     */

  }, {
    key: 'fitBounds',
    value: function fitBounds(bounds) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var width = this.width,
          height = this.height;

      var _fitBounds2 = _fitBounds(Object.assign({ width: width, height: height, bounds: bounds }, options)),
          longitude = _fitBounds2.longitude,
          latitude = _fitBounds2.latitude,
          zoom = _fitBounds2.zoom;

      return new WebMercatorViewport({ width: width, height: height, longitude: longitude, latitude: latitude, zoom: zoom });
    }

    // TODO - should support user supplied constraints

  }, {
    key: 'isMapSynched',
    value: function isMapSynched() {
      var EPSILON = 0.000001;
      var MAPBOX_LIMITS = {
        pitch: 60,
        zoom: 40
      };

      var pitch = this.pitch,
          zoom = this.zoom;


      return pitch <= MAPBOX_LIMITS.pitch + EPSILON && zoom <= MAPBOX_LIMITS.zoom + EPSILON;
    }
  }]);

  return WebMercatorViewport;
}(Viewport);

export default WebMercatorViewport;


WebMercatorViewport.displayName = 'WebMercatorViewport';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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