// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME mesh-layer-vs-64\n\n// Scale the model\nuniform float sizeScale;\n\n// Primitive attributes\nattribute vec3 positions;\nattribute vec3 normals;\nattribute vec2 texCoords;\n\n// Instance attributes\nattribute vec3 instancePositions;\nattribute vec2 instancePositions64xy;\nattribute float instanceAngles;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Outputs to fragment shader\nvarying vec4 vColor;\nvarying vec2 vTexCoord;\nvarying float vLightWeight;\n\nvoid main(void) {\n  // Calculate arrow offset (from instance position)\n  float angle = instanceAngles;\n  mat2 rotationMatrix = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));\n\n  vec3 offset = positions;\n  offset = project_scale(offset * sizeScale);\n  offset = vec3(rotationMatrix * offset.xy, offset.z);\n\n  gl_Position = project_position_and_offset_to_clipspace_fp64(\n    instancePositions, instancePositions64xy, offset\n  );\n\n  picking_setPickingColor(instancePickingColors);\n\n  vTexCoord = texCoords;\n  vColor = instanceColors;\n\n  //   lightWeight = getLightWeight(\n  //     position_worldspace.xyz, // the w component is always 1.0\n  //     normals\n  //   );\n  // vLightWeight = getLightWeight(pos, normals);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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