export default "\n#define SHADER_NAME mesh-layer-vs\n\n// Scale the model\nuniform float sizeScale;\n\n// Primitive attributes\nattribute vec3 positions;\nattribute vec3 normals;\nattribute vec2 texCoords;\n\n// Instance attributes\nattribute vec3 instancePositions;\nattribute float instanceAngles;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Outputs to fragment shader\nvarying vec2 vTexCoord;\nvarying vec4 vColor;\nvarying float vLightWeight;\n\nvoid main(void) {\n  vec3 instancePos = project_position(instancePositions);\n\n  float angle = instanceAngles;\n  mat2 rotationMatrix = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));\n\n  vec3 pos = positions;\n  pos = project_scale(pos * sizeScale);\n  pos = vec3(rotationMatrix * pos.xy, pos.z);\n  gl_Position = project_to_clipspace(vec4(instancePos + pos, 1.0));\n\n  // TODO - transform normals\n\n  picking_setPickingColor(instancePickingColors);\n\n  vTexCoord = texCoords;\n  vColor = instanceColors;\n  vLightWeight = getLightWeight(pos, normals);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9leHBlcmltZW50YWwtbGF5ZXJzL3NyYy9tZXNoLWxheWVyL21lc2gtbGF5ZXItdmVydGV4Lmdsc2wuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEiLCJmaWxlIjoibWVzaC1sYXllci12ZXJ0ZXguZ2xzbC5qcyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBkZWZhdWx0IGBcbiNkZWZpbmUgU0hBREVSX05BTUUgbWVzaC1sYXllci12c1xuXG4vLyBTY2FsZSB0aGUgbW9kZWxcbnVuaWZvcm0gZmxvYXQgc2l6ZVNjYWxlO1xuXG4vLyBQcmltaXRpdmUgYXR0cmlidXRlc1xuYXR0cmlidXRlIHZlYzMgcG9zaXRpb25zO1xuYXR0cmlidXRlIHZlYzMgbm9ybWFscztcbmF0dHJpYnV0ZSB2ZWMyIHRleENvb3JkcztcblxuLy8gSW5zdGFuY2UgYXR0cmlidXRlc1xuYXR0cmlidXRlIHZlYzMgaW5zdGFuY2VQb3NpdGlvbnM7XG5hdHRyaWJ1dGUgZmxvYXQgaW5zdGFuY2VBbmdsZXM7XG5hdHRyaWJ1dGUgdmVjNCBpbnN0YW5jZUNvbG9ycztcbmF0dHJpYnV0ZSB2ZWMzIGluc3RhbmNlUGlja2luZ0NvbG9ycztcblxuLy8gT3V0cHV0cyB0byBmcmFnbWVudCBzaGFkZXJcbnZhcnlpbmcgdmVjMiB2VGV4Q29vcmQ7XG52YXJ5aW5nIHZlYzQgdkNvbG9yO1xudmFyeWluZyBmbG9hdCB2TGlnaHRXZWlnaHQ7XG5cbnZvaWQgbWFpbih2b2lkKSB7XG4gIHZlYzMgaW5zdGFuY2VQb3MgPSBwcm9qZWN0X3Bvc2l0aW9uKGluc3RhbmNlUG9zaXRpb25zKTtcblxuICBmbG9hdCBhbmdsZSA9IGluc3RhbmNlQW5nbGVzO1xuICBtYXQyIHJvdGF0aW9uTWF0cml4ID0gbWF0Mihjb3MoYW5nbGUpLCAtc2luKGFuZ2xlKSwgc2luKGFuZ2xlKSwgY29zKGFuZ2xlKSk7XG5cbiAgdmVjMyBwb3MgPSBwb3NpdGlvbnM7XG4gIHBvcyA9IHByb2plY3Rfc2NhbGUocG9zICogc2l6ZVNjYWxlKTtcbiAgcG9zID0gdmVjMyhyb3RhdGlvbk1hdHJpeCAqIHBvcy54eSwgcG9zLnopO1xuICBnbF9Qb3NpdGlvbiA9IHByb2plY3RfdG9fY2xpcHNwYWNlKHZlYzQoaW5zdGFuY2VQb3MgKyBwb3MsIDEuMCkpO1xuXG4gIC8vIFRPRE8gLSB0cmFuc2Zvcm0gbm9ybWFsc1xuXG4gIHBpY2tpbmdfc2V0UGlja2luZ0NvbG9yKGluc3RhbmNlUGlja2luZ0NvbG9ycyk7XG5cbiAgdlRleENvb3JkID0gdGV4Q29vcmRzO1xuICB2Q29sb3IgPSBpbnN0YW5jZUNvbG9ycztcbiAgdkxpZ2h0V2VpZ2h0ID0gZ2V0TGlnaHRXZWlnaHQocG9zLCBub3JtYWxzKTtcbn1cbmA7XG4iXX0=