function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { Geometry } from 'luma.gl';

var Arrow2DGeometry = function (_Geometry) {
  _inherits(Arrow2DGeometry, _Geometry);

  function Arrow2DGeometry() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Arrow2DGeometry);

    return _possibleConstructorReturn(this, (Arrow2DGeometry.__proto__ || Object.getPrototypeOf(Arrow2DGeometry)).call(this, Object.assign({}, opts, {
      attributes: getArrowAttributes(opts)
    })));
  }

  return Arrow2DGeometry;
}(Geometry);

export default Arrow2DGeometry;


function getArrowAttributes(_ref) {
  var _ref$length = _ref.length,
      length = _ref$length === undefined ? 1 : _ref$length,
      _ref$headSize = _ref.headSize,
      headSize = _ref$headSize === undefined ? 0.2 : _ref$headSize,
      _ref$tailWidth = _ref.tailWidth,
      tailWidth = _ref$tailWidth === undefined ? 0.05 : _ref$tailWidth,
      _ref$tailStart = _ref.tailStart,
      tailStart = _ref$tailStart === undefined ? 0.05 : _ref$tailStart;

  var texCoords = [
  // HEAD
  0.5, 1.0, 0, 0.5 - headSize / 2, 1.0 - headSize, 0, 0.5 + headSize / 2, 1.0 - headSize, 0, 0.5 - tailWidth / 2, tailStart, 0, 0.5 + tailWidth / 2, 1.0 - headSize, 0, 0.5 + tailWidth / 2, tailStart, 0, 0.5 - tailWidth / 2, tailStart, 0, 0.5 - tailWidth / 2, 1.0 - headSize, 0, 0.5 + tailWidth / 2, 1.0 - headSize, 0];

  var normals = [0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1];

  // Center and scale
  var positions = new Array(texCoords.length);
  for (var i = 0; i < texCoords.length / 3; i++) {
    var i3 = i * 3;
    positions[i3 + 0] = (texCoords[i3 + 0] - 0.5) * length;
    positions[i3 + 1] = (texCoords[i3 + 1] - 0.5) * length;
    positions[i3 + 2] = 0;
  }
  return {
    positions: new Float32Array(positions),
    normals: new Float32Array(normals),
    texCoords: new Float32Array(texCoords)
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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