import { Vector2 } from 'math.gl';

function getLineLength(vPoints) {
  // calculate total length
  var lineLength = 0;
  for (var i = 0; i < vPoints.length - 1; i++) {
    lineLength += vPoints[i].distance(vPoints[i + 1]);
  }
  return lineLength;
}

var DEFAULT_COLOR = [0, 0, 0, 255];
var DEFAULT_DIRECTION = { forward: true, backward: false };

export default function createPathMarkers(_ref) {
  var data = _ref.data,
      _ref$getPath = _ref.getPath,
      getPath = _ref$getPath === undefined ? function (x) {
    return x.path;
  } : _ref$getPath,
      _ref$getDirection = _ref.getDirection,
      getDirection = _ref$getDirection === undefined ? function (x) {
    return x.direction;
  } : _ref$getDirection,
      _ref$getColor = _ref.getColor,
      getColor = _ref$getColor === undefined ? function (x) {
    return DEFAULT_COLOR;
  } : _ref$getColor,
      _ref$getMarkerPercent = _ref.getMarkerPercentages,
      getMarkerPercentages = _ref$getMarkerPercent === undefined ? function (x) {
    return [0.5];
  } : _ref$getMarkerPercent,
      projectFlat = _ref.projectFlat;

  var markers = [];

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var object = _step.value;

      var path = getPath(object);
      var direction = getDirection(object) || DEFAULT_DIRECTION;
      var color = getColor(object);

      var vPoints = path.map(function (p) {
        return new Vector2(p);
      });
      var vPointsReverse = vPoints.slice(0).reverse();

      // calculate total length
      var lineLength = getLineLength(vPoints);

      // Ask for where to put markers
      var percentages = getMarkerPercentages(object, { lineLength: lineLength });

      // Create the markers
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = percentages[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var percentage = _step2.value;

          if (direction.forward) {
            var marker = createMarkerAlongPath({
              path: vPoints,
              percentage: percentage,
              lineLength: lineLength,
              color: color,
              object: object,
              projectFlat: projectFlat
            });
            markers.push(marker);
          }

          if (direction.backward) {
            var _marker = createMarkerAlongPath({
              path: vPointsReverse,
              percentage: percentage,
              lineLength: lineLength,
              color: color,
              object: object,
              projectFlat: projectFlat
            });
            markers.push(_marker);
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return markers;
}

function createMarkerAlongPath(_ref2) {
  var path = _ref2.path,
      percentage = _ref2.percentage,
      lineLength = _ref2.lineLength,
      color = _ref2.color,
      object = _ref2.object,
      projectFlat = _ref2.projectFlat;

  var distanceAlong = lineLength * percentage;
  var currentDistance = 0;
  var previousDistance = 0;
  var i = 0;
  for (i = 0; i < path.length - 1; i++) {
    currentDistance += path[i].distance(path[i + 1]);
    if (currentDistance > distanceAlong) {
      break;
    }
    previousDistance = currentDistance;
  }

  var vDirection = path[i + 1].clone().subtract(path[i]).normalize();
  var along = distanceAlong - previousDistance;
  var vCenter = vDirection.clone().multiply(new Vector2(along, along)).add(path[i]);

  var vDirection2 = new Vector2(projectFlat(path[i + 1])).subtract(projectFlat(path[i]));
  var angle = -vDirection2.verticalAngle() * 180 / Math.PI;

  return { position: [vCenter.x, vCenter.y, 0], angle: angle, color: color, object: object };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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