// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME solid-polygon-layer-vertex-shader\n\nattribute vec2 vertexPositions;\nattribute vec3 positions;\nattribute vec3 nextPositions;\nattribute float elevations;\nattribute vec4 colors;\nattribute vec3 pickingColors;\n\nuniform float isSideVertex;\nuniform float extruded;\nuniform float elevationScale;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nvoid main(void) {\n\n  vec3 pos;\n  vec3 normal;\n\n  if (isSideVertex > 0.5) {\n    pos = mix(positions, nextPositions, vertexPositions.x);\n  } else {\n    pos = positions;\n  }\n  if (extruded > 0.5) {\n    pos.z += elevations * vertexPositions.y;\n  }\n\n  vec4 position_worldspace = vec4(project_position(\n    vec3(pos.xy, pos.z * elevationScale)),\n    1.0\n  );\n  gl_Position = project_to_clipspace(position_worldspace);\n\n  float lightWeight = 1.0;\n  \n  if (extruded > 0.5) {\n    if (isSideVertex > 0.5) {\n      normal = vec3(positions.y - nextPositions.y, nextPositions.x - positions.x, 0.0);\n      normal = project_normal(normal);\n    } else {\n      normal = vec3(0.0, 0.0, 1.0);\n    }\n\n    // Here, the input parameters should be\n    // position_worldspace.xyz / position_worldspace.w.\n    // However, this calculation generates all zeros on\n    // MacBook Pro with Intel Iris Pro GPUs for unclear reasons.\n    // (see https://github.com/uber/deck.gl/issues/559)\n    // Since the w component is always 1.0 in our shaders,\n    // we decided to just provide xyz component of position_worldspace\n    // to the getLightWeight() function\n    lightWeight = getLightWeight(position_worldspace.xyz, normal);\n  }\n\n  vec3 lightWeightedColor = lightWeight * colors.rgb;\n  vColor = vec4(lightWeightedColor, colors.a * opacity) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(pickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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