var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { COORDINATE_SYSTEM, Layer, experimental } from 'deck.gl';
var enable64bitSupport = experimental.enable64bitSupport,
    get = experimental.get;

import { GL, Model, Geometry } from 'luma.gl';

// Polygon geometry generation is managed by the polygon tesselator
import { PolygonTesselator } from './polygon-tesselator';

import vs from './solid-polygon-layer-vertex.glsl';
import vs64 from './solid-polygon-layer-vertex-64.glsl';
import fs from './solid-polygon-layer-fragment.glsl';

var defaultLineColor = [0x0, 0x0, 0x0, 0xff];
var defaultFillColor = [0x0, 0x0, 0x0, 0xff];

var defaultProps = {
  filled: true,
  // Whether to extrude
  extruded: false,
  // Whether to draw a GL.LINES wireframe of the polygon
  wireframe: false,
  fp64: false,

  // elevation multiplier
  elevationScale: 1,

  // Accessor for polygon geometry
  getPolygon: function getPolygon(f) {
    return get(f, 'polygon') || get(f, 'geometry.coordinates');
  },
  // Accessor for extrusion height
  getElevation: function getElevation(f) {
    return get(f, 'elevation') || get(f, 'properties.height') || 0;
  },
  // Accessor for colors
  getFillColor: function getFillColor(f) {
    return get(f, 'fillColor') || get(f, 'properties.color') || defaultFillColor;
  },
  getLineColor: function getLineColor(f) {
    return get(f, 'lineColor') || get(f, 'properties.color') || defaultLineColor;
  },

  // Optional settings for 'lighting' shader module
  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.05,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [2.0, 0.0, 0.0, 0.0],
    numberOfLights: 2
  }
};

// Side model attributes
var SIDE_FILL_POSITIONS = new Float32Array([
// top left corner
0, 1,
// bottom left corner
0, 0,
// top right corner
1, 1,
// bottom right corner
1, 0]);
var SIDE_WIRE_POSITIONS = new Float32Array([
// top right corner
1, 1,
// top left corner
0, 1,
// bottom left corner
0, 0,
// bottom right corner
1, 0]);

// Model types
var ATTRIBUTE_MAPS = {
  TOP: {
    indices: { instanced: 0 },
    positions: { instanced: 0 },
    positions64xyLow: { instanced: 0 },
    elevations: { instanced: 0 },
    fillColors: { name: 'colors', instanced: 0 },
    pickingColors: { instanced: 0 }
  },
  SIDE: {
    positions: { instanced: 1 },
    positions64xyLow: { instanced: 1 },
    nextPositions: { instanced: 1 },
    nextPositions64xyLow: { instanced: 1 },
    elevations: { instanced: 1 },
    fillColors: { name: 'colors', instanced: 1 },
    pickingColors: { instanced: 1 }
  },
  WIRE: {
    positions: { instanced: 1 },
    positions64xyLow: { instanced: 1 },
    nextPositions: { instanced: 1 },
    nextPositions64xyLow: { instanced: 1 },
    elevations: { instanced: 1 },
    lineColors: { name: 'colors', instanced: 1 },
    pickingColors: { instanced: 1 }
  }
};

var SolidPolygonLayer = function (_Layer) {
  _inherits(SolidPolygonLayer, _Layer);

  function SolidPolygonLayer() {
    _classCallCheck(this, SolidPolygonLayer);

    return _possibleConstructorReturn(this, (SolidPolygonLayer.__proto__ || Object.getPrototypeOf(SolidPolygonLayer)).apply(this, arguments));
  }

  _createClass(SolidPolygonLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: ['project64', 'lighting', 'picking'] } : { vs: vs, fs: fs, modules: ['lighting', 'picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var gl = this.context.gl;

      this.setState({
        numInstances: 0,
        IndexType: gl.getExtension('OES_element_index_uint') ? Uint32Array : Uint16Array
      });

      var attributeManager = this.getAttributeManager();
      var noAlloc = true;
      /* eslint-disable max-len */
      attributeManager.add({
        indices: { size: 1, isIndexed: true, update: this.calculateIndices, noAlloc: noAlloc },
        positions: {
          size: 3,
          accessor: ['extruded', 'fp64'],
          update: this.calculatePositions,
          noAlloc: noAlloc
        },
        nextPositions: {
          size: 3,
          accessor: ['extruded', 'fp64'],
          update: this.calculateNextPositions,
          noAlloc: noAlloc
        },
        elevations: {
          size: 1,
          accessor: ['extruded', 'getElevation'],
          update: this.calculateElevations,
          noAlloc: noAlloc
        },
        fillColors: {
          alias: 'colors',
          size: 4,
          type: GL.UNSIGNED_BYTE,
          accessor: 'getFillColor',
          update: this.calculateFillColors,
          noAlloc: noAlloc
        },
        lineColors: {
          alias: 'colors',
          size: 4,
          type: GL.UNSIGNED_BYTE,
          accessor: 'getLineColor',
          update: this.calculateLineColors,
          noAlloc: noAlloc
        },
        pickingColors: { size: 3, type: GL.UNSIGNED_BYTE, update: this.calculatePickingColors, noAlloc: noAlloc }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();

        if (props.fp64 && props.coordinateSystem === COORDINATE_SYSTEM.LNGLAT) {
          /* eslint-disable max-len */
          attributeManager.add({
            positions64xyLow: { size: 2, accessor: 'fp64', update: this.calculatePositionsLow },
            nextPositions64xyLow: { size: 2, accessor: 'fp64', update: this.calculateNextPositionsLow }
          });
          /* eslint-enable max-len */
        } else {
          attributeManager.remove(['positions64xyLow', 'nextPositions64xyLow']);
        }
      }
    }
  }, {
    key: 'draw',
    value: function draw(_ref2) {
      var uniforms = _ref2.uniforms;
      var _props = this.props,
          extruded = _props.extruded,
          lightSettings = _props.lightSettings,
          elevationScale = _props.elevationScale;


      var renderUniforms = Object.assign({}, uniforms, {
        extruded: extruded ? 1.0 : 0.0,
        elevationScale: elevationScale
      }, lightSettings);

      this.state.models.forEach(function (model) {
        model.render(renderUniforms);
      });
    }
  }, {
    key: 'updateState',
    value: function updateState(updateParams) {
      _get(SolidPolygonLayer.prototype.__proto__ || Object.getPrototypeOf(SolidPolygonLayer.prototype), 'updateState', this).call(this, updateParams);

      this.updateGeometry(updateParams);
      this.updateAttribute(updateParams);

      var props = updateParams.props,
          oldProps = updateParams.oldProps;


      var regenerateModels = props.fp64 !== oldProps.fp64 || props.filled !== oldProps.filled || props.extruded !== oldProps.extruded || props.wireframe !== oldProps.wireframe;

      if (regenerateModels) {
        this.setState(Object.assign({
          // Set a flag to set attributes to new models
          modelsChanged: true
        }, this._getModels(this.context.gl)));
      }

      if (props.extruded !== oldProps.extruded) {
        this.state.attributeManager.invalidate('extruded');
      }
      if (props.fp64 !== oldProps.fp64) {
        this.state.attributeManager.invalidate('fp64');
      }
    }
  }, {
    key: 'updateGeometry',
    value: function updateGeometry(_ref3) {
      var props = _ref3.props,
          oldProps = _ref3.oldProps,
          changeFlags = _ref3.changeFlags;

      var geometryConfigChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getPolygon);

      // When the geometry config  or the data is changed,
      // tessellator needs to be invoked
      if (geometryConfigChanged) {
        // TODO - avoid creating a temporary array here: let the tesselator iterate
        var polygons = props.data.map(props.getPolygon);

        this.setState({
          polygonTesselator: new PolygonTesselator({ polygons: polygons, IndexType: this.state.IndexType })
        });

        this.state.attributeManager.invalidateAll();
      }

      if (geometryConfigChanged || props.extruded !== oldProps.extruded || props.fp64 !== oldProps.fp64) {
        this.state.polygonTesselator.updatePositions({
          fp64: props.fp64,
          extruded: props.extruded
        });
      }
    }
  }, {
    key: 'updateAttributes',
    value: function updateAttributes(props) {
      var _state = this.state,
          attributeManager = _state.attributeManager,
          modelsChanged = _state.modelsChanged;

      // Figure out data length

      attributeManager.update({
        data: props.data,
        numInstances: 0,
        props: props,
        buffers: props,
        context: this,
        // Don't worry about non-attribute props
        ignoreUnknownAttributes: true
      });

      if (modelsChanged) {
        this._updateAttributes(attributeManager.attributes);
        // clear the flag
        this.setState({ modelsChanged: false });
      } else {
        var changedAttributes = attributeManager.getChangedAttributes({ clearChangedFlags: true });
        this._updateAttributes(changedAttributes);
      }
    }
  }, {
    key: '_updateAttributes',
    value: function _updateAttributes(attributes) {
      var modelsByName = this.state.modelsByName;


      for (var modelName in modelsByName) {
        var model = modelsByName[modelName];

        if (modelName === 'TOP') {
          model.setVertexCount(this.state.numVertex);
        } else {
          model.setInstanceCount(this.state.numInstances);
        }

        var attributeMap = ATTRIBUTE_MAPS[modelName];
        var newAttributes = {};
        for (var attributeName in attributes) {
          var attribute = attributes[attributeName];
          var attributeOverride = attributeMap[attributeName];

          if (attributeOverride) {
            var newAttribute = Object.assign({}, attribute, attributeOverride);
            newAttributes[attributeOverride.name || attributeName] = newAttribute;
          }
        }
        model.setAttributes(newAttributes);
      }
    }
  }, {
    key: '_getModels',
    value: function _getModels(gl) {
      var _props2 = this.props,
          id = _props2.id,
          filled = _props2.filled,
          extruded = _props2.extruded,
          wireframe = _props2.wireframe;


      var models = {};

      if (filled) {
        models.TOP = new Model(gl, Object.assign({}, this.getShaders(), {
          id: id + '-top',
          geometry: new Geometry({
            drawMode: GL.TRIANGLES,
            attributes: {
              vertexPositions: { size: 2, isGeneric: true, value: new Float32Array([0, 1]) },
              nextPositions: { size: 3, isGeneric: true, value: new Float32Array(3) },
              nextPositions64xyLow: { size: 2, isGeneric: true, value: new Float32Array(2) }
            }
          }),
          uniforms: {
            isSideVertex: 0
          },
          vertexCount: 0,
          isIndexed: true,
          shaderCache: this.context.shaderCache
        }));
      }
      if (filled && extruded) {
        models.SIDE = new Model(gl, Object.assign({}, this.getShaders(), {
          id: id + '-side',
          geometry: new Geometry({
            drawMode: GL.TRIANGLE_STRIP,
            vertexCount: 4,
            attributes: {
              vertexPositions: { size: 2, value: SIDE_FILL_POSITIONS }
            }
          }),
          uniforms: {
            isSideVertex: 1
          },
          isInstanced: 1,
          shaderCache: this.context.shaderCache
        }));
      }
      if (extruded && wireframe) {
        models.WIRE = new Model(gl, Object.assign({}, this.getShaders(), {
          id: id + '-wire',
          geometry: new Geometry({
            drawMode: GL.LINE_STRIP,
            vertexCount: 4,
            attributes: {
              vertexPositions: { size: 2, value: SIDE_WIRE_POSITIONS }
            }
          }),
          uniforms: {
            isSideVertex: 1
          },
          isInstanced: 1,
          shaderCache: this.context.shaderCache
        }));
      }

      return {
        models: [models.WIRE, models.SIDE, models.TOP].filter(Boolean),
        modelsByName: models
      };
    }
  }, {
    key: 'calculateIndices',
    value: function calculateIndices(attribute) {
      attribute.value = this.state.polygonTesselator.indices();
      attribute.target = GL.ELEMENT_ARRAY_BUFFER;
      var numVertex = attribute.value.length / attribute.size;
      this.setState({ numVertex: numVertex });
    }
  }, {
    key: 'calculatePositions',
    value: function calculatePositions(attribute) {
      attribute.value = this.state.polygonTesselator.positions();
      var numInstances = attribute.value.length / attribute.size;
      this.setState({ numInstances: numInstances });
    }
  }, {
    key: 'calculatePositionsLow',
    value: function calculatePositionsLow(attribute) {
      attribute.value = this.state.polygonTesselator.positions64xyLow();
    }
  }, {
    key: 'calculateNextPositions',
    value: function calculateNextPositions(attribute) {
      attribute.value = this.state.polygonTesselator.nextPositions();
    }
  }, {
    key: 'calculateNextPositionsLow',
    value: function calculateNextPositionsLow(attribute) {
      attribute.value = this.state.polygonTesselator.nextPositions64xyLow();
    }
  }, {
    key: 'calculateElevations',
    value: function calculateElevations(attribute) {
      var _this2 = this;

      if (this.props.extruded) {
        attribute.isGeneric = false;
        attribute.value = this.state.polygonTesselator.elevations({
          getElevation: function getElevation(polygonIndex) {
            return _this2.props.getElevation(_this2.props.data[polygonIndex]);
          }
        });
      } else {
        attribute.isGeneric = true;
        attribute.value = new Float32Array(1);
      }
    }
  }, {
    key: 'calculateFillColors',
    value: function calculateFillColors(attribute) {
      var _this3 = this;

      attribute.value = this.state.polygonTesselator.colors({
        key: 'fillColors',
        getColor: function getColor(polygonIndex) {
          return _this3.props.getFillColor(_this3.props.data[polygonIndex]);
        }
      });
    }
  }, {
    key: 'calculateLineColors',
    value: function calculateLineColors(attribute) {
      var _this4 = this;

      attribute.value = this.state.polygonTesselator.colors({
        key: 'lineColors',
        getColor: function getColor(polygonIndex) {
          return _this4.props.getLineColor(_this4.props.data[polygonIndex]);
        }
      });
    }

    // Override the default picking colors calculation

  }, {
    key: 'calculatePickingColors',
    value: function calculatePickingColors(attribute) {
      attribute.value = this.state.polygonTesselator.pickingColors();
    }
  }]);

  return SolidPolygonLayer;
}(Layer);

export default SolidPolygonLayer;


SolidPolygonLayer.layerName = 'SolidPolygonLayer';
SolidPolygonLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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